/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.feedstreamservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class StreamSchema
extends VersionedObjectWithAttributes {
    private static final String SCHEMA_TYPR = "SCHEMA_TYPR";
    private static final String PREFIX_COLUMNS = "PREFIX_COLUMNS";
    private StreamType streamType = StreamType.PARTITIONKEY;
    private SchemaType schemaType = SchemaType.FEEDSTREAM;
    private byte[] sequenceFamilyName = FeedStreamUtils.SEQUENCE_FAMILY_NAME_BYTES;
    private byte[] idempotentFamilyName = null;
    private byte[] valueFamilyName = FeedStreamUtils.VALUE_FAMILY_NAME_BYTES;
    private byte[] hashColumnName = FeedStreamUtils.HASH_COLUMN_NAME_BYTES;
    private byte[] streamNameColumnName = FeedStreamUtils.STREAM_NAME_COLUMN_NAME_BYTES;
    private byte[] bodyColumnName = FeedStreamUtils.BODY_COLUMN_NAME_BYTES;
    private byte[] messageIdColumnName = FeedStreamUtils.MESSAGE_ID_COLUMN_NAME_BYTES;
    private byte[] idempotentIdColumnName = FeedStreamUtils.IDEMPOTENT_ID_COLUMN_NAME_BYTES;
    private byte[] zeroColumnName = FeedStreamUtils.ZERO_COLUMN_NAME_BYTES;
    private List<LColumn> sequenceSchema = null;
    private List<LColumn> idempotentSchema = null;
    private ColumnKey messageIdColumnKey = null;
    private ColumnKey bodyColumnKey = null;
    private ColumnKey idempotentColumnKey = null;
    private TableMeta sequenceMeta = null;
    private TableMeta idempotentMeta = null;

    public StreamType getStreamType() {
        return this.streamType;
    }

    public void setStreamType(StreamType type) {
        this.streamType = type;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public boolean hasValueFamily() {
        return this.valueFamilyName != null;
    }

    public boolean hasIdempotentFamily() {
        return this.idempotentFamilyName != null;
    }

    public boolean hasSequenceFamily() {
        return this.sequenceFamilyName != null;
    }

    public boolean isIdempotentEnabled() {
        return this.hasIdempotentFamily();
    }

    public boolean isAutoIncrementEnabled() {
        return this.hasSequenceFamily();
    }

    public byte[] getValueFamilyName() {
        return this.valueFamilyName;
    }

    public void setValueFamilyName(byte[] valueFamilyName) {
        this.valueFamilyName = valueFamilyName;
    }

    public byte[] getIdempotentFamilyName() {
        return this.idempotentFamilyName;
    }

    public void setIdempotentFamilyName(byte[] idempotentFamilyName) {
        this.idempotentFamilyName = idempotentFamilyName;
    }

    public byte[] getSequenceFamilyName() {
        return this.sequenceFamilyName;
    }

    public void setSequenceFamilyName(byte[] sequenceFamilyName) {
        this.sequenceFamilyName = sequenceFamilyName;
    }

    public byte[] getHashColumnName() {
        return this.hashColumnName;
    }

    public void setHashColumnName(byte[] hash) {
        this.hashColumnName = hash;
    }

    public byte[] getStreamNameColumnName() {
        return this.streamNameColumnName;
    }

    public void setStreamNameColumnName(byte[] streamName) {
        this.streamNameColumnName = streamName;
    }

    public byte[] getMessageIdColumnName() {
        return this.messageIdColumnName;
    }

    public void setMessageIdColumnName(byte[] messageId) {
        this.messageIdColumnName = messageId;
    }

    public byte[] getIdempotentIdColumnName() {
        return this.idempotentIdColumnName;
    }

    public void setIdempotentIdColumnName(byte[] idempotentId) {
        this.idempotentIdColumnName = idempotentId;
    }

    public byte[] getBodyColumnName() {
        return this.bodyColumnName;
    }

    public void setBodyColumnName(byte[] body) {
        this.bodyColumnName = body;
    }

    public byte[] getZeroColumnName() {
        return this.zeroColumnName;
    }

    public void setZeroColumnName(byte[] zero) {
        this.zeroColumnName = zero;
    }

    public List<LColumn> getSequenceSchema() {
        return this.sequenceSchema;
    }

    public void setSequenceSchema(List<LColumn> sequenceSchema) {
        this.sequenceSchema = sequenceSchema;
    }

    public List<LColumn> getIdempotentSchema() {
        return this.idempotentSchema;
    }

    public void setIdempotentSchema(List<LColumn> idempotentSchema) {
        this.idempotentSchema = idempotentSchema;
    }

    public ColumnKey getBodyColumnKey() {
        return this.bodyColumnKey;
    }

    public ColumnKey getMessageIdColumnKey() {
        return this.messageIdColumnKey;
    }

    public ColumnKey getIdempotentColumnKey() {
        return this.idempotentColumnKey;
    }

    public TableMeta getSequenceMeta() {
        return this.sequenceMeta;
    }

    public void setSequenceMeta(TableMeta sequenceMeta) {
        this.sequenceMeta = sequenceMeta;
    }

    public TableMeta getIdempotentMeta() {
        return this.idempotentMeta;
    }

    public void setIdempotentMeta(TableMeta idempotentMeta) {
        this.idempotentMeta = idempotentMeta;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setUpAttributes();
        super.writeTo(out);
        if (this.streamType == null) {
            WritableUtils.writeString(out, null);
        } else {
            WritableUtils.writeString(out, this.streamType.toString());
        }
        Bytes.writeByteArray(out, this.sequenceFamilyName);
        Bytes.writeByteArray(out, this.idempotentFamilyName);
        Bytes.writeByteArray(out, this.valueFamilyName);
        Bytes.writeByteArray(out, this.hashColumnName);
        Bytes.writeByteArray(out, this.streamNameColumnName);
        Bytes.writeByteArray(out, this.messageIdColumnName);
        Bytes.writeByteArray(out, this.idempotentIdColumnName);
        Bytes.writeByteArray(out, this.bodyColumnName);
        Bytes.writeByteArray(out, this.zeroColumnName);
        if (this.sequenceSchema != null && this.sequenceSchema.size() > 0) {
            Bytes.writeByteArray(out, SchemaUtils.columnSchemasToBytes(this.sequenceSchema));
        } else {
            Bytes.writeByteArray(out, null);
        }
        if (this.idempotentSchema != null && this.idempotentSchema.size() > 0) {
            Bytes.writeByteArray(out, SchemaUtils.columnSchemasToBytes(this.idempotentSchema));
        } else {
            Bytes.writeByteArray(out, null);
        }
    }

    public void setUpAttributes() throws LindormException {
        if (this.schemaType != null) {
            this.setAttribute(SCHEMA_TYPR, this.schemaType.toString());
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        byte[] idempotentSchemaBytes;
        super.readFrom(in);
        this.initFromAttributes();
        String streamTypeString = WritableUtils.readString(in);
        this.streamType = streamTypeString == null ? StreamType.PARTITIONKEY : StreamType.fromString(streamTypeString);
        this.sequenceFamilyName = Bytes.readByteArrayNullable(in);
        this.idempotentFamilyName = Bytes.readByteArrayNullable(in);
        this.valueFamilyName = Bytes.readByteArrayNullable(in);
        this.hashColumnName = Bytes.readByteArrayNullable(in);
        this.streamNameColumnName = Bytes.readByteArrayNullable(in);
        this.messageIdColumnName = Bytes.readByteArrayNullable(in);
        this.idempotentIdColumnName = Bytes.readByteArrayNullable(in);
        this.bodyColumnName = Bytes.readByteArrayNullable(in);
        this.zeroColumnName = Bytes.readByteArrayNullable(in);
        byte[] sequenceSchemaBytes = Bytes.readByteArrayNullable(in);
        if (sequenceSchemaBytes != null) {
            this.sequenceSchema = SchemaUtils.bytesToColumnSchemas(sequenceSchemaBytes);
        }
        if ((idempotentSchemaBytes = Bytes.readByteArrayNullable(in)) != null) {
            this.idempotentSchema = SchemaUtils.bytesToColumnSchemas(idempotentSchemaBytes);
        }
        this.init();
    }

    private void initFromAttributes() throws LindormException {
        byte[] schemaTypeBytes = this.getAttribute(SCHEMA_TYPR);
        this.schemaType = schemaTypeBytes != null ? SchemaType.fromString(Bytes.toString(schemaTypeBytes)) : SchemaType.FEEDSTREAM;
    }

    private void init() {
        this.messageIdColumnKey = new ColumnKey(this.messageIdColumnName);
        this.bodyColumnKey = new ColumnKey(this.valueFamilyName, this.bodyColumnName);
        this.idempotentColumnKey = new ColumnKey(this.valueFamilyName, this.idempotentIdColumnName);
    }

    public byte[] getBytes() {
        try {
            return LindormObjectUtils.getBytes(this);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void fromBytes(byte[] bytes) {
        try {
            LindormObjectUtils.getWritable(bytes, this);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("StreamSchema => [");
        str.append("SequenceFamily: " + Bytes.toStringBinary(this.sequenceFamilyName) + ", messageIdColumnName: " + Bytes.toStringBinary(this.messageIdColumnName));
        if (this.idempotentFamilyName != null) {
            str.append(", IdempotentFamily: " + Bytes.toStringBinary(this.idempotentFamilyName) + ", idempotentColumnName: " + Bytes.toStringBinary(this.idempotentIdColumnName));
        }
        if (this.schemaType != SchemaType.AUTOINCTABLE) {
            str.append(", ValueFamily: " + Bytes.toStringBinary(this.valueFamilyName) + ", bodyColumnName: " + Bytes.toStringBinary(this.bodyColumnName));
            str.append(", hashCollumnName: " + Bytes.toStringBinary(this.hashColumnName));
        }
        str.append("]");
        return str.toString();
    }

    public static enum StreamType {
        PARTITIONKEY("PARTITIONKEY"),
        PARTITION("PARTITION"),
        GLOBAL("GLOBAL");

        final String name;

        private StreamType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static StreamType fromString(String typeString) {
            for (StreamType type : StreamType.values()) {
                if (!type.getName().equals(typeString)) continue;
                return type;
            }
            throw new UnsupportedOperationException("Unknown Stream type" + typeString);
        }
    }

    public static enum SchemaType {
        FEEDSTREAM("feedstream"),
        AUTOINCTABLE("autoIncTable");

        final String name;

        private SchemaType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static SchemaType fromString(String typeString) {
            for (SchemaType type : SchemaType.values()) {
                if (!type.getName().equals(typeString)) continue;
                return type;
            }
            throw new UnsupportedOperationException("Unknown Stream schema type" + typeString);
        }
    }
}

