/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.function;

import com.alibaba.lindorm.client.core.types.LDataType;

public class ArgumentDescriptor {
    private final LDataType type;
    private boolean nullable = false;
    private Object defaultValue = null;

    public ArgumentDescriptor(LDataType type) {
        this.type = type;
    }

    public ArgumentDescriptor(LDataType type, boolean nullable) {
        this.type = type;
        this.nullable = nullable;
    }

    public ArgumentDescriptor(LDataType type, boolean nullable, Object defaultValue) {
        this.type = type;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
    }

    public LDataType getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static ArgumentDescriptor of(LDataType type) {
        return new ArgumentDescriptor(type);
    }

    public static ArgumentDescriptor of(LDataType type, boolean nullAble) {
        return new ArgumentDescriptor(type, nullAble);
    }

    public static ArgumentDescriptor of(LDataType type, boolean nullAble, Object defaultValue) {
        return new ArgumentDescriptor(type, nullAble, defaultValue);
    }
}

