/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.function;

import com.alibaba.lindorm.client.core.utils.Preconditions;

public class FunctionName {
    public final String namespace;
    public final String name;

    public FunctionName(String namespace, String name) {
        Preconditions.checkNotNull(name);
        this.namespace = namespace;
        this.name = name;
    }

    public static FunctionName nativeFunction(String name) {
        return new FunctionName("default", name);
    }

    public static FunctionName parse(String name) {
        Preconditions.checkNotNull(name);
        String[] splits = name.split("\\.");
        return splits.length > 1 ? new FunctionName(splits[0], splits[1]) : FunctionName.nativeFunction(splits[0]);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public FunctionName asNativeFunction() {
        return FunctionName.nativeFunction(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionName that = (FunctionName)o;
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.namespace != null ? this.namespace.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.namespace == null ? this.name : this.namespace + "." + this.name;
    }
}

