/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;

public class BlobClient {
    private String userName;
    private String password;
    private int pause;
    private int numRetries;
    private AmazonS3 client;
    private int refCount;

    public BlobClient(LindormClientConfig config) {
        this.userName = config.get("lindorm.client.username");
        this.password = config.get("lindorm.client.password");
        this.pause = config.getInt("lindorm.rpc.pause.time", 100);
        this.numRetries = config.getInt("lindorm.client.retries.number", 5);
        this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.getBlobEndpoint(), null))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(BlobClient.buildClientConfig(config))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.getBlobAccessKey(), config.getBlobsecretKey())))).build();
    }

    public void close() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    private static ClientConfiguration buildClientConfig(LindormClientConfig config) {
        ClientConfiguration configuration = new ClientConfiguration();
        configuration.setConnectionTimeout(config.getBlobConnectionTimeout());
        configuration.setMaxConnections(config.getBlobMaxConnections());
        configuration.setSocketTimeout(config.getBlobSocketTimeout());
        configuration.setRequestTimeout(config.getBlobRequestTimeout());
        configuration.setClientExecutionTimeout(config.getBlobExecuteTimeout());
        configuration.setConnectionMaxIdleMillis(config.getBlobMaxIdleInMills());
        return configuration;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPause() {
        return this.pause;
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public AmazonS3 getClient() {
        return this.client;
    }

    public void incrCount() {
        ++this.refCount;
    }

    public void desCount() {
        --this.refCount;
    }

    public boolean isZeroRef() {
        return this.refCount == 0;
    }
}

