/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class ClassNameCache {
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();
    private static final Class<?> NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
    public static final ClassNameCache INSTANCE = new ClassNameCache();

    private ClassNameCache() {
    }

    public Class<?> getClassByName(String name, ClassLoader cl) throws ClassNotFoundException {
        Class<?> ret = this.getClassByNameOrNull(name, cl);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassByNameOrNull(String name, ClassLoader cl) {
        Map<String, WeakReference<Class<Object>>> map;
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = CACHE_CLASSES;
        synchronized (map2) {
            map = CACHE_CLASSES.get(cl);
            if (map == null) {
                map = Collections.synchronizedMap(new WeakHashMap());
                CACHE_CLASSES.put(cl, map);
            }
        }
        Class<?> clazz = null;
        WeakReference<Class<Object>> ref = map.get(name);
        if (ref != null) {
            clazz = (Class<?>)ref.get();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name, true, cl);
            }
            catch (ClassNotFoundException var6) {
                map.put(name, new WeakReference(NEGATIVE_CACHE_SENTINEL));
                return null;
            }
            map.put(name, new WeakReference(clazz));
            return clazz;
        }
        return clazz == NEGATIVE_CACHE_SENTINEL ? null : clazz;
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }
}

