/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.annotions.DefaultAttributes;
import com.alibaba.lindorm.client.annotions.OptionalAttribute;
import com.alibaba.lindorm.client.core.ipc.LindormRawObject;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CompatibleVersionedObjectWithAttributes
extends VersionedObjectWithAttributes {
    public static final String PREFIX = "@";
    private static final Object CONVERTER_MAP_LOCK = new Object();
    private static Map<Integer, AttributesConverter> CODE_2_CONVERTER = Collections.EMPTY_MAP;
    private static Method CLASS_CODE_METHOD = null;
    private static Class<?> CLASS_CODE_DEFINED_CLASS = null;

    public CompatibleVersionedObjectWithAttributes() {
        AttributesConverter converter = this.getConverter();
        converter.setDefaultFields(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createConverter(int code, Class<? extends CompatibleVersionedObjectWithAttributes> clazz) {
        Object object = CONVERTER_MAP_LOCK;
        synchronized (object) {
            if (CODE_2_CONVERTER.get(code) != null) {
                return;
            }
            Field[] fields = clazz.getDeclaredFields();
            AttributesConverter converter = new AttributesConverter();
            for (Field f : fields) {
                FieldAccessor accessor;
                OptionalAttribute annotation = f.getAnnotation(OptionalAttribute.class);
                if (annotation == null) continue;
                if (f.getType().equals(Integer.TYPE)) {
                    accessor = new IntegerFieldAccessor(f, annotation, CompatibleVersionedObjectWithAttributes.checkAndGetDefaultAnnotation(f, DefaultAttributes.DefaultInt.class));
                } else if (f.getType().equals(Long.TYPE)) {
                    accessor = new LongFieldAccessor(f, annotation, CompatibleVersionedObjectWithAttributes.checkAndGetDefaultAnnotation(f, DefaultAttributes.DefaultLong.class));
                } else if (f.getType().equals(Float.TYPE)) {
                    accessor = new FloatFieldAccessor(f, annotation, CompatibleVersionedObjectWithAttributes.checkAndGetDefaultAnnotation(f, DefaultAttributes.DefaultFloat.class));
                } else if (f.getType().equals(Double.TYPE)) {
                    accessor = new DoubleFieldAccessor(f, annotation, CompatibleVersionedObjectWithAttributes.checkAndGetDefaultAnnotation(f, DefaultAttributes.DefaultDouble.class));
                } else if (f.getType().equals(Short.TYPE)) {
                    accessor = new ShortFieldAccessor(f, annotation, CompatibleVersionedObjectWithAttributes.checkAndGetDefaultAnnotation(f, DefaultAttributes.DefaultShort.class));
                } else if (f.getType().equals(String.class)) {
                    accessor = new StringFieldAccessor(f, annotation, CompatibleVersionedObjectWithAttributes.checkAndGetDefaultAnnotation(f, DefaultAttributes.DefaultString.class));
                } else if (f.getType().equals(Boolean.TYPE)) {
                    accessor = new BooleanFieldAccessor(f, annotation, CompatibleVersionedObjectWithAttributes.checkAndGetDefaultAnnotation(f, DefaultAttributes.DefaultBoolean.class));
                } else if (f.getType().equals(byte[].class)) {
                    CompatibleVersionedObjectWithAttributes.checkNoDefaultAnnotation(f);
                    accessor = new ByteArrayFieldAccessor(f, annotation);
                } else {
                    CompatibleVersionedObjectWithAttributes.throwTypeError("Bug: " + f.getType() + " is not supported by " + CompatibleVersionedObjectWithAttributes.class.getSimpleName());
                    return;
                }
                FieldAccessor previous = converter.attribute2Accessor.put(accessor.getAttributeName(), accessor);
                if (previous == null) continue;
                CompatibleVersionedObjectWithAttributes.throwTypeError("Bug: field[" + previous.field.getName() + "] has duplicated attribute name with field[" + accessor.field.getName() + "] ");
            }
            HashMap<Integer, AttributesConverter> newMap = new HashMap<Integer, AttributesConverter>(CODE_2_CONVERTER);
            newMap.put(code, converter);
            CODE_2_CONVERTER = newMap;
        }
    }

    private static void checkNoDefaultAnnotation(Field field) {
        Annotation[] declaredAnnotations;
        for (Annotation declaredAnnotation : declaredAnnotations = field.getDeclaredAnnotations()) {
            if (!DefaultAttributes.class.equals(declaredAnnotation.getClass().getEnclosingClass())) continue;
            CompatibleVersionedObjectWithAttributes.throwTypeError("Bug: [" + field.getType() + " " + field.getName() + "] do not support default value annotation: " + declaredAnnotation);
        }
    }

    private static <T extends Annotation> T checkAndGetDefaultAnnotation(Field field, Class<T> annotationType) {
        Annotation[] declaredAnnotations;
        if (!DefaultAttributes.class.equals(annotationType.getEnclosingClass())) {
            CompatibleVersionedObjectWithAttributes.throwTypeError("Bug: " + annotationType + " must be enclosed by " + DefaultAttributes.class);
        }
        for (Annotation declaredAnnotation : declaredAnnotations = field.getDeclaredAnnotations()) {
            if (!DefaultAttributes.class.equals(declaredAnnotation.getClass().getEnclosingClass()) || declaredAnnotation.getClass().equals(annotationType)) continue;
            CompatibleVersionedObjectWithAttributes.throwTypeError("Bug: [" + field.getType() + " " + field.getName() + "] 's default value type must be " + annotationType.getSimpleName());
        }
        return field.getAnnotation(annotationType);
    }

    @Override
    protected void readAttributes(DataInput in) throws IOException {
        super.readAttributes(in);
        this.getConverter().attributes2Field(this);
    }

    @Override
    protected void writeAttributes(DataOutput out) throws IOException {
        this.getConverter().fields2Attributes(this);
        super.writeAttributes(out);
    }

    private AttributesConverter getConverter() {
        Integer code = this.getClassCode();
        AttributesConverter converter = CODE_2_CONVERTER.get(code);
        if (converter == null) {
            CompatibleVersionedObjectWithAttributes.createConverter(code, this.getClass());
        }
        return CODE_2_CONVERTER.get(code);
    }

    private Integer getClassCode() {
        Integer code;
        this.lazyInitializeClassCodeMethod();
        try {
            code = (Integer)CLASS_CODE_METHOD.invoke(null, this.getClass());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        if (code == null) {
            CompatibleVersionedObjectWithAttributes.throwTypeError("Bug: the class code must be pre-defined in " + CLASS_CODE_DEFINED_CLASS);
            return null;
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitializeClassCodeMethod() {
        if (CLASS_CODE_METHOD == null) {
            Object object = CONVERTER_MAP_LOCK;
            synchronized (object) {
                this.lazyInitializeClassCodeDefinedClass();
                try {
                    Method classCodeMethod = CLASS_CODE_DEFINED_CLASS.getDeclaredMethod("getClassCode", Class.class);
                    classCodeMethod.setAccessible(true);
                    CLASS_CODE_METHOD = classCodeMethod;
                }
                catch (NoSuchMethodException e) {
                    CompatibleVersionedObjectWithAttributes.throwTypeError("Can't found getClassCode() in " + CLASS_CODE_DEFINED_CLASS);
                }
            }
        }
    }

    private void lazyInitializeClassCodeDefinedClass() {
        if (CLASS_CODE_DEFINED_CLASS != null) {
            return;
        }
        Class<Object> classCodeDefinedClass = null;
        try {
            classCodeDefinedClass = Class.forName("com.alibaba.lindorm.server.io.LindormObjectWritable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (classCodeDefinedClass == null) {
            classCodeDefinedClass = LindormRawObject.class;
        }
        CLASS_CODE_DEFINED_CLASS = classCodeDefinedClass;
    }

    private static void throwTypeError(String message) {
        CompatibleVersionedObjectWithAttributes.throwTypeError(message, null);
    }

    private static void throwTypeError(String message, Throwable e) {
        if (message != null && e != null) {
            throw new RuntimeException(message, e);
        }
        if (message != null && e == null) {
            throw new RuntimeException(message);
        }
        if (message == null && e != null) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException();
    }

    private static class AttributesConverter {
        Map<String, FieldAccessor> attribute2Accessor = new HashMap<String, FieldAccessor>();

        private AttributesConverter() {
        }

        void fields2Attributes(CompatibleVersionedObjectWithAttributes attributes) {
            try {
                for (Map.Entry<String, FieldAccessor> entry : this.attribute2Accessor.entrySet()) {
                    String attrName = entry.getKey();
                    FieldAccessor accessor = entry.getValue();
                    if (accessor.isDefaultValue(attributes)) continue;
                    attributes.setAttribute(attrName, accessor.get(attributes));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Bug: Impossible.", e);
            }
        }

        void attributes2Field(CompatibleVersionedObjectWithAttributes attributes) {
            try {
                Map<String, byte[]> attrs = attributes.getAttributesMap();
                for (Map.Entry<String, byte[]> entry : attrs.entrySet()) {
                    String attrName = entry.getKey();
                    byte[] attrValue = entry.getValue();
                    FieldAccessor accessor = this.attribute2Accessor.get(attrName);
                    if (accessor == null || attrValue == null) continue;
                    accessor.set(attributes, attrValue);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Bug: Impossible.", e);
            }
        }

        public void setDefaultFields(CompatibleVersionedObjectWithAttributes attributes) {
            try {
                for (Map.Entry<String, FieldAccessor> entry : this.attribute2Accessor.entrySet()) {
                    FieldAccessor accessor = entry.getValue();
                    accessor.setDefault(attributes);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Bug: Impossible.", e);
            }
        }
    }

    private static class ByteArrayFieldAccessor
    extends FieldAccessor {
        ByteArrayFieldAccessor(Field f, OptionalAttribute annotation) {
            super(f, annotation, null);
        }

        @Override
        byte[] get(Object obj) throws IllegalAccessException {
            return (byte[])this.field.get(obj);
        }

        @Override
        void set(Object obj, byte[] value) throws IllegalAccessException {
            this.field.set(obj, value);
        }

        @Override
        boolean isDefaultValue(Object obj) throws IllegalAccessException {
            return this.field.get(obj) == null;
        }

        @Override
        void setDefault(Object obj) {
        }
    }

    private static class StringFieldAccessor
    extends FieldAccessor<DefaultAttributes.DefaultString> {
        final DefaultAttributes.DefaultString defaultValue;

        StringFieldAccessor(Field f, OptionalAttribute annotation, DefaultAttributes.DefaultString def) {
            super(f, annotation, def);
            this.defaultValue = def;
        }

        @Override
        byte[] get(Object obj) throws IllegalAccessException {
            String string = (String)this.field.get(obj);
            if (string != null) {
                return Bytes.toBytes(string);
            }
            return null;
        }

        @Override
        void set(Object obj, byte[] value) throws IllegalAccessException {
            this.field.set(obj, Bytes.toString(value));
        }

        @Override
        boolean isDefaultValue(Object obj) throws IllegalAccessException {
            String objStr = (String)this.field.get(obj);
            if (objStr == null) {
                return true;
            }
            if (this.defaultValue == null) {
                return false;
            }
            return objStr.equals(this.defaultValue.value());
        }

        @Override
        void setDefault(Object obj) throws IllegalAccessException {
            if (this.defaultValue != null) {
                this.field.set(obj, this.defaultValue.value());
            }
        }
    }

    private static class DoubleFieldAccessor
    extends FieldAccessor<DefaultAttributes.DefaultDouble> {
        private final DefaultAttributes.DefaultDouble defaultValue;

        DoubleFieldAccessor(Field f, OptionalAttribute annotation, DefaultAttributes.DefaultDouble def) {
            super(f, annotation, def);
            this.defaultValue = def;
        }

        @Override
        byte[] get(Object obj) throws IllegalAccessException {
            return Bytes.toBytes(this.field.getDouble(obj));
        }

        @Override
        void set(Object obj, byte[] value) throws IllegalAccessException {
            this.field.set(obj, Bytes.toDouble(value));
        }

        @Override
        boolean isDefaultValue(Object obj) throws IllegalAccessException {
            return this.defaultValue != null && Double.compare(this.field.getDouble(obj), this.defaultValue.value()) == 0;
        }

        @Override
        void setDefault(Object obj) throws IllegalAccessException {
            if (this.defaultValue != null) {
                this.field.setDouble(obj, this.defaultValue.value());
            }
        }
    }

    private static class FloatFieldAccessor
    extends FieldAccessor<DefaultAttributes.DefaultFloat> {
        private final DefaultAttributes.DefaultFloat defaultValue;

        FloatFieldAccessor(Field f, OptionalAttribute annotation, DefaultAttributes.DefaultFloat def) {
            super(f, annotation, def);
            this.defaultValue = def;
        }

        @Override
        byte[] get(Object obj) throws IllegalAccessException {
            return Bytes.toBytes(this.field.getFloat(obj));
        }

        @Override
        void set(Object obj, byte[] value) throws IllegalAccessException {
            this.field.set(obj, Float.valueOf(Bytes.toFloat(value)));
        }

        @Override
        boolean isDefaultValue(Object obj) throws IllegalAccessException {
            return this.defaultValue != null && Float.compare(this.field.getFloat(obj), this.defaultValue.value()) == 0;
        }

        @Override
        void setDefault(Object obj) throws IllegalAccessException {
            if (this.defaultValue != null) {
                this.field.setFloat(obj, this.defaultValue.value());
            }
        }
    }

    private static class BooleanFieldAccessor
    extends FieldAccessor<DefaultAttributes.DefaultBoolean> {
        private final DefaultAttributes.DefaultBoolean defaultValue;

        BooleanFieldAccessor(Field f, OptionalAttribute annotation, DefaultAttributes.DefaultBoolean def) {
            super(f, annotation, def);
            this.defaultValue = def;
        }

        @Override
        byte[] get(Object obj) throws IllegalAccessException {
            return Bytes.toBytes(this.field.getBoolean(obj));
        }

        @Override
        void set(Object obj, byte[] value) throws IllegalAccessException {
            this.field.set(obj, Bytes.toBoolean(value));
        }

        @Override
        boolean isDefaultValue(Object obj) throws IllegalAccessException {
            return this.defaultValue != null && this.field.getBoolean(obj) == this.defaultValue.value();
        }

        @Override
        void setDefault(Object obj) throws IllegalAccessException {
            if (this.defaultValue != null) {
                this.field.setBoolean(obj, this.defaultValue.value());
            }
        }
    }

    private static class ShortFieldAccessor
    extends FieldAccessor<DefaultAttributes.DefaultShort> {
        private final DefaultAttributes.DefaultShort defaultValue;

        ShortFieldAccessor(Field f, OptionalAttribute annotation, DefaultAttributes.DefaultShort def) {
            super(f, annotation, def);
            this.defaultValue = def;
        }

        @Override
        byte[] get(Object obj) throws IllegalAccessException {
            return Bytes.toBytes(this.field.getShort(obj));
        }

        @Override
        void set(Object obj, byte[] value) throws IllegalAccessException {
            this.field.set(obj, Bytes.toShort(value));
        }

        @Override
        boolean isDefaultValue(Object obj) throws IllegalAccessException {
            return this.defaultValue != null && this.field.getShort(obj) == this.defaultValue.value();
        }

        @Override
        void setDefault(Object obj) throws IllegalAccessException {
            if (this.defaultValue != null) {
                this.field.setShort(obj, this.defaultValue.value());
            }
        }
    }

    private static class LongFieldAccessor
    extends FieldAccessor<DefaultAttributes.DefaultLong> {
        private final DefaultAttributes.DefaultLong defaultValue;

        LongFieldAccessor(Field f, OptionalAttribute annotation, DefaultAttributes.DefaultLong def) {
            super(f, annotation, def);
            this.defaultValue = def;
        }

        @Override
        byte[] get(Object obj) throws IllegalAccessException {
            return Bytes.toBytes(this.field.getLong(obj));
        }

        @Override
        void set(Object obj, byte[] value) throws IllegalAccessException {
            this.field.set(obj, Bytes.toLong(value));
        }

        @Override
        boolean isDefaultValue(Object obj) throws IllegalAccessException {
            return this.defaultValue != null && this.field.getLong(obj) == (long)this.defaultValue.value();
        }

        @Override
        void setDefault(Object obj) throws IllegalAccessException {
            if (this.defaultValue != null) {
                this.field.setLong(obj, this.defaultValue.value());
            }
        }
    }

    private static class IntegerFieldAccessor
    extends FieldAccessor<DefaultAttributes.DefaultInt> {
        IntegerFieldAccessor(Field f, OptionalAttribute annotation, DefaultAttributes.DefaultInt def) {
            super(f, annotation, def);
        }

        @Override
        byte[] get(Object obj) {
            try {
                return Bytes.toBytes(this.field.getInt(obj));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Bug: Impossible");
            }
        }

        @Override
        void set(Object obj, byte[] value) throws IllegalAccessException {
            this.field.set(obj, Bytes.toInt(value));
        }

        @Override
        boolean isDefaultValue(Object obj) throws IllegalAccessException {
            return this.defaultValue != null && this.field.getInt(obj) == ((DefaultAttributes.DefaultInt)this.defaultValue).value();
        }

        @Override
        void setDefault(Object obj) throws IllegalAccessException {
            if (this.defaultValue != null) {
                this.field.setInt(obj, ((DefaultAttributes.DefaultInt)this.defaultValue).value());
            }
        }
    }

    private static abstract class FieldAccessor<DefaultType extends Annotation> {
        protected final Field field;
        protected final OptionalAttribute annotation;
        private final String attrName;
        protected final DefaultType defaultValue;

        FieldAccessor(Field f, OptionalAttribute annotation, DefaultType defaultValue) {
            this.defaultValue = defaultValue;
            f.setAccessible(true);
            this.field = f;
            this.annotation = annotation;
            this.attrName = !annotation.attributeName().equals("") ? CompatibleVersionedObjectWithAttributes.PREFIX + annotation.attributeName() : CompatibleVersionedObjectWithAttributes.PREFIX + this.field.getName();
        }

        abstract byte[] get(Object var1) throws IllegalAccessException;

        abstract void set(Object var1, byte[] var2) throws IllegalAccessException;

        abstract boolean isDefaultValue(Object var1) throws IllegalAccessException;

        abstract void setDefault(Object var1) throws IllegalAccessException;

        final String getAttributeName() {
            return this.attrName;
        }
    }
}

