/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.core.ipc.IDCRequestSequence;
import java.util.ArrayList;
import java.util.List;

public class DefaultIDCRequestSequence
implements IDCRequestSequence {
    final List<String> idcs;
    int currentPos = 0;

    public DefaultIDCRequestSequence(List<String> idcs) {
        this.idcs = idcs;
    }

    public DefaultIDCRequestSequence(List<String> idcList, int maxIdcs) {
        this.idcs = idcList.size() > maxIdcs ? idcList.subList(0, maxIdcs) : idcList;
    }

    @Override
    public String nextIDC() {
        String idc = this.idcs.get(this.currentPos);
        this.currentPos = (this.currentPos + 1) % this.idcs.size();
        return idc;
    }

    @Override
    public List<String> idcList() {
        ArrayList<String> idcsToReturn = new ArrayList<String>();
        for (int i = 0; i < this.idcs.size(); ++i) {
            idcsToReturn.add(this.nextIDC());
        }
        return idcsToReturn;
    }

    @Override
    public List<String> currentIDCList() {
        ArrayList<String> idcsToReturn = new ArrayList<String>();
        for (int i = 0; i < this.idcs.size(); ++i) {
            idcsToReturn.add(this.idcs.get((this.currentPos + i) % this.idcs.size()));
        }
        return idcsToReturn;
    }

    @Override
    public String peek() {
        return this.idcs.get(this.currentPos);
    }

    @Override
    public int currentIDCIndex() {
        return this.currentPos;
    }

    @Override
    public int size() {
        return this.idcs.size();
    }
}

