/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicConfig
extends VersionedObjectWithAttributes {
    public static final String SERVERLESS_ATTR = "SERVERLESS";
    private static int PRIME = 31;
    private long commandID = 0L;
    private ConfigOpEnum configOp = ConfigOpEnum.SET;
    private List<LDServerAddress> serverList;
    private HashMap<String, String> configMap;

    public DynamicConfig() {
    }

    public DynamicConfig(ConfigOpEnum configOp) {
        this.configOp = configOp;
    }

    public ConfigOpEnum getConfigOp() {
        return this.configOp;
    }

    public void setConfigOp(ConfigOpEnum configOp) {
        this.configOp = configOp;
    }

    public void setServerList(List<LDServerAddress> serverList) {
        this.serverList = serverList;
    }

    public long caculateConfigHash() {
        if (this.configMap == null) {
            return 0L;
        }
        long result = 0L;
        for (Map.Entry<String, String> entry : this.configMap.entrySet()) {
            result += result * (long)PRIME + (long)entry.getKey().hashCode();
            if (entry.getValue() == null) continue;
            result += result * (long)PRIME + (long)entry.getValue().hashCode();
        }
        return result;
    }

    public List<LDServerAddress> getServerList() {
        return this.serverList;
    }

    public void addConfig(String configName, String value) {
        if (StringUtils.isNullOrEmpty(configName)) {
            return;
        }
        if (this.configMap == null) {
            this.configMap = new HashMap();
        }
        this.configMap.put(configName, value);
    }

    public HashMap<String, String> getConfigMap() {
        return this.configMap;
    }

    public LindormClientConfig mergeConfig(LindormClientConfig originalConfig, LindormClientConfig activeConfig) {
        if (this.configOp == ConfigOpEnum.DONOTHING) {
            return null;
        }
        if (this.configMap == null) {
            if (originalConfig == activeConfig) {
                return null;
            }
            return originalConfig;
        }
        LindormClientConfig newConfig = new LindormClientConfig(originalConfig);
        newConfig.mergeFromMap(this.configMap);
        return newConfig;
    }

    public String toString(boolean printServerList) {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("commandID=").append(this.commandID);
        builder.append(", configOp=").append((Object)this.configOp);
        builder.append(", configMap=");
        if (this.configMap == null) {
            builder.append("null");
        } else {
            builder.append(this.configMap.toString());
        }
        if (printServerList) {
            builder.append(", serverlist=");
            if (this.serverList != null) {
                builder.append(this.serverList.toString());
            } else {
                builder.append("null");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public boolean isFromServerLessServer() {
        byte[] attr = this.getAttribute(SERVERLESS_ATTR);
        return attr != null && Bytes.toBoolean(attr);
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVLong(out, this.commandID);
        WritableUtils.writeString(out, this.configOp.toString());
        if (this.serverList == null || this.serverList.size() == 0) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.serverList.size());
            for (LDServerAddress lDServerAddress : this.serverList) {
                lDServerAddress.writeTo(out);
            }
        }
        if (this.configMap == null || this.configMap.size() == 0) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.configMap.size());
            for (Map.Entry entry : this.configMap.entrySet()) {
                WritableUtils.writeString(out, (String)entry.getKey());
                WritableUtils.writeString(out, (String)entry.getValue());
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        int configMapSize;
        super.readFrom(in);
        this.commandID = WritableUtils.readVLong(in);
        this.configOp = ConfigOpEnum.valueOf(WritableUtils.readString(in));
        int serverListSize = WritableUtils.readVInt(in);
        if (serverListSize != 0) {
            this.serverList = new ArrayList<LDServerAddress>();
            for (int i = 0; i < serverListSize; ++i) {
                LDServerAddress address = new LDServerAddress();
                address.readFrom(in);
                this.serverList.add(address);
            }
        }
        if ((configMapSize = WritableUtils.readVInt(in)) != 0) {
            this.configMap = new HashMap();
            for (int i = 0; i < configMapSize; ++i) {
                String key = WritableUtils.readString(in);
                String value = WritableUtils.readString(in);
                this.configMap.put(key, value);
            }
        }
    }

    public static enum ConfigOpEnum {
        SET,
        RESTORE,
        DONOTHING;

    }
}

