/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.core.ipc.Address;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LDServerAddress
extends VersionedObjectWithAttributes
implements Comparable<LDServerAddress>,
Address {
    private static final int PRIME = 10020323;
    String idc = null;
    String host;
    int port;
    public static final String HOSTNAME_PORT_SEPARATOR = ":";
    private String cachedStr = null;

    private LDServerAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public LDServerAddress(String idc, String host, int port) {
        this.idc = idc;
        this.host = host;
        this.port = port;
    }

    public LDServerAddress() {
    }

    public String getIdc() {
        return this.idc;
    }

    @Override
    public String getHostname() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setIDC(String idc) {
        this.idc = idc;
    }

    public static LDServerAddress valueOf(String serverStr) {
        String[] hostAndPort = serverStr.split(HOSTNAME_PORT_SEPARATOR);
        String host = hostAndPort[0].trim();
        int port = Integer.parseInt(hostAndPort[1]);
        LDServerAddress address = new LDServerAddress(host, port);
        return address;
    }

    public static LDServerAddress valueOf(String host, int port) {
        return new LDServerAddress(host, port);
    }

    @Override
    public String getHostAndPort() {
        return this.host + HOSTNAME_PORT_SEPARATOR + this.port;
    }

    @Override
    public String toString() {
        if (this.cachedStr != null) {
            return this.cachedStr;
        }
        this.cachedStr = this.idc != null ? this.idc + " " + this.getHostAndPort() : this.getHostAndPort();
        return this.cachedStr;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LDServerAddress) {
            LDServerAddress server = (LDServerAddress)obj;
            return this.compareTo(server) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(LDServerAddress o) {
        int retCode = 0;
        if (this.idc == null && o.idc != null) {
            return -1;
        }
        if (this.idc != null && o.idc == null) {
            return 1;
        }
        retCode = this.idc == null && o.idc == null ? 0 : this.idc.compareTo(o.idc);
        if (retCode != 0) {
            return retCode;
        }
        retCode = this.host.compareTo(o.host);
        if (retCode != 0) {
            return retCode;
        }
        retCode = this.port - o.port;
        return retCode;
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result ^= this.port;
        if (this.idc != null) {
            result += 10020323 * this.idc.hashCode();
        }
        return result;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        if (this.idc == null) {
            WritableUtils.writeString(out, "");
        } else {
            WritableUtils.writeString(out, this.idc);
        }
        WritableUtils.writeString(out, this.host);
        WritableUtils.writeVInt(out, this.port);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.idc = WritableUtils.readString(in);
        this.host = WritableUtils.readString(in);
        this.port = WritableUtils.readVInt(in);
    }
}

