/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalDataException;

public class ColumnValueTuple {
    private Row row;

    public ColumnValueTuple(Row r) {
        this.row = r;
    }

    public byte[] getPkValueBytes(LColumn column) throws IllegalDataException {
        this.checkColumnValueExists(column);
        ColumnValue cv = this.row.getColumnValue(column.getColumnName());
        return LDataType.toBytes(column, cv);
    }

    public Object getPkValueObject(LColumn column) throws IllegalDataException {
        this.checkColumnValueExists(column);
        return this.row.getColumnValue(column.getColumnName()).getValueObject();
    }

    public byte[] getNonPkValueBytes(LColumn column) throws IllegalDataException {
        this.checkColumnValueExists(column);
        ColumnValue cv = this.row.getColumnValue(column.getColumnName());
        byte[] valueBytes = LDataType.toBytes(column, cv);
        if (valueBytes == null) {
            return Bytes.EMPTY_BYTE_ARRAY;
        }
        return valueBytes;
    }

    public Object getNonPkValueObject(LColumn column) throws IllegalDataException {
        this.checkColumnValueExists(column);
        return this.row.getColumnValue(column.getFamilyName(), column.getColumnName()).getValueObject();
    }

    private void checkColumnValueExists(LColumn column) throws IllegalDataException {
        if (this.row.getColumnValue(column.getFamilyName(), column.getColumnName()) == null) {
            throw new IllegalDataException("Not found value of column: " + column);
        }
    }
}

