/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.schema.EntityState;
import com.alibaba.lindorm.client.schema.LindormEntityDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Entity
extends VersionedObjectWithAttributes {
    private String namespace;
    private String tableName;
    private String entityName;
    private String physicalName;
    private String comment = null;
    private EntityState state = EntityState.BUILDING;
    private long createTimestamp = Long.MAX_VALUE;
    private long metaVersion = -1L;

    public Entity() {
    }

    public Entity(String namespace, String tableName, String entityName, String physicalName, EntityState state, String comment, long createTimestamp) {
        this.namespace = namespace;
        this.tableName = tableName;
        this.entityName = entityName;
        this.physicalName = physicalName;
        this.state = state;
        this.comment = comment;
        this.createTimestamp = createTimestamp;
    }

    public static Entity createFromEntityDescriptor(String namespace, LindormEntityDescriptor desc) {
        EntityState state = desc.getState() != null ? desc.getState() : EntityState.BUILDING;
        long createTs = desc.getCreateTimestamp() != Long.MAX_VALUE ? desc.getCreateTimestamp() : Long.MAX_VALUE;
        Entity e = new Entity(namespace, desc.getTableName(), desc.getEntityName(), desc.getPhysicalName(), state, desc.getComment(), createTs);
        e.setMetaVersion(desc.getMetaVersion());
        return e;
    }

    public LindormEntityDescriptor buildEntityDescriptor() {
        LindormEntityDescriptor desc = new LindormEntityDescriptor(this.tableName, this.entityName, this.comment);
        desc.setState(this.state);
        desc.setPhysicalName(this.physicalName);
        desc.setMetaVersion(this.metaVersion);
        desc.setCreateTimestamp(this.createTimestamp);
        return desc;
    }

    @Override
    public String toString() {
        return "Entity:[" + this.physicalName + "@" + (Object)((Object)this.state) + "@" + this.metaVersion + "@" + this.createTimestamp + "]";
    }

    public String toStringWithComments() {
        return this.toString() + ":#[" + this.comment + "]";
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public EntityState getState() {
        return this.state;
    }

    public void setState(EntityState state) {
        this.state = state;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public long getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(long metaVersion) {
        this.metaVersion = metaVersion;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.tableName);
        WritableUtils.writeString(out, this.entityName);
        WritableUtils.writeString(out, this.physicalName);
        WritableUtils.writeString(out, this.comment);
        WritableUtils.writeString(out, this.state.name());
        WritableUtils.writeVLong(out, this.createTimestamp);
        WritableUtils.writeVLong(out, this.metaVersion);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.tableName = WritableUtils.readString(in);
        this.entityName = WritableUtils.readString(in);
        this.physicalName = WritableUtils.readString(in);
        this.comment = WritableUtils.readString(in);
        this.state = EntityState.parse(WritableUtils.readString(in));
        this.createTimestamp = WritableUtils.readVLong(in);
        this.metaVersion = WritableUtils.readVLong(in);
        this.initFromAttributes();
    }

    private void setupAttributes() throws IOException {
    }

    private void initFromAttributes() throws IOException {
    }

    public Entity deepCopy() throws IOException {
        byte[] bytes = WritableUtils.getBytes(this);
        Entity cloned = new Entity();
        WritableUtils.getWritable(bytes, cloned);
        return cloned;
    }

    public int hashCode() {
        return this.physicalName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        if (!this.namespace.equals(other.namespace)) {
            return false;
        }
        if (!this.tableName.equals(other.tableName)) {
            return false;
        }
        return this.entityName.equals(other.entityName);
    }

    public static class EntityBuilder {
        Entity e = new Entity();

        public EntityBuilder setParent(String namespace, String tableName) {
            this.e.namespace = namespace;
            this.e.tableName = tableName;
            return this;
        }

        public EntityBuilder setEntityName(String entityName) {
            this.e.entityName = entityName;
            return this;
        }

        public EntityBuilder setEntityPhysicalName(String entityPhysicalName) {
            this.e.physicalName = entityPhysicalName;
            return this;
        }

        public EntityBuilder setState(EntityState state) {
            this.e.state = state;
            return this;
        }

        public EntityBuilder setComment(String comment) {
            this.e.comment = comment;
            return this;
        }

        public EntityBuilder setMetaVersion(long metaVersion) {
            this.e.metaVersion = metaVersion;
            return this;
        }

        public EntityBuilder setCreateTimestamp(long createTimestamp) {
            this.e.createTimestamp = createTimestamp;
            return this;
        }

        public Entity build() {
            return this.e;
        }
    }
}

