/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.Entity;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.schema.EntityState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityMeta
extends VersionedObjectWithAttributes {
    public static final long ENTITY_VERSION_INIT = 0L;
    public static final long ENTITY_VERSION_NOT_SET = -1L;
    private long metaVersion = 0L;
    private String fullTableName;
    private String activeEntityName;
    private Map<String, Entity> entities;

    public EntityMeta() {
    }

    public EntityMeta(String fullTableName, String activeEntityName, Map<String, Entity> entities) {
        this.fullTableName = fullTableName;
        this.activeEntityName = activeEntityName;
        this.entities = entities;
    }

    public String getFullTableName() {
        return this.fullTableName;
    }

    public Entity getActiveEntity() {
        return this.entities.get(this.activeEntityName);
    }

    public String getActiveEntityName() {
        return this.activeEntityName;
    }

    public void setActiveEntityName(String activeEntityName) {
        this.activeEntityName = activeEntityName;
    }

    public Map<String, Entity> getEntities() {
        return this.entities;
    }

    public List<Entity> getEntitiesByState(EntityState state) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity e : this.entities.values()) {
            if (e.getState() != state) continue;
            ret.add(e);
        }
        return ret;
    }

    public long getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(long metaVersion) {
        this.metaVersion = metaVersion;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeVLong(out, this.metaVersion);
        WritableUtils.writeString(out, this.fullTableName);
        WritableUtils.writeString(out, this.activeEntityName);
        WritableUtils.writeVInt(out, this.entities.size());
        for (Entity e : this.entities.values()) {
            e.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.metaVersion = WritableUtils.readVLong(in);
        this.fullTableName = WritableUtils.readString(in);
        this.activeEntityName = WritableUtils.readString(in);
        int numEntities = WritableUtils.readVInt(in);
        this.entities = new HashMap<String, Entity>();
        for (int i = 0; i < numEntities; ++i) {
            Entity e = new Entity();
            e.readFrom(in);
            this.entities.put(e.getEntityName(), e);
        }
        this.initFromAttributes();
    }

    private void setupAttributes() throws IOException {
    }

    private void initFromAttributes() throws IOException {
    }

    public int hashCode() {
        return this.fullTableName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityMeta)) {
            return false;
        }
        EntityMeta other = (EntityMeta)obj;
        return this.fullTableName.equals(other.fullTableName);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.fullTableName);
        str.append("] metaVersion:[");
        str.append(this.metaVersion);
        str.append("] active:[");
        str.append(this.activeEntityName);
        str.append("] all:");
        str.append(this.entities.size());
        str.append("@");
        for (Entity e : this.entities.values()) {
            str.append(e.toString());
            str.append(", ");
        }
        if (!this.entities.isEmpty()) {
            str.setLength(str.length() - 2);
        }
        return str.toString();
    }

    public EntityMeta deepCopy() throws IOException {
        byte[] bytes = WritableUtils.getBytes(this);
        EntityMeta cloned = new EntityMeta();
        WritableUtils.getWritable(bytes, cloned);
        return cloned;
    }
}

