/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.FunctionCall;
import com.alibaba.lindorm.client.core.feedstreamservice.StreamSchema;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.CoveredColumnType;
import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.IndexMeta;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.PrimaryKeyValueAccessor;
import com.alibaba.lindorm.client.core.meta.RangeRouter;
import com.alibaba.lindorm.client.core.meta.SearchIndexMeta;
import com.alibaba.lindorm.client.core.meta.SilenceIndex;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.meta.TableType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.BytesKeyAttributes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.ColumnBitmap;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.IndexUtils;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.OrderedColumnKey;
import com.alibaba.lindorm.client.exception.ColumnNotFoundException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.SchemaMismatchException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.ColumnSchemaOption;
import com.alibaba.lindorm.client.schema.DataCodec;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.alibaba.lindorm.client.schema.PrimaryKeyOption;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import com.alibaba.lindorm.client.schema.RowTTLSchema;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TableMeta
extends VersionedObjectWithAttributes {
    public static final String TABLE_ATTRIBUTES_KEY = "TABLE_ATTRS";
    public static final String RANGE_ROUTER_KEY = "RANGE_ROUTER";
    public static final String OTHER_ATTRIBUTES_KEY = "OTHER_ATTR";
    public static final String EXTERNAL_INDEX_CONFIG = "EXTERNALINDEX";
    public static final int DEFAULT_META_VERSION = 0;
    private int version;
    private TableType type = TableType.DATA_TABLE;
    private String namespace;
    private String tableName;
    private List<ColumnFamilyDescriptor> families;
    private FamilyAttributes familyAttributes = new FamilyAttributes();
    private List<LColumn> allColumns;
    private TableAttributes tableAttributes = new TableAttributes();
    private BytesKeyAttributes otherAttr = null;
    private RangeRouter rangeRouter;
    private long createTime;
    private List<ColumnKey> allColumnKeys;
    private List<LColumn> pkColumns;
    private List<LColumn> nonPkColumns;
    private Map<ColumnKey, LColumn> columnsByName;
    private PrimaryKeyValueAccessor accessor;
    private long ttl;
    private int hash;
    private boolean accExist;
    private int autoIncPkPos = -1;
    private int idempotentPos = -1;
    private List<Integer> functionColumnsPos = new ArrayList<Integer>();
    private ColumnBitmap completeColumnBitmap = null;
    private ColumnBitmap mutableColumnBitmap = null;
    private ColumnBitmap prefixMutableIndexedColumnBitmap = null;
    private IndexMeta indexMeta = new IndexMeta();
    private String externalIndexConfig;
    private SearchIndexMeta searchIndexMeta = new SearchIndexMeta();
    private boolean hasBlob = false;

    public TableMeta() {
    }

    public TableMeta(String namespace, LindormTableDescriptor desc) {
        this.namespace = namespace;
        this.version = desc.getMetaVersion();
        this.tableName = desc.getName();
        this.families = desc.getFamilies();
        this.allColumns = SchemaUtils.convertClientSchemaToInternalSchema(desc.getPkColumns(), desc.getNonPkColumns());
        this.familyAttributes = desc.getFamilyAttributes();
        this.tableAttributes = desc.getTableAttributes();
        this.otherAttr = desc.getOtherAttributes();
        this.indexMeta.initFromTableDescriptor(desc);
        this.init();
    }

    public TableMeta(String namespace, String indexLogicalName, LindormIndexDescriptor desc, TableMeta dataTableMeta) throws LindormException {
        this.namespace = namespace;
        this.version = desc.getMetaVersion();
        this.tableName = indexLogicalName;
        this.families = new ArrayList<ColumnFamilyDescriptor>();
        if (desc.isLocalIndex()) {
            this.families.add(SchemaUtils.DEFAULT_LOCAL_INDEX_CFD);
        }
        this.indexMeta.initFromIndexDescriptor(desc);
        this.allColumns = new LinkedList<LColumn>();
        IndexUtils.createIndexTableSchema(desc, dataTableMeta, this);
        this.familyAttributes = desc.getFamilyAttributes();
        this.tableAttributes = desc.getTableAttributes();
        this.otherAttr = desc.getOtherAttributes();
        this.inheritFamilyAttributesFromDataTable(dataTableMeta, false);
        this.inheritTableAttributesFromDataTable(dataTableMeta);
        this.init();
    }

    public TableMeta(TableMetaBuilder builder) {
        this.version = builder.version;
        this.namespace = builder.namespace;
        this.tableName = builder.tableName;
        this.families = builder.families;
        this.allColumns = Collections.unmodifiableList(CollectionUtils.copyOf(builder.allColumns));
        this.familyAttributes = builder.familyAttributes;
        this.tableAttributes = builder.tableAttributes;
        this.otherAttr = builder.otherAttributes;
        this.type = builder.type;
        this.indexMeta.initFromTableMetaBuilder(builder);
        this.init();
    }

    public static TableMeta deepCopy(TableMeta other) throws IOException {
        byte[] bytes = LindormObjectUtils.getBytes(other);
        TableMeta ret = new TableMeta();
        LindormObjectUtils.getWritable(bytes, ret);
        return ret;
    }

    public static TableMeta deepCopy(TableMeta meta, List<LColumn> allColumns) {
        try {
            TableMetaBuilder builder = new TableMetaBuilder(meta.getNamespace());
            builder.tableName(meta.getTableName()).type(TableType.DATA_TABLE).parentName(meta.getParentName()).version(meta.getMetaVersion()).allColumns(Collections.unmodifiableList(CollectionUtils.copyOf(allColumns))).families(meta.getFamilies()).familyAttributes(meta.getFamilyAttributes()).tableAttributes(meta.getTableAttributes()).otherAttributes(meta.getOtherAttr()).indexLogicalNames(meta.getIndexLogicalNames()).indexIdNames(meta.getIndexIds()).silenceIndexMap(meta.getSilenceIndexMap());
            return builder.build();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static TableMeta deepCopy(TableMeta meta, String tableName) {
        try {
            TableMetaBuilder builder = new TableMetaBuilder(meta.getNamespace());
            builder.tableName(tableName).type(TableType.DATA_TABLE).parentName(meta.getParentName()).version(meta.getMetaVersion()).allColumns(meta.getAllColumns()).families(meta.getFamilies()).familyAttributes(meta.getFamilyAttributes()).tableAttributes(meta.getTableAttributes()).otherAttributes(meta.getOtherAttr()).indexLogicalNames(meta.getIndexLogicalNames()).indexIdNames(meta.getIndexIds()).silenceIndexMap(meta.getSilenceIndexMap());
            return builder.build();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static TableMeta deepCopyIgnoreIndex(TableMeta meta, String tableName) {
        try {
            TableMetaBuilder builder = new TableMetaBuilder(meta.getNamespace());
            builder.tableName(tableName).type(TableType.DATA_TABLE).parentName(meta.getParentName()).version(meta.getMetaVersion()).allColumns(meta.getAllColumns()).families(meta.getFamilies()).familyAttributes(meta.getFamilyAttributes()).tableAttributes(meta.getTableAttributes()).otherAttributes(meta.getOtherAttr()).indexLogicalNames(CollectionUtils.<String>newArrayList()).indexIdNames(new HashMap<Byte, String>()).silenceIndexMap(new HashMap<String, SilenceIndex>());
            return builder.build();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String getExternalIndexConfig() {
        return this.externalIndexConfig;
    }

    public void setExternalIndexConfig(String config) {
        this.externalIndexConfig = config;
    }

    private void init() {
        this.createTime = System.currentTimeMillis();
        if (this.families == null) {
            this.families = Collections.emptyList();
        }
        this.pkColumns = CollectionUtils.newArrayListWithCapacity(this.allColumns.size());
        this.nonPkColumns = CollectionUtils.newArrayListWithCapacity(this.allColumns.size());
        this.functionColumnsPos = new ArrayList<Integer>();
        for (LColumn col : this.allColumns) {
            if (col.isPrimaryKey()) {
                this.pkColumns.add(col);
                if (col.getPkOption() == PrimaryKeyOption.AUTO_INCREMENT) {
                    this.autoIncPkPos = col.getPosition();
                }
            } else {
                this.nonPkColumns.add(col);
                if (col.getCsOption() == ColumnSchemaOption.IDEMPOTENT) {
                    this.idempotentPos = col.getPosition();
                }
            }
            if (col.getColumnFunction() != null) {
                this.functionColumnsPos.add(col.getPosition());
            }
            if (col.getDataType().getClientType() != DataType.BLOB) continue;
            this.hasBlob = true;
        }
        this.pkColumns = Collections.unmodifiableList(this.pkColumns);
        this.nonPkColumns = Collections.unmodifiableList(this.nonPkColumns);
        this.allColumnKeys = CollectionUtils.newArrayListWithCapacity(this.allColumns.size());
        this.columnsByName = CollectionUtils.newHashMapWithExpectedSize(this.allColumns.size() * 2);
        this.accExist = false;
        for (LColumn col : this.allColumns) {
            this.columnsByName.put(col.getColumnKey(), col);
            if (SchemaUtils.isDefaultFamily(col.getFamilyName())) {
                ColumnKey ckWithoutFamily = new ColumnKey(null, col.getColumnName());
                this.columnsByName.put(ckWithoutFamily, col);
                this.allColumnKeys.add(ckWithoutFamily);
            } else {
                this.allColumnKeys.add(col.getColumnKey());
            }
            if (!SchemaUtils.isAccumulatorType(col.getDataType())) continue;
            this.accExist = true;
        }
        this.allColumnKeys = Collections.unmodifiableList(this.allColumnKeys);
        this.initAccessor();
        this.ttl = this.familyAttributes.getTimeToLive();
        for (ColumnFamilyDescriptor cf : this.families) {
            if (cf.getFamilyAttributes().getTimeToLiveNoDefault() == null) continue;
            this.ttl = cf.getFamilyAttributes().getTimeToLiveNoDefault().intValue();
            break;
        }
        this.ttl = this.ttl == Integer.MAX_VALUE || this.ttl == -1L ? Long.MAX_VALUE : (this.ttl *= 1000L);
    }

    public void initAccessor() {
        this.accessor = this.isStorePkNulls() ? new PrimaryKeyValueAccessor(this.tableAttributes.getDataCodec(), this.pkColumns, true) : new PrimaryKeyValueAccessor(this.tableAttributes.getDataCodec(), this.pkColumns);
    }

    public boolean inheritFamilyAttributesFromDataTable(TableMeta dataTableMeta, boolean isModify) {
        boolean inherited = false;
        if (this.inheritTTLSchemaFromDataTable(dataTableMeta)) {
            inherited = true;
        }
        if (this.inheritCompressionTypeFromDataTable(dataTableMeta, isModify)) {
            inherited = true;
        }
        if (this.inheritRowTTLSchemaFromDataTable(dataTableMeta)) {
            inherited = true;
        }
        return inherited;
    }

    private boolean inheritCompressionTypeFromDataTable(TableMeta dataTableMeta, boolean isModify) {
        if (!isModify && this.familyAttributes.hasAttribute("COMPRESSION")) {
            return false;
        }
        boolean inherited = false;
        String compressionType = null;
        if (!dataTableMeta.getFamilies().isEmpty()) {
            compressionType = dataTableMeta.getFamilies().get(0).getCompression();
        }
        if (compressionType == null || compressionType.equals("NONE")) {
            compressionType = dataTableMeta.getFamilyAttributes().getCompression();
        }
        if (!this.familyAttributes.getCompression().equals(compressionType)) {
            this.familyAttributes.setCompression(compressionType);
            inherited = true;
        }
        return inherited;
    }

    private boolean inheritTTLSchemaFromDataTable(TableMeta dataTableMeta) {
        boolean inherited = false;
        int ttlInTable = Integer.MAX_VALUE;
        if (!dataTableMeta.getFamilies().isEmpty()) {
            ttlInTable = dataTableMeta.getFamilies().get(0).getTimeToLive();
        }
        if (ttlInTable == Integer.MAX_VALUE) {
            ttlInTable = dataTableMeta.getFamilyAttributes().getTimeToLive();
        }
        if (this.familyAttributes.getTimeToLive() != ttlInTable) {
            this.familyAttributes.setTimeToLive(ttlInTable);
            inherited = true;
        }
        return inherited;
    }

    private boolean inheritRowTTLSchemaFromDataTable(TableMeta dataTableMeta) {
        boolean inherited = false;
        boolean dynamicColumnsEnabled = dataTableMeta.getTableAttributes().isDynamicColumnsEnabled();
        RowTTLSchema rowttlInDataTable = dataTableMeta.getFamilyAttributes().getRowTTLSchema();
        if (rowttlInDataTable == null && !dataTableMeta.getFamilies().isEmpty()) {
            rowttlInDataTable = dataTableMeta.getFamilies().get(0).getRowTTLSchema();
        }
        if (dynamicColumnsEnabled) {
            rowttlInDataTable = this.generateIndexRowTTLSchemaIfDynamicColumnsEnabled(rowttlInDataTable);
        }
        if (this.familyAttributes.getRowTTLSchema() != rowttlInDataTable) {
            if (rowttlInDataTable == null) {
                this.familyAttributes.removeAttribute("ROWTTL_SCHEMA");
            } else {
                this.familyAttributes.setRowTTLSchema(rowttlInDataTable);
            }
            inherited = true;
        }
        return inherited;
    }

    private RowTTLSchema generateIndexRowTTLSchemaIfDynamicColumnsEnabled(RowTTLSchema rowttlInDataTable) {
        if (rowttlInDataTable == null) {
            return null;
        }
        byte[] fullColumnName = SchemaUtils.getFullColumnNameBytes(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, rowttlInDataTable.getColumn());
        RowTTLSchema ttl = RowTTLSchema.fromString(rowttlInDataTable.toString());
        ttl.setColumn(fullColumnName);
        return ttl;
    }

    public boolean inheritTableAttributesFromDataTable(TableMeta dataTableMeta) {
        DataCodec dtCodec;
        boolean isDynamicOfDataTable = dataTableMeta.getTableAttributes().isDynamicColumnsEnabled();
        boolean isDynamicOfIndexTable = this.tableAttributes.isDynamicColumnsEnabled();
        boolean updated = false;
        if (this.getCoveredColumnType() == CoveredColumnType.DYNAMIC && isDynamicOfDataTable != isDynamicOfIndexTable) {
            this.tableAttributes.setDynamicColumnsEnabled(isDynamicOfDataTable);
            updated = true;
        }
        if ((dtCodec = dataTableMeta.getTableAttributes().getDataCodec()) != this.tableAttributes.getDataCodec()) {
            this.tableAttributes.setDataCodec(dtCodec);
            updated = true;
        }
        return updated;
    }

    public boolean hasBlobColumn() {
        return this.hasBlob;
    }

    public int getMetaVersion() {
        return this.version;
    }

    public void setRangeRouter(RangeRouter rangeRouter) {
        this.rangeRouter = rangeRouter;
    }

    public RangeRouter getRangeRouter() {
        return this.rangeRouter;
    }

    public void setMetaVersion(int version) {
        this.version = version;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getParentName() {
        return this.indexMeta.getParentName();
    }

    public void setParentName(String parentName) {
        this.indexMeta.setParentName(parentName);
    }

    public boolean isIndex() {
        return this.getParentName() != null;
    }

    public boolean isLocalIndex() {
        return TableType.isLocalIndex(this.getType());
    }

    public boolean isSilenceIndex(String indexName, long currTime, long timeOut) {
        return this.indexMeta.isSilenceIndex(indexName, currTime, timeOut);
    }

    public List<ColumnFamilyDescriptor> getFamilies() {
        return this.families;
    }

    public ColumnFamilyDescriptor getFamilyDescriptorByName(byte[] familyName) {
        if (this.families == null || this.families.isEmpty()) {
            return null;
        }
        for (ColumnFamilyDescriptor desc : this.families) {
            if (!Bytes.equals(desc.getName(), familyName)) continue;
            return desc;
        }
        return null;
    }

    public FamilyAttributes getFamilyAttributes() {
        return this.familyAttributes;
    }

    public TableAttributes getTableAttributes() {
        return this.tableAttributes;
    }

    public TableType getType() {
        return this.type;
    }

    public void setType(TableType type) {
        this.type = type;
    }

    public long getTTL() {
        return this.ttl;
    }

    public TableAttributes.ConsistencyType getConsistencyType() {
        return this.tableAttributes.getConsistencyType();
    }

    public TableAttributes.LeaderBalanceType getLeaderBalanceType() {
        return this.tableAttributes.getLeaderBalanceType();
    }

    public boolean isSkipReplicaConsensus() {
        return this.tableAttributes.isSkipReplicaConsensus();
    }

    public Expression getIndexCondition() {
        return this.indexMeta.getIndexCondition();
    }

    public boolean isStorePkNulls() {
        return this.indexMeta.isStorePkNulls();
    }

    public boolean isStorePkTS() {
        return this.indexMeta.isStorePkTS();
    }

    public boolean isStoreFamilyInQualifier() {
        return this.indexMeta.isStoreFamilyInQualifier();
    }

    public int getGlitchTimeout() {
        return this.tableAttributes.getGlitchTimeout();
    }

    public int getReadGlitchTimeout() {
        return this.tableAttributes.getReadGlitchTimeout();
    }

    public int getWriteGlitchTimeout() {
        return this.tableAttributes.getWriteGlitchTimeout();
    }

    public boolean hasGlitchTimeout() {
        return this.tableAttributes.getGlitchTimeout() != -1;
    }

    public boolean hasReadGlitchTimeout() {
        return this.tableAttributes.getReadGlitchTimeout() != -1;
    }

    public boolean hasWriteGlitchTimeout() {
        return this.tableAttributes.getWriteGlitchTimeout() != -1;
    }

    public boolean isLeaderBalanceEnabled() {
        return this.tableAttributes.isLeaderBalanceEnabled();
    }

    public boolean isDeferredLogFlush() {
        return this.tableAttributes.isDeferredLogFlush();
    }

    public boolean isWalEditWithFullData() {
        return this.tableAttributes.isWalEditWithFullRow();
    }

    public boolean isFullDataEditCarryLatestData() {
        return this.tableAttributes.isFullRowEditCarryLatestData();
    }

    public String getWalEditExcludedColumns() {
        return this.tableAttributes.getWalEditExcludedColumns();
    }

    public String getWalEditIncludedColumns() {
        return this.tableAttributes.getWalEditIncludedColumns();
    }

    public boolean isSkipRowImageBuildingEnable() {
        return this.tableAttributes.isSkipRowImageBuildingEnable();
    }

    public boolean isAllowFiltering() {
        return this.tableAttributes.isAllowFiltering();
    }

    public CoveredColumnType getCoveredColumnType() {
        return this.indexMeta.getCoveredColumnType();
    }

    public void setCoveredColumnType(CoveredColumnType coveredColumnType) {
        this.indexMeta.setCoveredColumnType(coveredColumnType);
    }

    public void setIndexState(IndexState indexState) {
        this.indexMeta.setIndexState(indexState);
    }

    public IndexState getIndexState() {
        return this.indexMeta.getIndexState();
    }

    public String getIndexName() {
        return this.indexMeta.getIndexName();
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getAge() {
        return System.currentTimeMillis() - this.createTime;
    }

    public List<LColumn> getPkColumns() {
        return this.pkColumns;
    }

    public boolean isFirstPKColumnKey(ColumnKey columnKey) {
        LColumn currentColumn = this.resolveColumnNoThrow(columnKey);
        if (null == currentColumn) {
            return false;
        }
        LColumn firstColumn = this.pkColumns.get(0);
        return firstColumn.equals(currentColumn);
    }

    public List<LColumn> getAllColumns() {
        return this.allColumns;
    }

    public List<ColumnKey> getAllColumnKeys() {
        return this.allColumnKeys;
    }

    public List<LColumn> getNonPkColumns() {
        return this.nonPkColumns;
    }

    public PrimaryKeyValueAccessor getPKAccessor() {
        return this.accessor;
    }

    public BytesKeyAttributes getOtherAttr() {
        return this.otherAttr;
    }

    public void setOtherAttr(ImmutableBytesPtr key, ImmutableBytesPtr value) {
        if (this.otherAttr == null) {
            this.otherAttr = new BytesKeyAttributes();
        }
        this.otherAttr.set(key, value);
    }

    public void addIndex(TableMeta indexTableMeta) throws LindormException {
        if (this.type != TableType.DATA_TABLE) {
            throw new IllegalRequestException("Cannot add index:" + indexTableMeta.getTableName() + " to an table:" + this.tableName + ", table type:" + (Object)((Object)this.type));
        }
        this.indexMeta.addIndex(indexTableMeta);
        this.setupAttributes();
    }

    public void removeIndexMeta(String indexName, String indexLogicalName) throws LindormException {
        if (this.type != TableType.DATA_TABLE) {
            throw new IllegalRequestException("Cannot remove index " + indexName + " from an index table " + this.tableName);
        }
        if (!this.hasIndex()) {
            return;
        }
        this.indexMeta.removeIndexMeta(indexName, indexLogicalName, this.tableName);
        this.setupAttributes();
    }

    public List<String> getIndexLogicalNames() {
        return this.indexMeta.getIndexLogicalNames();
    }

    public Map<String, TableMeta> getIndexMetas() {
        return this.indexMeta.getIndexMetas();
    }

    public TableMeta getIndexMeta(String indexName) {
        return this.indexMeta.getIndexMetas().get(indexName);
    }

    public boolean hasIndex() {
        return this.indexMeta.hasIndex();
    }

    public boolean hasSearchIndex() {
        return this.externalIndexConfig != null || !this.searchIndexMeta.getIndexMetas().isEmpty();
    }

    public void addSearchIndex(SearchIndexMeta meta) throws LindormException {
        this.searchIndexMeta.addIndex(this, meta);
        this.setupAttributes();
    }

    public void removeSearchIndex(String indexName) throws LindormException {
        if (null == this.searchIndexMeta.getSearchIndexMeta(indexName)) {
            throw new LindormException("Search index:" + indexName + " is not existent.");
        }
        this.searchIndexMeta.removeIndexMeta(indexName);
        this.setupAttributes();
    }

    public SearchIndexMeta getSearchIndexMeta(String indexName) {
        return this.searchIndexMeta.getSearchIndexMeta(indexName);
    }

    public Map<String, SearchIndexMeta> getSearchIndexMetas() {
        return this.searchIndexMeta.getIndexMetas();
    }

    public Map<Byte, String> getIndexIds() {
        return this.indexMeta.getIdNames();
    }

    public Map<String, SilenceIndex> getSilenceIndexMap() {
        return this.indexMeta.getSilenceIndexMap();
    }

    public String getIndexNameById(Byte indexID) {
        return this.indexMeta.getIdNames().get(indexID);
    }

    public Byte getIDByIndexName(String indexName) {
        for (Map.Entry<Byte, String> entry : this.indexMeta.getIdNames().entrySet()) {
            if (!entry.getValue().equals(indexName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isAccColumnExist() {
        return this.accExist;
    }

    public boolean hasAutoIncPK() {
        return this.autoIncPkPos > 0;
    }

    public int getAutoIncPkPos() {
        return this.autoIncPkPos;
    }

    public boolean hasIdempotentColumn() {
        return this.idempotentPos > 0;
    }

    public int getIdempotentColumnPos() {
        return this.idempotentPos;
    }

    public int getIdempotentWindow() {
        return this.tableAttributes.getIdempotentWindow();
    }

    public boolean isIdempotentEnabled() {
        return this.tableAttributes.isIdempotentEnabled();
    }

    public boolean hasFunctionColumn() {
        return this.functionColumnsPos != null && this.functionColumnsPos.size() != 0;
    }

    public List<Integer> getFunctionColumnsPos() {
        return this.functionColumnsPos;
    }

    public LColumn getFunctionColumn(int functionColumnPos) throws LindormException {
        assert (functionColumnPos < this.allColumns.size());
        if (this.allColumns.get(functionColumnPos).getColumnFunction() == null) {
            throw new LindormException("Not found function column in pos: " + functionColumnPos);
        }
        return this.allColumns.get(functionColumnPos);
    }

    public ColumnBitmap getCompleteColumnBitmap() {
        return this.completeColumnBitmap;
    }

    public ColumnBitmap getMutableColumnBitmap() {
        return this.mutableColumnBitmap;
    }

    public ColumnBitmap getPrefixMutableIndexedColumnBitmap() {
        return this.prefixMutableIndexedColumnBitmap;
    }

    public boolean setupIndexes(List<TableMeta> indexes) throws IOException {
        boolean needToUpdateMetaCache = false;
        for (TableMeta index : indexes) {
            CoveredColumnType ccType = index.getCoveredColumnType();
            if (IndexUtils.isFullCover(ccType)) {
                needToUpdateMetaCache = true;
            }
            index = this.updateIndexTableMeta(index);
            this.indexMeta.getIndexMetas().put(index.getIndexName(), index);
        }
        this.setupAttributes();
        return needToUpdateMetaCache;
    }

    public boolean setupSingleIndex(TableMeta indexTableMeta) throws IOException {
        boolean needToUpdateMetaCache = false;
        CoveredColumnType ccType = indexTableMeta.getCoveredColumnType();
        if (IndexUtils.isFullCover(ccType)) {
            needToUpdateMetaCache = true;
        }
        indexTableMeta = this.updateIndexTableMeta(indexTableMeta);
        this.indexMeta.getIndexMetas().put(indexTableMeta.getIndexName(), indexTableMeta);
        this.setupAttributes();
        return needToUpdateMetaCache;
    }

    private TableMeta updateIndexTableMeta(TableMeta index) throws IOException {
        CoveredColumnType ccType = index.getCoveredColumnType();
        if (IndexUtils.isFullCover(ccType)) {
            index = this.supplementCoveredColumnMetas(index);
        }
        this.updateIndexColumnMeta(index);
        this.initIndexColumnBitmap(index);
        return index;
    }

    private TableMeta supplementCoveredColumnMetas(TableMeta indexTable) throws IOException {
        ArrayList<LColumn> allColumnsInIndex = new ArrayList<LColumn>(this.allColumns.size());
        allColumnsInIndex.addAll(indexTable.getPkColumns());
        allColumnsInIndex.add(SchemaUtils.getDefaultColumnMeta(indexTable));
        TableMeta copy = TableMeta.deepCopy(indexTable);
        copy.resetColumnSchema(allColumnsInIndex);
        List<LColumn> indexPKColumns = indexTable.getPkColumns();
        int position = indexPKColumns.get(indexPKColumns.size() - 1).getPosition() + 1;
        for (LColumn col : this.getNonPkColumns()) {
            byte[] indexQualifier = IndexUtils.getIndexColumnQualifier(col.getColumnKey(), indexTable);
            if (copy.resolveColumnNoThrow(new ColumnKey(indexQualifier)) != null) continue;
            LColumn coveredColumnMeta = LColumn.createIndexColumnMeta(col.getColumnKey(), this, indexTable, position);
            if (indexTable.isLocalIndex()) {
                coveredColumnMeta.setFamilyName(SchemaUtils.DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES);
            }
            ++position;
            allColumnsInIndex.add(coveredColumnMeta);
        }
        copy.resetColumnSchema(allColumnsInIndex);
        return copy;
    }

    private void updateIndexColumnMeta(TableMeta indexTable) throws LindormException {
        List<LColumn> allColumns = indexTable.getAllColumns();
        boolean isLeadingKey = true;
        for (LColumn col : allColumns) {
            ColumnKey dataColumnCK;
            if (SchemaUtils.isDefaultColumn(col.getColumnName()) || null == (dataColumnCK = col.getDataColumnKey())) continue;
            if (col.isFunctionColumn() && this.resolveColumnNoThrow(dataColumnCK) == null) {
                FunctionCall function = col.getColumnFunction();
                function.setCompiled(true);
                LDataType dataType = function.getLDataType();
                LColumn fakeDataColumn = LColumn.createFakeColumn(col, dataType, indexTable);
                col.setDataColumnMeta(fakeDataColumn);
                continue;
            }
            LColumn dataColumnMeta = this.resolveColumn(dataColumnCK);
            col.setDataColumnMeta(dataColumnMeta);
            if (!isLeadingKey) continue;
            dataColumnMeta.addLeadingKeyIndexes(indexTable);
            isLeadingKey = false;
        }
    }

    private void initIndexColumnBitmap(TableMeta indexTable) {
        int nBits = this.allColumns.size();
        indexTable.completeColumnBitmap = new ColumnBitmap(nBits);
        indexTable.mutableColumnBitmap = new ColumnBitmap(nBits);
        indexTable.prefixMutableIndexedColumnBitmap = new ColumnBitmap(nBits);
        for (LColumn col : indexTable.getAllColumns()) {
            LColumn dataCol;
            if (SchemaUtils.isDefaultColumn(col.getColumnName()) || (dataCol = col.getDataColumnMeta()) == null || dataCol.getPosition() == -1) continue;
            indexTable.completeColumnBitmap.set(dataCol.getPosition());
            if (!dataCol.isPrimaryKey()) {
                indexTable.mutableColumnBitmap.set(dataCol.getPosition());
            }
            if (!col.isPrimaryKey() || dataCol.isPrimaryKey()) continue;
            indexTable.prefixMutableIndexedColumnBitmap.set(dataCol.getPosition());
        }
    }

    public LColumn resolveColumn(ColumnKey ck) throws ColumnNotFoundException {
        LColumn ret = this.resolveColumnNoThrow(ck);
        if (ret != null) {
            return ret;
        }
        if (this.tableAttributes.isDynamicColumnsEnabled()) {
            return LColumn.createDynamicColumnMeta(ck);
        }
        throw new ColumnNotFoundException(ck, this.namespace, this.tableName);
    }

    public boolean schemaInDataTable(IndexedColumnSchema ics) {
        LColumn ret = this.resolveColumnNoThrow(ics.getColumnKey());
        if (ret != null) {
            return true;
        }
        if (ics.isFunctionColumn()) {
            return false;
        }
        return this.tableAttributes.isDynamicColumnsEnabled();
    }

    public LColumn resolveColumn(OrderedColumnKey orderedColumnKey) throws ColumnNotFoundException {
        return this.resolveColumn(orderedColumnKey.getColumnKey());
    }

    public LColumn resolveColumn(ColumnKey ck, DataType type) throws SchemaMismatchException {
        LColumn ret = this.resolveColumnNoThrow(ck);
        if (ret != null) {
            return ret;
        }
        if (this.tableAttributes.isDynamicColumnsEnabled()) {
            if (type != DataType.VARBINARY && type != DataType.BINARY) {
                throw new SchemaMismatchException("Dynamic column [" + ck + "] must be of type VARBINARY/BINARY, but has " + (Object)((Object)type));
            }
            return LColumn.createDynamicColumnMeta(ck);
        }
        throw new ColumnNotFoundException(ck, this.namespace, this.tableName);
    }

    public boolean containsCollectionType() {
        for (LColumn column : this.allColumns) {
            DataType dataType = column.getDataType().getClientType();
            if (!dataType.equals((Object)DataType.MAP) && !dataType.equals((Object)DataType.SET) && !dataType.equals((Object)DataType.LIST)) continue;
            return true;
        }
        return false;
    }

    public LColumn resolveColumn(OrderedColumnKey orderedColumnKey, DataType type) throws SchemaMismatchException {
        return this.resolveColumn(orderedColumnKey.getColumnKey(), type);
    }

    public LColumn resolveColumnNoThrow(ColumnKey ck) {
        return this.columnsByName.get(ck);
    }

    public boolean hasCollectionTypeColumn() {
        for (LColumn item : this.allColumns) {
            if (!item.isCollectionType()) continue;
            return true;
        }
        return false;
    }

    public LColumn resolveColumnNoThrow(OrderedColumnKey orderedColumnKey) throws ColumnNotFoundException {
        return this.resolveColumn(orderedColumnKey.getColumnKey());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TableMeta)) {
            return false;
        }
        TableMeta other = (TableMeta)obj;
        if (this.version != other.version) {
            return false;
        }
        if (!this.tableName.equals(other.tableName)) {
            return false;
        }
        if (!this.families.equals(other.families)) {
            return false;
        }
        if (!this.allColumns.equals(other.allColumns)) {
            return false;
        }
        return this.equalsAttributes(other);
    }

    public void setupAttributes() throws LindormException {
        try {
            byte[] tableAttributesBytes = LindormObjectUtils.getBytes(this.tableAttributes);
            this.setAttribute(TABLE_ATTRIBUTES_KEY, tableAttributesBytes);
            if (this.rangeRouter != null) {
                byte[] rangeRouterBytes = LindormObjectUtils.getBytes(this.rangeRouter);
                this.setAttribute(RANGE_ROUTER_KEY, rangeRouterBytes);
            }
            if (null != this.otherAttr) {
                this.setAttribute(OTHER_ATTRIBUTES_KEY, LindormObjectUtils.getBytes(this.otherAttr));
            } else {
                this.removeAttribute(OTHER_ATTRIBUTES_KEY);
            }
            this.indexMeta.setupAttributes(this);
            if (this.externalIndexConfig != null) {
                this.setAttribute(EXTERNAL_INDEX_CONFIG, this.externalIndexConfig);
            }
            this.searchIndexMeta.setupAttributes(this);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void initFromAttributes() throws LindormException {
        try {
            byte[] otherAttrBytes;
            byte[] rangeRouterBytes;
            byte[] tableAttributesBytes = this.getAttribute(TABLE_ATTRIBUTES_KEY);
            if (tableAttributesBytes != null) {
                this.tableAttributes = new TableAttributes();
                LindormObjectUtils.getWritable(tableAttributesBytes, this.tableAttributes);
                if (FeedStreamUtils.isFeedStreamTable(this.tableAttributes)) {
                    StreamSchema schema = this.tableAttributes.getStreamSchema();
                    if (schema.getSchemaType() != StreamSchema.SchemaType.AUTOINCTABLE) {
                        this.type = TableType.STREAM_TABLE;
                    }
                    schema.setSequenceMeta(TableMeta.deepCopy(this, schema.getSequenceSchema()));
                    if (schema.hasIdempotentFamily()) {
                        schema.setIdempotentMeta(TableMeta.deepCopy(this, schema.getIdempotentSchema()));
                    }
                }
            }
            if ((rangeRouterBytes = this.getAttribute(RANGE_ROUTER_KEY)) != null) {
                this.rangeRouter = new RangeRouter();
                LindormObjectUtils.getWritable(rangeRouterBytes, this.rangeRouter);
            }
            if ((otherAttrBytes = this.getAttribute(OTHER_ATTRIBUTES_KEY)) != null) {
                this.otherAttr = new BytesKeyAttributes();
                LindormObjectUtils.getWritable(otherAttrBytes, this.otherAttr);
            }
            this.indexMeta.initFromAttributes(this);
            String externalIndexConfigFromAttr = this.getAttribute(EXTERNAL_INDEX_CONFIG, (String)null);
            if (externalIndexConfigFromAttr != null) {
                this.externalIndexConfig = externalIndexConfigFromAttr;
            }
            this.searchIndexMeta.initFromAttributes(this);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public synchronized void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.version);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.tableName);
        WritableUtils.writeString(out, this.getParentName());
        out.writeByte(this.type.getCode());
        this.familyAttributes.writeTo(out);
        WritableUtils.writeVInt(out, this.families.size());
        for (ColumnFamilyDescriptor f : this.families) {
            f.writeTo(out);
        }
        byte[] schemaBytes = SchemaUtils.columnSchemasToBytes(this.allColumns);
        WritableUtils.writeVInt(out, schemaBytes.length);
        out.write(schemaBytes);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.version = WritableUtils.readVInt(in);
        this.namespace = WritableUtils.readString(in);
        this.tableName = WritableUtils.readString(in);
        this.setParentName(WritableUtils.readString(in));
        this.type = TableType.fromCode(in.readByte());
        this.familyAttributes.readFrom(in);
        int count = WritableUtils.readVInt(in);
        this.families = CollectionUtils.newArrayListWithCapacity(count);
        for (int i = 0; i < count; ++i) {
            ColumnFamilyDescriptor f = new ColumnFamilyDescriptor();
            f.readFrom(in);
            this.families.add(f);
        }
        count = WritableUtils.readVInt(in);
        byte[] schemaBytes = new byte[count];
        in.readFully(schemaBytes);
        this.allColumns = SchemaUtils.bytesToColumnSchemas(schemaBytes);
        this.init();
        this.initFromAttributes();
        this.initAccessor();
    }

    @Override
    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    public String toString(int maxAttrValueSizeToPrint) {
        StringBuilder str = new StringBuilder();
        str.append("Table [");
        str.append(this.namespace);
        str.append(".");
        str.append(this.tableName);
        if (this.getParentName() != null) {
            str.append("], parentTable: [");
            str.append(this.getParentName());
        }
        str.append("], meta_version: [");
        str.append(this.version);
        str.append("], FamilyAttrTable: [");
        str.append(this.familyAttributes.toString());
        str.append("], families:[");
        for (ColumnFamilyDescriptor f : this.families) {
            str.append(f.toString());
            str.append(",");
        }
        str.setLength(str.length() - 1);
        str.append("], columns:");
        str.append(SchemaUtils.columnSchemaToString(this.allColumns));
        str.append("], attr:");
        str.append(SchemaUtils.tableMetaAttributesToString(this, maxAttrValueSizeToPrint));
        if (!this.getIndexMetas().isEmpty()) {
            str.append(", indexes:");
            str.append(this.getIndexMetas().size());
            for (TableMeta indexMeta : this.getIndexMetas().values()) {
                str.append(",@@");
                str.append(indexMeta.toString());
            }
        }
        if (this.otherAttr != null) {
            str.append(", otherAttrT :[");
            str.append(this.otherAttr.toString());
            str.append("]");
        }
        return str.toString();
    }

    public static String toString(List<TableMeta> tables) {
        StringBuilder str = new StringBuilder();
        str.append(tables.size());
        str.append("<");
        for (TableMeta t : tables) {
            if (t.getParentName() == null) {
                str.append(t.getTableName());
            } else {
                str.append(t.getIndexName());
            }
            str.append(",");
        }
        if (tables.size() > 0) {
            str.setLength(str.length() - 1);
        }
        str.append(">");
        return str.toString();
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.namespace.hashCode();
            this.hash = h = 31 * h + this.tableName.hashCode();
        }
        return h;
    }

    private void resetColumnSchema(List<LColumn> allColumns) {
        this.allColumns = allColumns;
        this.init();
    }

    public boolean hasFamily(byte[] family) {
        if (null == this.families) {
            return false;
        }
        for (ColumnFamilyDescriptor cf : this.families) {
            if (!Bytes.equals(family, cf.getName())) continue;
            return true;
        }
        return false;
    }

    public LColumn getFirstPK() {
        return this.pkColumns.get(0);
    }

    public Long getColdHotBoundary(Set<byte[]> cfs) {
        TreeSet<byte[]> cfNames = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        cfNames.addAll(cfs);
        ArrayList<ColumnFamilyDescriptor> cfds = new ArrayList<ColumnFamilyDescriptor>();
        for (ColumnFamilyDescriptor cfd : this.getFamilies()) {
            if (cfNames.isEmpty()) {
                cfds.add(cfd);
                continue;
            }
            if (!cfNames.contains(cfd.getName())) continue;
            cfds.add(cfd);
        }
        String boundary = null;
        boolean hasNotSetColumnFamily = false;
        for (ColumnFamilyDescriptor cfd : cfds) {
            String cfBoundary = cfd.getColdHotSeparateBoundary();
            if (cfBoundary != null && !cfBoundary.isEmpty()) {
                if (boundary != null && !boundary.equals(cfBoundary)) {
                    return null;
                }
                boundary = cfBoundary;
                continue;
            }
            hasNotSetColumnFamily = true;
        }
        String tableBoundary = this.getFamilyAttributes().getColdHotSeparateBoundary();
        if (tableBoundary != null && !tableBoundary.isEmpty()) {
            if (hasNotSetColumnFamily && boundary != null && !boundary.equals(tableBoundary)) {
                return null;
            }
            if (boundary == null) {
                boundary = tableBoundary;
            }
        }
        if (boundary == null) {
            return null;
        }
        String[] tokens = boundary.split(",");
        ArrayList<Long> boundaries = new ArrayList<Long>(tokens.length);
        for (String t : tokens) {
            if ((t = t.trim()).isEmpty()) continue;
            boundaries.add(Long.parseLong(t));
        }
        Collections.sort(boundaries);
        if (boundaries.isEmpty()) {
            return null;
        }
        return (Long)boundaries.get(boundaries.size() - 1) * 1000L;
    }

    public static LindormTableDescriptor buildLindormTableDescriptor(TableMeta tableMeta) {
        String indexConfig;
        LindormTableDescriptor desc = new LindormTableDescriptor();
        desc.setName(tableMeta.getTableName());
        desc.setMetaVersion(tableMeta.getMetaVersion());
        ArrayList<ColumnFamilyDescriptor> temp = new ArrayList<ColumnFamilyDescriptor>(tableMeta.getFamilies());
        desc.setFamilies(temp);
        ArrayList<PrimaryKeySchema> pkColumns = CollectionUtils.newArrayListWithCapacity(tableMeta.getPkColumns().size());
        ArrayList<ColumnSchema> nonPkColumns = CollectionUtils.newArrayListWithCapacity(tableMeta.getNonPkColumns().size());
        SchemaUtils.convertInternalSchemaToClientSchema(tableMeta.getAllColumns(), pkColumns, nonPkColumns);
        desc.setPkColumns(pkColumns);
        desc.setNonPkColumns(nonPkColumns);
        desc.setFamilyAttributes(tableMeta.getFamilyAttributes());
        desc.setTableAttributes(tableMeta.getTableAttributes());
        desc.setOtherAttributes(tableMeta.getOtherAttr());
        Map<String, TableMeta> indexMetas = tableMeta.getIndexMetas();
        if (!indexMetas.isEmpty()) {
            ArrayList<LindormIndexDescriptor> indexDesc = CollectionUtils.newArrayListWithCapacity(indexMetas.size());
            for (TableMeta indexMeta : indexMetas.values()) {
                indexDesc.add(TableMeta.buildLindormIndexDescriptor(tableMeta, indexMeta));
            }
            desc.setIndexes(indexDesc);
            desc.setIndexNames(tableMeta.getIndexLogicalNames());
            desc.setIndexIds(tableMeta.getIndexIds());
            desc.setSilenceIndex(tableMeta.getSilenceIndexMap());
        }
        if (null != (indexConfig = tableMeta.getExternalIndexConfig())) {
            desc.setSearchIndexConfig(indexConfig);
        }
        return desc;
    }

    public static LindormIndexDescriptor buildLindormIndexDescriptor(TableMeta dataTableMeta, TableMeta indexMeta) {
        ColumnKey columnKey;
        LindormIndexDescriptor desc = new LindormIndexDescriptor(indexMeta.getIndexName(), indexMeta.getParentName());
        desc.setTableType(indexMeta.getType());
        desc.setFamilyAttributes(indexMeta.getFamilyAttributes());
        desc.setTableAttributes(indexMeta.getTableAttributes());
        desc.setOtherAttributes(indexMeta.getOtherAttr());
        desc.setMetaVersion(indexMeta.getMetaVersion());
        desc.where(indexMeta.getIndexCondition());
        for (LColumn lColumn : indexMeta.getPkColumns()) {
            if (lColumn.isFunctionColumn()) {
                IndexedColumnSchema indexedColumnSchema = new IndexedColumnSchema(lColumn.getColumnFunction());
                desc.addIndexedColumns(indexedColumnSchema);
                continue;
            }
            columnKey = lColumn.getDataColumnKey();
            if (null == columnKey) continue;
            if (!dataTableMeta.getTableAttributes().isDynamicColumnsEnabled()) {
                columnKey = TableMeta.ignoreDefaultFamilyIfNecessary(columnKey);
            }
            SortOrder sortOrder = lColumn.getSortOrder();
            PrimaryKeyOption option = lColumn.getPkOption();
            if (lColumn.isHashed()) {
                option = PrimaryKeyOption.HASHED;
            }
            IndexedColumnSchema indexedColumnSchema = new IndexedColumnSchema(columnKey, sortOrder, option);
            desc.addIndexedColumns(indexedColumnSchema);
        }
        if (indexMeta.getCoveredColumnType() == CoveredColumnType.ALL) {
            desc.addCoveredColumn(LindormIndexDescriptor.COVERED_ALL_COLUMNS_IN_SCHEMA);
        } else if (indexMeta.getCoveredColumnType() == CoveredColumnType.DYNAMIC) {
            desc.addCoveredColumn(LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS);
        } else {
            for (LColumn lColumn : indexMeta.getNonPkColumns()) {
                if (SchemaUtils.isDefaultColumn(lColumn.getColumnKey().getQualifier())) continue;
                columnKey = lColumn.getDataColumnKey();
                if (!dataTableMeta.getTableAttributes().isDynamicColumnsEnabled()) {
                    columnKey = TableMeta.ignoreDefaultFamilyIfNecessary(columnKey);
                }
                desc.addCoveredColumn(columnKey);
            }
        }
        if (null != indexMeta.getIndexState()) {
            desc.setIndexState(indexMeta.getIndexState());
        }
        desc.setStorePkNulls(indexMeta.isStorePkNulls());
        desc.setStorePkTS(indexMeta.isStorePkTS());
        desc.setStoreFamilyNameInQualifier(indexMeta.isStoreFamilyInQualifier());
        return desc;
    }

    public static ColumnKey ignoreDefaultFamilyIfNecessary(ColumnKey columnKey) {
        ColumnKey newColumnKey = SchemaUtils.isDefaultFamily(columnKey.getFamily()) ? new ColumnKey(columnKey.getQualifier()) : new ColumnKey(columnKey.getFamily(), columnKey.getQualifier());
        return newColumnKey;
    }

    public static class TableMetaBuilder {
        protected String namespace;
        protected int version;
        protected TableType type;
        protected String tableName;
        protected String parentName;
        protected List<ColumnFamilyDescriptor> families;
        protected FamilyAttributes familyAttributes = new FamilyAttributes();
        protected TableAttributes tableAttributes = new TableAttributes();
        protected List<LColumn> allColumns;
        protected List<String> indexLogicalNames;
        protected Map<Byte, String> indexIdNames;
        protected Map<String, SilenceIndex> silenceIndexMap;
        protected BytesKeyAttributes otherAttributes = null;

        public TableMetaBuilder(String namespace) {
            this.namespace = namespace;
        }

        public TableMetaBuilder version(int version) {
            this.version = version;
            return this;
        }

        public TableMetaBuilder type(TableType type) {
            this.type = type;
            return this;
        }

        public TableMetaBuilder parentName(String parentName) {
            this.parentName = parentName;
            return this;
        }

        public TableMetaBuilder indexLogicalNames(List<String> indexLogicalNames) {
            this.indexLogicalNames = indexLogicalNames;
            return this;
        }

        public TableMetaBuilder indexIdNames(Map<Byte, String> indexIdNames) {
            this.indexIdNames = indexIdNames;
            return this;
        }

        public TableMetaBuilder silenceIndexMap(Map<String, SilenceIndex> silenceIndexMap) {
            this.silenceIndexMap = silenceIndexMap;
            return this;
        }

        public TableMetaBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public TableMetaBuilder families(List<ColumnFamilyDescriptor> families) {
            this.families = families;
            return this;
        }

        public TableMetaBuilder allColumns(List<LColumn> allColumns) {
            this.allColumns = allColumns;
            return this;
        }

        public TableMetaBuilder familyAttributes(FamilyAttributes familyAttributes) {
            this.familyAttributes = familyAttributes;
            return this;
        }

        public TableMetaBuilder tableAttributes(TableAttributes tableAttributes) {
            this.tableAttributes = tableAttributes;
            return this;
        }

        public TableMetaBuilder otherAttributes(BytesKeyAttributes otherAttributes) {
            this.otherAttributes = otherAttributes;
            return this;
        }

        public TableMeta build() {
            return new TableMeta(this);
        }
    }
}

