/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

public enum TableType {
    DATA_TABLE(0, "DataTable"),
    WIDE_COLUMN_TABLE(1, "WideColumnTable"),
    STREAM_TABLE(3, "StreamTable"),
    PK_REORDER_INDEX(10, "PKReorderIndex"),
    PK_REORDER_UDT_INDEX(11, "PKReorderUDTIndex"),
    SINGLE_COLUMN_INDEX(12, "SingleColumnIndex"),
    SINGLE_COLUMN_UDT_INDEX(13, "SingleColumnUDTIndex"),
    MULTI_COLUMN_INDEX(14, "MultiColumnIndex"),
    MULTI_COLUMN_UDT_INDEX(15, "MultiColumnUDTIndex"),
    PK_REORDER_LOCAL_INDEX(20, "PKReorderLocalIndex"),
    SINGLE_COLUMN_LOCAL_INDEX(22, "SingleColumnLocalIndex"),
    MULTI_COLUMN_LOCAL_INDEX(24, "MultiColumnLocalIndex");

    private final byte code;
    private final String description;
    private static TableType[] codeArray;

    private TableType(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String toString() {
        return this.description;
    }

    public static TableType fromCode(byte code) {
        TableType tt = codeArray[code & 0xFF];
        if (tt != null) {
            return tt;
        }
        throw new RuntimeException("Unknown table type code " + code);
    }

    public static boolean isIndex(TableType tableType) {
        if (null == tableType) {
            return false;
        }
        return TableType.isPkIndex(tableType) || TableType.isLocalIndex(tableType) || TableType.isMultiColumnIndex(tableType) || TableType.isGlobalIndex(tableType);
    }

    public static boolean isPkIndex(TableType tableType) {
        if (null == tableType) {
            return false;
        }
        switch (tableType) {
            case PK_REORDER_INDEX: 
            case PK_REORDER_UDT_INDEX: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMultiColumnIndex(TableType tableType) {
        if (null == tableType) {
            return false;
        }
        switch (tableType) {
            case MULTI_COLUMN_INDEX: 
            case MULTI_COLUMN_UDT_INDEX: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGlobalIndex(TableType tableType) {
        if (null == tableType) {
            return false;
        }
        switch (tableType) {
            case PK_REORDER_INDEX: 
            case PK_REORDER_UDT_INDEX: 
            case MULTI_COLUMN_INDEX: 
            case MULTI_COLUMN_UDT_INDEX: 
            case SINGLE_COLUMN_INDEX: 
            case SINGLE_COLUMN_UDT_INDEX: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLocalIndex(TableType tableType) {
        if (null == tableType) {
            return false;
        }
        switch (tableType) {
            case PK_REORDER_LOCAL_INDEX: 
            case SINGLE_COLUMN_LOCAL_INDEX: 
            case MULTI_COLUMN_LOCAL_INDEX: {
                return true;
            }
        }
        return false;
    }

    static {
        codeArray = new TableType[256];
        TableType[] arr$ = TableType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TableType tt;
            TableType.codeArray[tt.code & 0xFF] = tt = arr$[i$];
        }
    }
}

