/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.search;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SearchQuery
extends VersionedObjectWithAttributes {
    private Map<String, String> parameters = new HashMap<String, String>();

    public SearchQuery() {
    }

    public SearchQuery(String query) {
        this.parameters.put("q", query);
    }

    public SearchQuery(Map<String, String> input) {
        this.parameters = input;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.parameters.size());
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            WritableUtils.writeString(out, entry.getKey());
            WritableUtils.writeString(out, entry.getValue());
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            String key = WritableUtils.readString(in);
            String value = WritableUtils.readString(in);
            this.parameters.put(key, value);
        }
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(dataStream);
        this.writeTo(out);
        out.close();
        return dataStream.toByteArray();
    }

    public void fromBytes(byte[] bytes) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        this.readFrom(in);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String toString() {
        return this.parameters.toString();
    }
}

