/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.tableservice.AggregateType;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.OrderedColumnKey;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class AggregateOperation
extends VersionedObjectWithAttributes {
    public static final String ORDER_BY_ATTR = "ORDER_BY";
    private AggregateType type;
    private ColumnKey column = null;
    private String aliasedName;
    private DataType interpreterDatatype;
    List<OrderedColumnKey> orderByColumns = null;
    private static final byte VERSION_V2 = 2;

    public static AggregateOperation count() {
        return AggregateOperation.count(null);
    }

    public static AggregateOperation count(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.COUNT.toString(), column);
        return new AggregateOperation(AggregateType.COUNT, column, aliasedName);
    }

    public static AggregateOperation count(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.COUNT, column, aliasedName);
    }

    public static AggregateOperation avg(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.AVG.toString(), column);
        return new AggregateOperation(AggregateType.AVG, column, aliasedName);
    }

    public static AggregateOperation avg(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.AVG, column, aliasedName);
    }

    public static AggregateOperation sum(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.SUM.toString(), column);
        return new AggregateOperation(AggregateType.SUM, column, aliasedName);
    }

    public static AggregateOperation sum(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.SUM, column, aliasedName);
    }

    public static AggregateOperation min(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.MIN.toString(), column);
        return new AggregateOperation(AggregateType.MIN, column, aliasedName);
    }

    public static AggregateOperation min(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.MIN, column, aliasedName);
    }

    public static AggregateOperation max(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.MAX.toString(), column);
        return new AggregateOperation(AggregateType.MAX, column, aliasedName);
    }

    public static AggregateOperation max(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.MAX, column, aliasedName);
    }

    public static AggregateOperation distinct(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.DISTINCT.toString(), column);
        return new AggregateOperation(AggregateType.DISTINCT, column, aliasedName);
    }

    public static AggregateOperation distinct(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.DISTINCT, column, aliasedName);
    }

    public static AggregateOperation orderBy(List<OrderedColumnKey> orderByColumns) {
        return new AggregateOperation(AggregateType.ORDERBY, orderByColumns);
    }

    public static String getDefaultAliasedName(String func, ColumnKey column) {
        return func + "(" + (column != null ? column.toString() : "*") + ")";
    }

    public static String getOrderByDefaultAliasedName(String func, ColumnKey column, SortOrder sortOrder) {
        assert (column != null);
        return func + "(" + column.toString() + ", " + sortOrder.name() + ")";
    }

    public AggregateOperation() {
    }

    private AggregateOperation(AggregateType type, List<OrderedColumnKey> orderByColumns) {
        this.type = type;
        this.orderByColumns = orderByColumns;
    }

    private AggregateOperation(AggregateType type, ColumnKey column, String aliasedName) {
        this.type = type;
        this.column = column;
        this.aliasedName = aliasedName;
    }

    public ColumnKey getColumn() {
        return this.column;
    }

    public String getAliasedName() {
        return this.aliasedName;
    }

    public AggregateType getType() {
        return this.type;
    }

    public DataType getInterpreterDatatype() {
        return this.interpreterDatatype;
    }

    public AggregateOperation setInterpreterDatatype(DataType interpreterDatatype) {
        this.interpreterDatatype = interpreterDatatype;
        return this;
    }

    public List<OrderedColumnKey> getOrderByColumns() {
        return this.orderByColumns;
    }

    @Override
    protected byte getSupportedVersion() {
        return this.useV2Version() ? (byte)2 : (byte)this.getVersion();
    }

    private boolean useV2Version() {
        return this.interpreterDatatype != null;
    }

    @Override
    public String toString() {
        return this.getAliasedName();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AggregateOperation)) {
            return false;
        }
        AggregateOperation other = (AggregateOperation)obj;
        if (this.type != other.type) {
            return false;
        }
        if (!this.aliasedName.equals(other.aliasedName)) {
            return false;
        }
        if (this.column != null != (other.column != null)) {
            return false;
        }
        if (this.column != null && !this.column.equals(other.column)) {
            return false;
        }
        if (this.orderByColumns != null != (other.orderByColumns != null)) {
            return false;
        }
        return this.orderByColumns == null || this.orderByColumns.equals(other.orderByColumns);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.orderByColumns != null) {
            this.writeOrderByColumnsToAttribute();
        } else {
            this.removeAttribute(ORDER_BY_ATTR);
        }
        super.writeTo(out);
        if (this.column != null) {
            out.writeBoolean(true);
            this.column.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        WritableUtils.writeString(out, this.aliasedName);
        out.writeByte(this.type.getId());
        if (this.useV2Version()) {
            WritableUtils.writeString(out, this.interpreterDatatype.name());
        }
    }

    private void writeOrderByColumnsToAttribute() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        WritableUtils.writeVInt(out, this.orderByColumns.size());
        for (ColumnKey columnKey : this.orderByColumns) {
            columnKey.writeTo(out);
        }
        out.close();
        this.setAttribute(ORDER_BY_ATTR, data.toByteArray());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        byte[] orderByColumnsBytes;
        super.readFrom(in);
        boolean hasColumn = in.readBoolean();
        if (hasColumn) {
            this.column = new ColumnKey();
            this.column.readFrom(in);
        } else {
            this.column = null;
        }
        this.aliasedName = WritableUtils.readString(in);
        this.type = AggregateType.fromId(in.readByte());
        if (this.getVersion() >= 2) {
            this.interpreterDatatype = DataType.valueOf(WritableUtils.readString(in));
        }
        if ((orderByColumnsBytes = this.getAttribute(ORDER_BY_ATTR)) != null) {
            this.readOrderByColumnsFromAttribute(orderByColumnsBytes);
        }
    }

    private void readOrderByColumnsFromAttribute(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int size = WritableUtils.readVInt(in);
        this.orderByColumns = CollectionUtils.newArrayListWithCapacity(size);
        for (int i = 0; i < size; ++i) {
            OrderedColumnKey column = new OrderedColumnKey();
            column.readFrom(in);
            this.orderByColumns.add(column);
        }
    }
}

