/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.expression.FunctionCall;
import com.alibaba.lindorm.client.core.expression.Identifier;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.search.SearchQuery;
import com.alibaba.lindorm.client.core.tableservice.AggregateOperation;
import com.alibaba.lindorm.client.core.tableservice.AggregateType;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.HintInfo;
import com.alibaba.lindorm.client.core.tableservice.LAggregateResult;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.Aggregate;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.Hint;
import com.alibaba.lindorm.client.dml.OrderedColumnKey;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.TableNotFoundException;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

public class LAggregate
extends DmlOperation
implements Aggregate {
    public static final String ALLOW_FILTERING_ATTR = "ALLOW_FILTERING";
    public static final String HINT_ATTR = "HINT";
    public static final String ORDER_BY = "ORDER_BY";
    public static final String DISPLAYED_COLUMNS = "DISPLAYED_COLUMNS";
    public static final int NO_LIMIT = -1;
    public static final String LIMIT = "LIMIT";
    public static final int NO_OFFSET = 0;
    public static final String OFFSET = "OFFSET";
    public static final String IS_ORDER_BY_OPERATION = "IS_ORDER_BY_OPERATION";
    public static final String ORDER_BY_COLUMN_INDICES = "order_by_column_indices";
    public static final String GROUP_BY_ATTR = "GROUP_BY_ATTR";
    private boolean isExplain = false;
    private boolean parallelExe = true;
    private Expression where;
    private HintInfo hint = null;
    private List<AggregateOperation> operations = null;
    private int limit = -1;
    private int offset = 0;
    private List<Expression> groupBy = null;
    private Boolean allowFiltering = null;
    private List<OrderedColumnKey> orderByColumns = Collections.emptyList();
    private int[] orderColumnIndices;
    private List<ColumnKey> columns = Collections.emptyList();
    private boolean isOrderByOperation = false;
    private SearchQuery searchQuery;

    public LAggregate() {
    }

    public LAggregate(List<AggregateOperation> operations) {
        this.operations = operations;
    }

    public LAggregate(LindormTableService service) {
        super(service);
        this.operations = CollectionUtils.newArrayList();
    }

    @Override
    public Aggregate from(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Aggregate where(Expression where) {
        this.where = where;
        return this;
    }

    @Override
    public Aggregate where(SearchQuery searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    public SearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    @Override
    public Aggregate count() throws LindormException {
        this.operations.add(AggregateOperation.count());
        return this;
    }

    @Override
    public Aggregate count(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.count(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate count(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.count(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate countAs(String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.count(null, aliasedName));
        return this;
    }

    @Override
    public Aggregate countAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.count(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate countAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.count(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate sum(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate sum(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate sumAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate sumAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate sumAs(String familyName, String columnName, String aliasedName, DataType interpreterDatatype) throws LindormException {
        this.operations.add(AggregateOperation.sum(new ColumnKey(familyName, columnName), aliasedName).setInterpreterDatatype(interpreterDatatype));
        return this;
    }

    @Override
    public Aggregate avg(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate avg(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate avgAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate avgAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate avgAs(String familyName, String columnName, String aliasedName, DataType interpreterDatatype) throws LindormException {
        this.operations.add(AggregateOperation.avg(new ColumnKey(familyName, columnName), aliasedName).setInterpreterDatatype(interpreterDatatype));
        return this;
    }

    @Override
    public Aggregate min(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.min(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate min(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.min(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate minAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.min(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate minAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.min(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate max(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.max(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate max(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.max(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate maxAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.max(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate maxAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.max(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate distinct(String columnName) throws LindormException {
        this.operations.add(AggregateOperation.distinct(new ColumnKey(columnName)));
        return this;
    }

    @Override
    public Aggregate distinct(String familyName, String columnName) throws LindormException {
        this.operations.add(AggregateOperation.distinct(new ColumnKey(familyName, columnName)));
        return this;
    }

    @Override
    public Aggregate distinctAs(String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.distinct(new ColumnKey(columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate distinctAs(String familyName, String columnName, String aliasedName) throws LindormException {
        this.operations.add(AggregateOperation.distinct(new ColumnKey(familyName, columnName), aliasedName));
        return this;
    }

    @Override
    public Aggregate explain() {
        this.isExplain = true;
        return this;
    }

    @Override
    public Aggregate explain(boolean isExplain) {
        this.isExplain = isExplain;
        return this;
    }

    public boolean isAllowFiltering() {
        return this.allowFiltering != null && this.allowFiltering != false;
    }

    @Override
    public Aggregate allowFiltering(boolean value) {
        this.allowFiltering = value;
        return this;
    }

    @Override
    public Aggregate setQueryHotOnly(Boolean hotOnly) {
        if (hotOnly == null) {
            this.removeAttribute("HOT_ONLY");
        } else {
            this.setAttribute("HOT_ONLY", Bytes.toBytes(hotOnly));
        }
        return this;
    }

    @Override
    public Aggregate hint(Hint hint) {
        return this.hint(hint, null);
    }

    @Override
    public Aggregate hint(Hint hint, String detail) {
        this.hint = hint != null ? new HintInfo(hint, detail) : null;
        return this;
    }

    @Override
    public void internalSetTTL(long ttl) {
        throw new UnsupportedOperationException("Setting TTLs on Aggregate is not supported");
    }

    @Override
    public boolean isQueryHotOnly() {
        byte[] value = this.getAttribute("HOT_ONLY");
        return value != null && Bytes.toBoolean(value);
    }

    public boolean isParallelExe() {
        return this.parallelExe;
    }

    public void setParallelExe(boolean isParallelExe) {
        this.parallelExe = isParallelExe;
    }

    public boolean isExplain() {
        return this.isExplain;
    }

    public Expression getWhere() {
        return this.where;
    }

    public List<AggregateOperation> getAggregateOperations() {
        return this.operations;
    }

    public HintInfo getHint() {
        return this.hint;
    }

    @Override
    public Aggregate orderBy(List<OrderedColumnKey> orderByColumns) throws LindormException {
        this.isOrderByOperation = true;
        this.checkOrderedColumnKeys(orderByColumns);
        this.operations.add(AggregateOperation.orderBy(orderByColumns));
        this.orderByColumns = orderByColumns;
        return this;
    }

    public Aggregate limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("LIMIT must > 0, but has " + limit);
        }
        this.limit = limit;
        return this;
    }

    public Aggregate offset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("OFFSET must >= 0, but has " + offset);
        }
        this.offset = offset;
        return this;
    }

    public Aggregate columns(String ... columns) {
        this.columns = CollectionUtils.newArrayListWithCapacity(columns.length);
        for (String col : columns) {
            this.columns.add(new ColumnKey(Bytes.toBytes(col)));
        }
        return this;
    }

    public Aggregate columns(byte[] ... columns) {
        this.columns = CollectionUtils.newArrayListWithCapacity(columns.length);
        for (byte[] col : columns) {
            this.columns.add(new ColumnKey(col));
        }
        return this;
    }

    public Aggregate columns(List<ColumnKey> columns) {
        this.columns = columns;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isOrderByOperation() {
        return this.isOrderByOperation;
    }

    public List<OrderedColumnKey> getOrderByColumns() {
        return this.orderByColumns;
    }

    public List<ColumnKey> getColumns() {
        return this.columns;
    }

    @Override
    public Aggregate groupBy(Expression ... expressions) {
        this.groupBy = CollectionUtils.newArrayListWithCapacity(expressions.length);
        for (Expression expression : expressions) {
            this.groupBy.add(expression);
        }
        return this;
    }

    public List<Expression> getGroupBy() {
        return this.groupBy;
    }

    public int[] getOrderColumnIndices() {
        return this.orderColumnIndices;
    }

    private LServerCallable<LAggregateResult> buildAggregateCallable() {
        return new LServerCallable<LAggregateResult>((DmlOperation)this, OperationContext.OperationType.AGGREGATE){

            @Override
            public LAggregateResult call() throws Exception {
                return this.server.aggregate(LAggregate.this);
            }
        };
    }

    private void resetParamValues(List<Object> params) throws LindormException {
        if (this.where != null) {
            this.where.resetParamValues(params);
        }
    }

    @Override
    public Future<Row> executeAsync() throws LindormException {
        final ClientCompletableFuture<Row> future = new ClientCompletableFuture<Row>();
        this.executeAsync(new AsyncCallback<Row>(){

            @Override
            public void onComplete(Row result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public Future<Row> executeAsync(List<Object> params) throws LindormException {
        this.resetParamValues(params);
        return this.executeAsync();
    }

    @Override
    public void executeAsync(AsyncCallback<Row> callback) throws LindormException {
        this.validate();
        this.setupRouteKey();
        OperationContext.OperationType operationType = OperationContext.OperationType.AGGREGATE;
        LServerCallable<LAggregateResult> aggregateCallable = this.buildAggregateCallable();
        RetryingCaller<LAggregateResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        Object traceContext = this.service.startOperationAsync(this.tableName, operationType);
        AsyncLAggregateResultHandler asyncAggregateHandler = new AsyncLAggregateResultHandler(callback, operationType, System.currentTimeMillis(), traceContext, retryingCaller);
        retryingCaller.withRetriesAsync(aggregateCallable, asyncAggregateHandler);
    }

    @Override
    public void executeAsync(List<Object> params, AsyncCallback<Row> callback) throws LindormException {
        this.resetParamValues(params);
        this.executeAsync(callback);
    }

    @Override
    public Row execute() throws LindormException {
        LAggregateResult aggregateResult = this.executeInternal();
        return aggregateResult.getResult();
    }

    @Override
    public Row execute(List<Object> params) throws LindormException {
        this.resetParamValues(params);
        return this.execute();
    }

    @Override
    public List<Row> executeGroupBy() throws LindormException {
        LAggregateResult aggregateResult = this.executeInternal();
        return aggregateResult.getResults();
    }

    private LAggregateResult executeInternal() throws LindormException {
        this.validate();
        this.service.startOperation(this.tableName, OperationContext.OperationType.AGGREGATE);
        RetryingCaller<LAggregateResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        try {
            this.setupRouteKey();
            LServerCallable<LAggregateResult> aggregateCallable = this.buildAggregateCallable();
            long start = System.currentTimeMillis();
            LAggregateResult result = retryingCaller.withRetries(aggregateCallable);
            this.handleResultAttributes(this, result);
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, OperationContext.OperationType.AGGREGATE, System.currentTimeMillis() - start, 1);
            this.service.endOperationSuccessfully(this.tableName, retryingCaller);
            return result;
        }
        catch (Throwable t) {
            if (t instanceof TableNotFoundException) {
                this.service.getLConnection().getTableMetaCache().removeTable(this.namespace, this.tableName);
            }
            LindormException error = new LindormException(t);
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, OperationContext.OperationType.DELETE, error);
            this.service.endOperationExceptionally(this.tableName, retryingCaller, t);
            throw error;
        }
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        return CompilerUtils.getRowKeyForRouting(meta, this.where);
    }

    @Override
    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LAggregate)) {
            return false;
        }
        LAggregate other = (LAggregate)obj;
        if (this.where == null != (other.where == null)) {
            return false;
        }
        if (this.where != null && !this.where.equals(other.where)) {
            return false;
        }
        if (!this.operations.equals(other.operations)) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.columns.size() != other.columns.size()) {
            return false;
        }
        for (i = 0; i < this.columns.size(); ++i) {
            if (this.columns.get(i).equals(other.columns)) continue;
            return false;
        }
        if (this.orderByColumns.size() != other.orderByColumns.size()) {
            return false;
        }
        for (i = 0; i < this.orderByColumns.size(); ++i) {
            if (this.orderByColumns.get(i).equals(other.orderByColumns)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("AGGREGATE ");
        if (!this.columns.isEmpty()) {
            for (ColumnKey ck : this.columns) {
                str.append(ck.toString());
                str.append(",");
            }
        }
        for (AggregateOperation op : this.operations) {
            str.append(op.toString());
            str.append(",");
        }
        if (!this.operations.isEmpty()) {
            str.setLength(str.length() - 1);
        }
        str.append(" from ");
        str.append(this.tableName);
        if (this.where != null) {
            str.append(" where ");
            str.append(this.where.toString());
        }
        if (this.searchQuery != null) {
            str.append(" where search_query = ");
            str.append(this.searchQuery);
        }
        if (this.groupBy != null && !this.groupBy.isEmpty()) {
            str.append(" group by ");
            for (Expression e : this.groupBy) {
                str.append(e.toString());
                str.append(",");
            }
            str.setLength(str.length() - 1);
        }
        if (!this.orderByColumns.isEmpty()) {
            str.append(" order by ");
            for (OrderedColumnKey ock : this.orderByColumns) {
                str.append(ock.toString());
                str.append(",");
            }
            str.setLength(str.length() - 1);
        }
        if (this.limit != -1) {
            str.append(" limit ");
            str.append(this.limit);
        }
        if (this.offset != 0) {
            str.append(" offset ").append(this.offset);
        }
        return str.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        assert (!this.operations.isEmpty());
        out.writeBoolean(this.isExplain);
        out.writeBoolean(this.parallelExe);
        if (this.where != null) {
            out.writeBoolean(true);
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
            this.where.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        WritableUtils.writeVInt(out, this.operations.size());
        for (AggregateOperation op : this.operations) {
            op.writeTo(out);
        }
    }

    private void setupAttributes() throws LindormException {
        try {
            if (this.allowFiltering != null) {
                this.setAttribute(ALLOW_FILTERING_ATTR, Bytes.toBytes(this.allowFiltering));
            } else {
                this.removeAttribute(ALLOW_FILTERING_ATTR);
            }
            if (this.searchQuery != null) {
                this.setAttribute("SEARCH", this.searchQuery.toBytes());
            } else {
                this.removeAttribute("SEARCH");
            }
            if (this.hint != null) {
                this.setAttribute(HINT_ATTR, HintInfo.toBytes(this.hint));
            } else {
                this.setAttribute(HINT_ATTR, (byte[])null);
            }
            if (!this.orderByColumns.isEmpty()) {
                this.writeColumnsToAttribute(this.orderByColumns, ORDER_BY);
            } else {
                this.removeAttribute(ORDER_BY);
            }
            if (!this.columns.isEmpty()) {
                this.writeColumnsToAttribute(this.columns, DISPLAYED_COLUMNS);
            } else {
                this.removeAttribute(DISPLAYED_COLUMNS);
            }
            if (this.limit != -1) {
                this.setAttribute(LIMIT, Bytes.toBytes(this.limit));
            } else {
                this.removeAttribute(LIMIT);
            }
            if (this.offset != 0) {
                this.setAttribute(OFFSET, Bytes.toBytes(this.offset));
            } else {
                this.removeAttribute(OFFSET);
            }
            if (this.isOrderByOperation) {
                this.setAttribute(IS_ORDER_BY_OPERATION, Bytes.toBytes(this.isOrderByOperation));
            } else {
                this.removeAttribute(IS_ORDER_BY_OPERATION);
            }
            if (this.operationTimeout != -1) {
                this.setAttribute("OPERATION_TIMEOUT", Bytes.toBytes(this.operationTimeout));
            } else {
                this.removeAttribute("OPERATION_TIMEOUT");
            }
            if (this.rpcTimeout != -1) {
                this.setAttribute("RPC_TIMEOUT", Bytes.toBytes(this.rpcTimeout));
            } else {
                this.removeAttribute("RPC_TIMEOUT");
            }
            if (this.groupBy != null && !this.groupBy.isEmpty()) {
                this.writeGroupByToAttribute(this.groupBy, GROUP_BY_ATTR);
            } else {
                this.removeAttribute(GROUP_BY_ATTR);
            }
            if (this.orderColumnIndices != null) {
                this.writeOrderColumnIndicesToAttr(this.orderColumnIndices, ORDER_BY_COLUMN_INDICES);
            } else {
                this.removeAttribute(ORDER_BY_COLUMN_INDICES);
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void writeColumnsToAttribute(List<? extends ColumnKey> columns, String attr) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        WritableUtils.writeVInt(out, columns.size());
        for (ColumnKey columnKey : columns) {
            columnKey.writeTo(out);
        }
        out.close();
        this.setAttribute(attr, data.toByteArray());
    }

    private void writeGroupByToAttribute(List<Expression> groupBy, String attr) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        WritableUtils.writeVInt(out, groupBy.size());
        for (Expression expression : groupBy) {
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(expression));
            expression.writeTo(out);
        }
        out.close();
        this.setAttribute(attr, data.toByteArray());
    }

    private void writeOrderColumnIndicesToAttr(int[] orderColumnIndices, String attr) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        WritableUtils.writeVInt(out, orderColumnIndices.length);
        for (int i : orderColumnIndices) {
            WritableUtils.writeVInt(out, i);
        }
        out.close();
        this.setAttribute(attr, data.toByteArray());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.isExplain = in.readBoolean();
        this.parallelExe = in.readBoolean();
        boolean hasWhere = in.readBoolean();
        if (hasWhere) {
            this.where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
            this.where.readFrom(in);
        } else {
            this.where = null;
        }
        int functionNumber = WritableUtils.readVInt(in);
        this.operations = CollectionUtils.newArrayListWithCapacity(functionNumber);
        for (int i = 0; i < functionNumber; ++i) {
            AggregateOperation op = new AggregateOperation();
            op.readFrom(in);
            this.operations.add(op);
        }
        this.initFromAttributes();
    }

    private void initFromAttributes() throws LindormException {
        try {
            byte[] orderColumnIndicesBytes;
            byte[] groupByBytes;
            byte[] rpcTimeoutBytes;
            byte[] operationTimeoutBytes;
            byte[] isOrderByBytes;
            byte[] offsetBytes;
            byte[] limitBytes;
            byte[] columnsBytes;
            byte[] orderByColumnsBytes;
            byte[] hintBytes;
            byte[] searchQueryBytes;
            byte[] allowFilteringBytes = this.getAttribute(ALLOW_FILTERING_ATTR);
            if (allowFilteringBytes != null) {
                this.allowFiltering = Bytes.toBoolean(allowFilteringBytes);
            }
            if ((searchQueryBytes = this.getAttribute("SEARCH")) != null) {
                this.searchQuery = new SearchQuery();
                this.searchQuery.fromBytes(searchQueryBytes);
            }
            if ((hintBytes = this.getAttribute(HINT_ATTR)) != null) {
                this.hint = HintInfo.fromBytes(hintBytes);
            }
            if ((orderByColumnsBytes = this.getAttribute(ORDER_BY)) != null) {
                this.readOrderByColumnsFromAttribute(orderByColumnsBytes);
            }
            if ((columnsBytes = this.getAttribute(DISPLAYED_COLUMNS)) != null) {
                this.readColumnsFromAttribute(columnsBytes);
            }
            if ((limitBytes = this.getAttribute(LIMIT)) != null) {
                this.limit = Bytes.toInt(limitBytes);
            }
            if ((offsetBytes = this.getAttribute(OFFSET)) != null) {
                this.offset = Bytes.toInt(offsetBytes);
            }
            if ((isOrderByBytes = this.getAttribute(IS_ORDER_BY_OPERATION)) != null) {
                this.isOrderByOperation = Bytes.toBoolean(isOrderByBytes);
            }
            if ((operationTimeoutBytes = this.getAttribute("OPERATION_TIMEOUT")) != null) {
                this.operationTimeout = Bytes.toInt(operationTimeoutBytes);
            }
            if ((rpcTimeoutBytes = this.getAttribute("RPC_TIMEOUT")) != null) {
                this.rpcTimeout = Bytes.toInt(rpcTimeoutBytes);
            }
            if ((groupByBytes = this.getAttribute(GROUP_BY_ATTR)) != null) {
                this.readGroupByFromAttribute(groupByBytes);
            }
            if ((orderColumnIndicesBytes = this.getAttribute(ORDER_BY_COLUMN_INDICES)) != null) {
                this.readOrderColumnIndicesFromAttribute(orderColumnIndicesBytes);
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void readOrderByColumnsFromAttribute(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int size = WritableUtils.readVInt(in);
        this.orderByColumns = CollectionUtils.newArrayListWithCapacity(size);
        for (int i = 0; i < size; ++i) {
            OrderedColumnKey column = new OrderedColumnKey();
            column.readFrom(in);
            this.orderByColumns.add(column);
        }
    }

    private void readGroupByFromAttribute(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int size = WritableUtils.readVInt(in);
        this.groupBy = CollectionUtils.newArrayListWithCapacity(size);
        for (int i = 0; i < size; ++i) {
            int type = WritableUtils.readVInt(in);
            Expression expression = ExpressionType.fromOrdinal(type);
            expression.readFrom(in);
            this.groupBy.add(expression);
        }
    }

    private void readColumnsFromAttribute(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int size = WritableUtils.readVInt(in);
        this.columns = CollectionUtils.newArrayListWithCapacity(size);
        for (int i = 0; i < size; ++i) {
            ColumnKey column = new ColumnKey();
            column.readFrom(in);
            this.columns.add(column);
        }
    }

    private void readOrderColumnIndicesFromAttribute(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int size = WritableUtils.readVInt(in);
        this.orderColumnIndices = new int[size];
        for (int i = 0; i < size; ++i) {
            this.orderColumnIndices[i] = WritableUtils.readVInt(in);
        }
    }

    private void validate() throws LindormException {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalRequestException("Table name must not be null or empty.");
        }
        if (this.operations == null || this.operations.isEmpty()) {
            throw new IllegalRequestException("Must specify at least one aggregate operation.");
        }
        if (this.groupBy != null && !this.groupBy.isEmpty() && this.orderByColumns != null && !this.orderByColumns.isEmpty()) {
            this.checkOrderColumnAndGroupByExpression();
        }
    }

    private void checkOrderedColumnKeys(List<OrderedColumnKey> orderedColumnKeys) throws LindormException {
        if (orderedColumnKeys == null) {
            throw new LindormException("Not specified ordered column keys");
        }
        HashSet<String> columnName = new HashSet<String>();
        for (OrderedColumnKey ock : orderedColumnKeys) {
            String name = ock.getFullNameAsString();
            if (SchemaUtils.isDefaultFamily(ock.getFamily())) {
                name = ock.getQualifierAsString();
            }
            if (columnName.contains(name)) {
                throw new LindormException("Ordered column keys has same column: " + ock.getFullNameAsString());
            }
            columnName.add(ock.getFullNameAsString());
        }
    }

    private void checkOrderColumnAndGroupByExpression() {
        int[] orderColumnIndices = new int[this.orderByColumns.size()];
        ArrayList<ColumnKey> columnKeysCanBeOrdered = new ArrayList<ColumnKey>(this.groupBy.size() + this.operations.size());
        List<ColumnKey> groupKeys = this.getGroupByColumnKey();
        columnKeysCanBeOrdered.addAll(groupKeys);
        Iterator<AggregateOperation> iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            AggregateOperation operation = iterator.next();
            if (operation.getType() == AggregateType.ORDERBY) {
                iterator.remove();
                continue;
            }
            if (operation.getType() == AggregateType.DISTINCT) {
                iterator.remove();
                continue;
            }
            columnKeysCanBeOrdered.add(new ColumnKey(operation.getAliasedName()));
        }
        for (int i = 0; i < orderColumnIndices.length; ++i) {
            OrderedColumnKey orderedColumnKey = this.orderByColumns.get(i);
            int index = -1;
            for (int j = 0; j < columnKeysCanBeOrdered.size(); ++j) {
                if (!orderedColumnKey.getColumnKey().equals(columnKeysCanBeOrdered.get(j))) continue;
                index = j;
                break;
            }
            if (index == -1) {
                throw new IllegalArgumentException("The order by key [" + orderedColumnKey.getColumnKey().getFullNameAsString() + "] does not exist in group by keys or aggregation alias. ");
            }
            orderColumnIndices[i] = index;
        }
        this.orderColumnIndices = orderColumnIndices;
    }

    private List<ColumnKey> getGroupByColumnKey() {
        if (this.groupBy == null || this.groupBy.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ColumnKey> result = new ArrayList<ColumnKey>(this.groupBy.size());
        for (Expression e : this.groupBy) {
            if (e instanceof Identifier) {
                result.add(((Identifier)e).toColumnKey());
                continue;
            }
            if (e instanceof FunctionCall) {
                String columnName = ((FunctionCall)e).getAlias() != null ? ((FunctionCall)e).getAlias() : e.toString();
                result.add(new ColumnKey(columnName));
                continue;
            }
            throw new UnsupportedOperationException("We only support Identifier or FunctionCall at group by keys, but has " + e.toString());
        }
        return result;
    }

    private class AsyncLAggregateResultHandler
    extends DmlOperation.AsyncMutationHandler<Row, LAggregateResult> {
        public AsyncLAggregateResultHandler(AsyncCallback<Row> callback, OperationContext.OperationType operationType, long startTime, Object traceContext, RetryingCaller caller) {
            super(LAggregate.this, callback, operationType, startTime, traceContext, caller);
        }

        @Override
        protected int getAffectedRows(LAggregateResult result) {
            return 1;
        }

        @Override
        protected Row getReturnValue(LAggregateResult result) {
            return result.getResult();
        }
    }
}

