/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.Row;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class LAggregateResult
extends VersionedObjectWithAttributes {
    public static final String MULTI_ROWS_RESULT = "MULTI_ROWS_RESULT";
    private Row result = new Row();
    private List<Row> results;
    private int estimatedSize = 0;

    public LAggregateResult() {
    }

    public LAggregateResult(Row result) {
        this.result = result;
    }

    public LAggregateResult(List<Row> results) {
        this.results = results;
    }

    public Row getResult() {
        return this.result;
    }

    public List<Row> getResults() {
        return this.results;
    }

    public int getEstimatedSize() {
        if (this.estimatedSize == 0) {
            this.estimatedSize += this.getAttrEstimatedSize();
            if (this.results != null && !this.results.isEmpty()) {
                this.estimatedSize += 4;
                for (Row r : this.results) {
                    this.estimatedSize += r.getEstimatedSize();
                }
            }
            if (this.result != null) {
                this.estimatedSize += this.result.getEstimatedSize();
            }
        }
        return this.estimatedSize;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.results != null) {
            this.writeMultiRowsResultToAttribute();
        } else {
            this.removeAttribute(MULTI_ROWS_RESULT);
        }
        super.writeTo(out);
        this.result.writeTo(out);
    }

    private void writeMultiRowsResultToAttribute() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        WritableUtils.writeVInt(out, this.results.size());
        for (Row row : this.results) {
            row.writeTo(out);
        }
        out.close();
        this.setAttribute(MULTI_ROWS_RESULT, data.toByteArray());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.result = new Row();
        this.result.readFrom(in);
        byte[] orderByColumnsBytes = this.getAttribute(MULTI_ROWS_RESULT);
        if (orderByColumnsBytes != null) {
            this.readMultiRowsResultFromAttribute(orderByColumnsBytes);
        }
    }

    private void readMultiRowsResultFromAttribute(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int size = WritableUtils.readVInt(in);
        this.results = CollectionUtils.newArrayListWithCapacity(size);
        for (int i = 0; i < size; ++i) {
            Row row = new Row();
            row.readFrom(in);
            this.results.add(row);
        }
    }
}

