/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.tableservice.LUpsert;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.dml.Update;
import com.alibaba.lindorm.client.dml.Upsert;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class LUpdate
extends LUpsert
implements Update {
    private Map<ColumnKey, Expression> updateValues = new HashMap<ColumnKey, Expression>();

    public LUpdate() {
        this.setRows(new ArrayList<Row>());
    }

    public LUpdate(LindormTableService service) {
        super(service);
        this.setRows(new ArrayList<Row>());
    }

    @Override
    public Update into(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Update set(String columnName, Expression value) throws LindormException {
        return this.set(null, Bytes.toBytes(columnName), value);
    }

    @Override
    public Update set(String familyName, String columnName, Expression value) throws LindormException {
        if (StringUtils.isNullOrEmpty(columnName)) {
            throw new IllegalRequestException("Column name cannot be null or empty.");
        }
        return this.set(familyName != null ? Bytes.toBytes(familyName) : null, Bytes.toBytes(columnName), value);
    }

    @Override
    public Update set(byte[] columnName, Expression value) throws LindormException {
        return this.set(null, columnName, value);
    }

    @Override
    public Update set(byte[] familyName, byte[] columnName, Expression value) throws LindormException {
        if (value == null) {
            throw new IllegalRequestException("Cannot update null values.");
        }
        ColumnKey ck = new ColumnKey(familyName, columnName);
        this.updateValues.put(ck, value);
        return this;
    }

    @Override
    public Update where(Condition where) throws LindormException {
        this.where = where;
        return this;
    }

    public Map<ColumnKey, Expression> getUpdateValues() {
        return this.updateValues;
    }

    @Override
    public Future<Integer> executeAsync() throws LindormException {
        throw new UnsupportedOperationException("Support latter");
    }

    @Override
    public void executeAsync(AsyncCallback<Integer> callback) throws LindormException {
        throw new UnsupportedOperationException("Support latter");
    }

    @Override
    protected LServerCallable<LMutationResult> buildUpsertCallable(OperationContext.OperationType operationType) {
        return new LServerCallable<LMutationResult>((DmlOperation)this, operationType){

            @Override
            public LMutationResult call() throws Exception {
                return this.server.upsert(LUpdate.this);
            }
        };
    }

    @Override
    protected boolean isEmpty() {
        return this.updateValues.isEmpty();
    }

    @Override
    protected void validate() throws LindormException {
        super.validate();
        if (this.where == null) {
            throw new IllegalRequestException("WHERE clause must not be null or empty for UPDATE.");
        }
    }

    public Map<ColumnKey, Expression> getValues() {
        return this.updateValues;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        assert (this.where != null);
        assert (this.updateValues != null);
        assert (!this.updateValues.isEmpty());
        try {
            super.writeTo(out);
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
            this.where.writeTo(out);
            WritableUtils.writeVInt(out, this.updateValues.size());
            for (Map.Entry<ColumnKey, Expression> val : this.updateValues.entrySet()) {
                val.getKey().writeTo(out);
                WritableUtils.writeVInt(out, ExpressionType.getOrdinal(val.getValue()));
                val.getValue().writeTo(out);
            }
        }
        catch (Throwable t) {
            throw new IllegalRequestException(t);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.where = ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
        assert (this.where != null);
        this.where.readFrom(in);
        int mapSize = WritableUtils.readVInt(in);
        this.updateValues = new HashMap<ColumnKey, Expression>(mapSize);
        while (mapSize-- > 0) {
            ColumnKey ck = new ColumnKey();
            ck.readFrom(in);
            Expression value = ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
            assert (value != null);
            value.readFrom(in);
            this.updateValues.put(ck, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("UPDATE ");
        str.append(this.tableName);
        str.append(" SET ");
        for (Map.Entry<ColumnKey, Expression> val : this.updateValues.entrySet()) {
            str.append(val.getKey());
            str.append("=");
            str.append(val.getValue());
            str.append(",");
        }
        if (!this.updateValues.isEmpty()) {
            str.setLength(str.length() - 1);
        }
        str.append(" WHERE ");
        str.append(this.where.toString());
        return str.toString();
    }

    @Override
    public Upsert add(Row row) {
        throw new UnsupportedOperationException("Do not support add row operation of Update");
    }

    @Override
    public Upsert setRows(List<Row> rows) {
        if (rows != null && !rows.isEmpty()) {
            throw new UnsupportedOperationException("Do not support set rows operation of Update");
        }
        return super.setRows(rows);
    }

    @Override
    public Upsert setTTL(long ttl) {
        throw new UnsupportedOperationException("Do not support set ttl operation of Update");
    }

    @Override
    public Upsert check(Condition condition) throws LindormException {
        throw new UnsupportedOperationException("Do not support check condition of Update yet");
    }

    @Override
    public Upsert check(Condition condition, ConditionFactory.RowExistenceCondition rowExistenceCondition) throws LindormException {
        throw new UnsupportedOperationException("Do not support check condition of Update yet");
    }
}

