/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.BlobClient;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.BlobClientUtil;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataInputBuffer;
import com.alibaba.lindorm.client.core.utils.Threads;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.dml.Upsert;
import com.alibaba.lindorm.client.exception.DoNotRetryIOException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.TableNotFoundException;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

public class LUpsert
extends DmlOperation
implements Upsert {
    private static final String WHERE_ATTR = "CONDITION";
    private static final String ROW_EXISTENCE_ATTR = "ROW_CONDITION";
    private static final String DELETE_WHEN_VALUE_IS_NULL = "DELETE_WHEN_VALUE_IS_NULL";
    private static final boolean DEFAULT_DELETE_WHEN_VALUE_IS_NULL = false;
    private List<Row> rows;
    protected Expression where = null;
    private ConditionFactory.RowExistenceCondition rowExistenceCondition;
    private boolean deleteWhenValueIsNull = false;

    public LUpsert() {
    }

    public LUpsert(LindormTableService service) {
        super(service);
    }

    @Override
    public Upsert into(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Upsert add(Row row) {
        if (this.rows == null) {
            this.rows = CollectionUtils.newArrayList();
        }
        this.rows.add(row);
        return this;
    }

    @Override
    public Upsert setRows(List<Row> rows) {
        this.rows = rows;
        return this;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public Expression getWhere() {
        return this.where;
    }

    protected LServerCallable<LMutationResult> buildUpsertCallable(OperationContext.OperationType operationType) {
        return new LServerCallable<LMutationResult>((DmlOperation)this, operationType){

            @Override
            public LMutationResult call() throws Exception {
                return this.server.upsert(LUpsert.this);
            }
        };
    }

    protected OperationContext.OperationType getOperationType() throws IllegalRequestException {
        if (this.where != null) {
            return OperationContext.OperationType.CONDITIONAL_UPSERT;
        }
        return OperationContext.OperationType.UPSERT;
    }

    protected void checkResultCompatibility(Object[] results) throws IOException {
        if (results == null) {
            return;
        }
        for (int index = results.length - 1; index >= 0; --index) {
            if (results[index] instanceof VersionedObjectWithAttributes) continue;
            throw new DoNotRetryIOException("Some rows are not finished, maybe we are requesting LDServer with a older version?");
        }
    }

    public void resetParamValues(List<List<Object>> params, boolean addBatch) throws LindormException {
        if (this.rows == null || this.rows.isEmpty()) {
            return;
        }
        Iterator<Row> iterator = this.rows.iterator();
        List<Object> paramLists = new ArrayList<Object>();
        Iterator<List<Object>> paramIterator = null;
        if (!addBatch) {
            for (List<Object> param : params) {
                paramLists.addAll(param);
            }
        } else {
            paramIterator = params.iterator();
        }
        while (iterator.hasNext()) {
            Row row = iterator.next();
            if (addBatch) {
                paramLists = paramIterator.next();
            }
            row.resetParamValue(paramLists);
        }
        if (this.where != null) {
            this.where.resetParamValues(paramLists);
        }
    }

    @Override
    public Future<Integer> executeAsync() throws LindormException {
        final ClientCompletableFuture<Integer> future = new ClientCompletableFuture<Integer>();
        this.executeAsync(new AsyncCallback<Integer>(){

            @Override
            public void onComplete(Integer result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public Future<Integer> executeAsync(List<List<Object>> params, boolean addBatch) throws LindormException {
        this.resetParamValues(params, addBatch);
        return this.executeAsync();
    }

    @Override
    public void executeAsync(AsyncCallback<Integer> callback) throws LindormException {
        if (this.isEmpty()) {
            callback.onComplete(0);
            return;
        }
        this.validate();
        this.setupRouteKey();
        OperationContext.OperationType operationType = this.getOperationType();
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LMutationResult> upsertCallable = this.buildUpsertCallable(operationType);
        Object context = this.service.startOperationAsync(this.tableName, operationType);
        int rows = this.getRows() == null ? 0 : this.getRows().size();
        AsyncUpsertHandler asyncUpsertHandler = new AsyncUpsertHandler(callback, operationType, System.currentTimeMillis(), rows, context, retryingCaller);
        retryingCaller.withRetriesAsync(upsertCallable, asyncUpsertHandler);
    }

    @Override
    public void executeAsync(List<List<Object>> params, AsyncCallback<Integer> callback, boolean addBatch) throws LindormException {
        this.resetParamValues(params, addBatch);
        this.executeAsync(callback);
    }

    @Override
    public int execute() throws LindormException {
        if (this.isEmpty()) {
            return 0;
        }
        this.validate();
        OperationContext.OperationType operationType = this.getOperationType();
        long start = System.currentTimeMillis();
        this.service.startOperation(this.tableName, operationType);
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        try {
            this.blobColumnObjectUpsert();
            LServerCallable<LMutationResult> upsertCallable = this.buildUpsertCallable(operationType);
            this.setupRouteKey();
            LMutationResult response = retryingCaller.withRetries(upsertCallable);
            this.handleResultAttributes(this, response);
            int affectedRows = response.getNumberOfRowsAffected();
            this.checkResultCompatibility(response.getResults());
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, operationType, System.currentTimeMillis() - start, affectedRows);
            this.service.endOperationSuccessfully(this.tableName, retryingCaller);
            return affectedRows;
        }
        catch (Throwable t) {
            if (t instanceof TableNotFoundException) {
                this.service.getLConnection().getTableMetaCache().removeTable(this.namespace, this.tableName);
            }
            String msg = this.buildErrorMsg(operationType, t, System.currentTimeMillis() - start, this.getRows() == null ? 0 : this.getRows().size());
            LindormException error = new LindormException(msg);
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, operationType, error);
            this.service.endOperationExceptionally(this.tableName, retryingCaller, t);
            throw error;
        }
    }

    private void blobColumnObjectUpsert() throws LindormException {
        if (this.service.getBlobClient() == null) {
            return;
        }
        TableMeta tableMeta = this.tryGetTableMeta();
        if (tableMeta == null) {
            try {
                tableMeta = this.service.getTableMeta(this.getTableName());
            }
            catch (IOException e) {
                throw new LindormException(e);
            }
        }
        if (!tableMeta.hasBlobColumn()) {
            return;
        }
        for (Row row : this.getRows()) {
            block7: for (ColumnValue columnValue : row.getColumnValues()) {
                if (columnValue.getType() != DataType.BLOB) continue;
                HashMap<String, String> jsonMap = new HashMap<String, String>();
                String keyName = BlobClientUtil.encodeBlobKeyFromRowData(row, tableMeta, columnValue.getColumnKey());
                String bucketName = BlobClientUtil.formatBlobBucketKey(this.getNamespace(), this.getTableName());
                jsonMap.put("objectkey", keyName);
                BlobClient client = this.service.getBlobClient();
                try {
                    for (int i = 0; i != client.getNumRetries(); ++i) {
                        try {
                            BlobClientUtil.uploadBlobObject(bucketName, keyName, columnValue.asBlob(), this.service.getBlobClient(), jsonMap);
                            columnValue.setBlob(BlobClientUtil.getTheBlobColumnRealValue(jsonMap));
                            continue block7;
                        }
                        catch (Throwable t) {
                            if (i != client.getNumRetries() - 1) continue;
                            throw new LindormException("Lindorm upsert blob object failed for table  " + this.getNamespace() + "." + this.getTableName() + " on object key " + keyName + " after " + client.getNumRetries() + " times with exception " + t);
                        }
                    }
                }
                catch (LindormException e) {
                    throw new LindormException(e);
                }
            }
        }
    }

    @Override
    public int execute(List<List<Object>> params, boolean addBatch) throws LindormException {
        this.resetParamValues(params, addBatch);
        return this.execute();
    }

    @Override
    public List<Object> executeWithResults() throws LindormException {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        this.validate();
        OperationContext.OperationType operationType = this.getOperationType();
        long start = System.currentTimeMillis();
        this.service.startOperation(this.tableName, operationType);
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        try {
            this.blobColumnObjectUpsert();
            LServerCallable<LMutationResult> upsertCallable = this.buildUpsertCallable(operationType);
            this.setupRouteKey();
            LMutationResult response = retryingCaller.withRetries(upsertCallable);
            this.handleResultAttributes(this, response);
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, operationType, System.currentTimeMillis() - start, this.rows.size());
            this.service.endOperationSuccessfully(this.tableName, retryingCaller);
            return Arrays.asList(response.getResults());
        }
        catch (Throwable t) {
            if (t instanceof TableNotFoundException) {
                this.service.getLConnection().getTableMetaCache().removeTable(this.namespace, this.tableName);
            }
            String msg = this.buildErrorMsg(operationType, t, System.currentTimeMillis() - start, this.getRows() == null ? 0 : this.getRows().size());
            LindormException error = new LindormException(msg);
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, operationType, error);
            this.service.endOperationExceptionally(this.tableName, retryingCaller, t);
            throw error;
        }
    }

    @Override
    public List<Object> executeWithResults(List<List<Object>> params, boolean addBatch) throws LindormException {
        this.resetParamValues(params, addBatch);
        return this.executeWithResults();
    }

    @Override
    public Future<List<Object>> executeWithResultsAsync() throws LindormException {
        final ClientCompletableFuture<List<Object>> future = new ClientCompletableFuture<List<Object>>();
        this.executeWithResultsAsync(new AsyncCallback<List<Object>>(){

            @Override
            public void onComplete(List<Object> result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public Future<List<Object>> executeWithResultsAsync(List<List<Object>> params, boolean addBatch) throws LindormException {
        this.resetParamValues(params, addBatch);
        return this.executeWithResultsAsync();
    }

    @Override
    public void executeWithResultsAsync(AsyncCallback<List<Object>> callback) throws LindormException {
        if (this.isEmpty()) {
            callback.onComplete(Collections.emptyList());
            return;
        }
        this.validate();
        this.setupRouteKey();
        OperationContext.OperationType operationType = this.getOperationType();
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        this.blobColumnObjectUpsert();
        LServerCallable<LMutationResult> upsertCallable = this.buildUpsertCallable(operationType);
        Object context = this.service.startOperationAsync(this.tableName, operationType);
        AsyncUpsertWithResultsHandler asyncUpsertHandler = new AsyncUpsertWithResultsHandler(callback, operationType, System.currentTimeMillis(), context, retryingCaller);
        retryingCaller.withRetriesAsync(upsertCallable, asyncUpsertHandler);
    }

    @Override
    public void executeWithResultsAsync(List<List<Object>> params, AsyncCallback<List<Object>> callback, boolean addBatch) throws LindormException {
        this.resetParamValues(params, addBatch);
        this.executeWithResultsAsync(callback);
    }

    @Override
    public Upsert where(Condition condition) throws LindormException {
        this.where = condition;
        return this;
    }

    @Override
    public Upsert check(Condition condition, ConditionFactory.RowExistenceCondition rowExistenceCondition) throws LindormException {
        if (rowExistenceCondition == null) {
            throw new LindormException("The row existence condition must be specified");
        }
        this.where = condition;
        this.rowExistenceCondition = rowExistenceCondition;
        return this;
    }

    @Override
    public Upsert check(Condition condition) throws LindormException {
        return this.check(condition, ConditionFactory.RowExistenceCondition.IGNORE);
    }

    public ConditionFactory.RowExistenceCondition getRowExistenceCondition() {
        return this.rowExistenceCondition;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setAttributes();
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.rows.size());
        for (Row row : this.rows) {
            row.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int numberOfRows = WritableUtils.readVInt(in);
        this.rows = CollectionUtils.newArrayListWithCapacity(numberOfRows);
        for (int i = 0; i < numberOfRows; ++i) {
            Row r = new Row();
            r.readFrom(in);
            this.rows.add(r);
        }
        this.handleAttributes();
    }

    private void setAttributes() throws IOException {
        if (this.where != null) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteStream);
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
            this.where.writeTo(out);
            this.setAttribute(WHERE_ATTR, byteStream.toByteArray());
        } else {
            this.setAttribute(WHERE_ATTR, (byte[])null);
        }
        if (this.rowExistenceCondition != null) {
            this.setAttribute(ROW_EXISTENCE_ATTR, Bytes.toBytes(this.rowExistenceCondition.ordinal()));
        } else {
            this.removeAttribute(ROW_EXISTENCE_ATTR);
        }
        if (this.deleteWhenValueIsNull) {
            this.setAttribute(DELETE_WHEN_VALUE_IS_NULL, Bytes.toBytes(this.deleteWhenValueIsNull));
        } else {
            this.removeAttribute(DELETE_WHEN_VALUE_IS_NULL);
        }
    }

    @Override
    public Upsert setTTL(long ttl) {
        this.internalSetTTL(ttl);
        return this;
    }

    private void handleAttributes() throws IOException {
        byte[] deleteWhenValueIsNullBytes;
        byte[] rowConditionBytes;
        byte[] whereBytes = this.getAttribute(WHERE_ATTR);
        if (whereBytes != null) {
            DataInputBuffer in = new DataInputBuffer();
            in.reset(whereBytes, 0, whereBytes.length);
            this.where = ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
            this.where.readFrom(in);
        }
        if ((rowConditionBytes = this.getAttribute(ROW_EXISTENCE_ATTR)) != null) {
            this.rowExistenceCondition = ConditionFactory.RowExistenceCondition.values()[Bytes.toInt(rowConditionBytes)];
        }
        if ((deleteWhenValueIsNullBytes = this.getAttribute(DELETE_WHEN_VALUE_IS_NULL)) != null) {
            this.deleteWhenValueIsNull = Bytes.toBoolean(deleteWhenValueIsNullBytes);
        }
    }

    @Override
    public String toString() {
        return this.toStringWithLimitRows(3);
    }

    public String toStringWithLimitRows(int limit) {
        StringBuilder str = new StringBuilder();
        str.append("UPSERT INTO ");
        str.append(this.tableName);
        str.append(" VALUES ");
        int num = 0;
        if (this.rows != null && !this.rows.isEmpty()) {
            str.append(this.rows.size());
            str.append("(");
            for (Row r : this.rows) {
                str.append(r.toString());
                if (++num > limit) break;
                str.append(",");
            }
            str.setLength(str.length() - 1);
            str.append(")");
        }
        return str.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LUpsert)) {
            return false;
        }
        LUpsert other = (LUpsert)obj;
        if (!this.rows.equals(other.rows)) {
            return false;
        }
        if (this.where == null != (other.where == null)) {
            return false;
        }
        return this.where == null || this.where.equals(other.where);
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        byte[] ret = this.computeRowKeyByCondition(meta);
        if (ret != null) {
            return ret;
        }
        return this.computeRowKeyByRows(meta);
    }

    private byte[] computeRowKeyByCondition(TableMeta meta) {
        if (this.where == null) {
            return null;
        }
        try {
            return CompilerUtils.getRowKeyForRouting(meta, this.where);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private byte[] computeRowKeyByRows(TableMeta meta) {
        try {
            Row r = this.rows.get(Threads.getFastRandom(this.rows.size()));
            byte[][] pkBytes = new byte[meta.getPkColumns().size()][];
            for (ColumnValue cv : r.getColumnValues()) {
                LColumn c = meta.resolveColumnNoThrow(cv.getColumnKey());
                if (c == null || !c.isPrimaryKey()) continue;
                pkBytes[c.getPosition()] = LDataType.toBytes(c, cv);
            }
            int rowkeySize = 0;
            for (byte[] keyPart : pkBytes) {
                if (keyPart == null) break;
                rowkeySize += keyPart.length;
            }
            if (rowkeySize == 0) {
                return null;
            }
            byte[] rowkey = new byte[rowkeySize];
            int offset = 0;
            for (byte[] keyPart : pkBytes) {
                if (keyPart == null) break;
                System.arraycopy(keyPart, 0, rowkey, offset, keyPart.length);
                offset += keyPart.length;
            }
            return rowkey;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void validate() throws LindormException {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new LindormException("Table name must not be null or empty.");
        }
    }

    protected boolean isEmpty() {
        return this.rows == null || this.rows.isEmpty();
    }

    public boolean isDeleteWhenValueIsNull() {
        return this.deleteWhenValueIsNull;
    }

    public void setDeleteWhenValueIsNull(boolean deleteWhenValueIsNull) {
        this.deleteWhenValueIsNull = deleteWhenValueIsNull;
    }

    private class AsyncUpsertWithResultsHandler
    extends DmlOperation.AsyncLMutationResultHandler<List<Object>> {
        public AsyncUpsertWithResultsHandler(AsyncCallback<List<Object>> callback, OperationContext.OperationType operationType, long startTime, Object traceContext, RetryingCaller<LMutationResult> caller) {
            super((DmlOperation)LUpsert.this, callback, operationType, startTime, traceContext, caller);
        }

        @Override
        protected List<Object> getReturnValue(LMutationResult result) {
            return Arrays.asList(result.getResults());
        }
    }

    private class AsyncUpsertHandler
    extends DmlOperation.AsyncLMutationResultHandler<Integer> {
        public AsyncUpsertHandler(AsyncCallback<Integer> callback, OperationContext.OperationType operationType, long startTime, int rows, Object traceContext, RetryingCaller<LMutationResult> caller) {
            super((DmlOperation)LUpsert.this, callback, operationType, startTime, rows, traceContext, caller);
        }

        @Override
        protected Integer getReturnValue(LMutationResult result) {
            return result.getNumberOfRowsAffected();
        }

        @Override
        public void onComplete(LMutationResult result) {
            try {
                LUpsert.this.checkResultCompatibility(result.getResults());
            }
            catch (Throwable t) {
                this.onError(t);
                return;
            }
            super.onComplete(result);
        }
    }
}

