/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice.entity;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.tableservice.entity.AlterEntityOperation;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.ActivateEntityOption;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LAlterEntityStateRequest
extends VersionedObjectWithAttributes {
    private String namespace;
    private String tableName;
    private String entityName;
    private AlterEntityOperation operation;
    private ActivateEntityOption activateOption = null;

    public LAlterEntityStateRequest() {
    }

    public LAlterEntityStateRequest(String namespace, String tableName, String entityName, AlterEntityOperation operation) throws IllegalRequestException {
        this.namespace = namespace;
        this.tableName = tableName;
        this.entityName = entityName;
        this.operation = operation;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public AlterEntityOperation getOperation() {
        return this.operation;
    }

    public ActivateEntityOption getActivateOption() {
        return this.activateOption;
    }

    public void setActivateOption(ActivateEntityOption activateOption) {
        this.activateOption = activateOption;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append((Object)this.operation);
        str.append(": table=");
        str.append(this.namespace);
        str.append(".");
        str.append(this.tableName);
        str.append(", entity=");
        str.append(this.entityName);
        if (this.activateOption != null) {
            str.append(", activateOption=");
            str.append((Object)this.activateOption);
        }
        return str.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.tableName);
        WritableUtils.writeString(out, this.entityName);
        WritableUtils.writeString(out, this.operation.name());
        if (this.activateOption != null) {
            WritableUtils.writeString(out, this.activateOption.name());
        } else {
            WritableUtils.writeString(out, null);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.tableName = WritableUtils.readString(in);
        this.entityName = WritableUtils.readString(in);
        this.operation = AlterEntityOperation.valueOf(WritableUtils.readString(in));
        String optionString = WritableUtils.readString(in);
        this.activateOption = optionString == null ? null : ActivateEntityOption.valueOf(optionString);
    }
}

