/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice.index;

import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.FunctionCall;
import com.alibaba.lindorm.client.core.meta.CoveredColumnType;
import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.tableservice.index.LIndexBaseDescriptor;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.IndexUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormSecondaryIndexDescriptor;
import com.alibaba.lindorm.client.schema.PrimaryKeyOption;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LSecondaryIndexDescriptor
extends LIndexBaseDescriptor {
    private static final String INDEX_CONDITION_ATTR = "PARTIAL_INDEX";
    private static final String INDEX_STORE_PK_NULLS_ATTR = "STORE_PK_NULLS_INDEX";
    private static final String INDEX_STORE_PK_TS_ATTR = "STORE_PK_TS_INDEX";
    private static final String INDEX_STORE_FAMILY_IN_QUALIFIER = "STORE_FAMILY_IN_QUALIFIER_INDEX";
    @Deprecated
    private static final String FIRST_INDEXCOLUMN_PK_HASHED = "FIRST_INDEXCOLUMN_PK_HASHED";
    private static final String INDEX_PK_OPTION = "INDEX_PK_OPTION";
    private static final String INDEX_STATE = "INDEX_STATE";
    private static final String SKIP_CHECK_MEANINGLESS_INDEX = "SKIP_CHECK_MEANINGLESS_INDEX";
    private static final String COLUMN_FUNCTIONS_ATTR = "COLUMN_FUNCTIONS";
    protected Expression indexCondition;
    protected boolean storePkNulls;
    protected boolean storePkTS;
    protected boolean storeFamilyNameInQualifier;
    protected boolean skipCheckMeaninglessIndex = false;
    protected List<IndexedColumnSchema> indexedColumns = new ArrayList<IndexedColumnSchema>();
    protected List<ColumnKey> coveredColumns = new ArrayList<ColumnKey>();
    protected FamilyAttributes familyAttributes = new FamilyAttributes();
    protected TableAttributes tableAttributes = new TableAttributes();

    public LSecondaryIndexDescriptor() {
    }

    public LSecondaryIndexDescriptor(String namespace, LindormIndexDescriptor indexDescriptor) {
        this.namespace = namespace;
        this.indexName = indexDescriptor.getIndexName();
        this.dataTableName = indexDescriptor.getDataTableName();
        this.indexedColumns = indexDescriptor.getIndexedColumns();
        this.coveredColumns = indexDescriptor.getCoveredColumns();
        this.familyAttributes = indexDescriptor.getFamilyAttributes();
        this.tableAttributes = indexDescriptor.getTableAttributes();
        this.indexCondition = indexDescriptor.getIndexCondition();
        this.storePkNulls = indexDescriptor.isStorePkNulls();
        this.indexState = indexDescriptor.getIndexState();
        this.storePkTS = indexDescriptor.isStorePkTS();
        this.storeFamilyNameInQualifier = indexDescriptor.isStoreFamilyNameInQualifier();
        this.skipCheckMeaninglessIndex = indexDescriptor.isSkipCheckMeaninglessIndex();
    }

    public List<ColumnKey> getCoveredColumns() {
        return this.coveredColumns;
    }

    public void setCoveredColumns(List<ColumnKey> coveredColumns) {
        this.coveredColumns = coveredColumns;
    }

    public List<IndexedColumnSchema> getIndexedColumns() {
        return this.indexedColumns;
    }

    public void setIndexedColumns(List<IndexedColumnSchema> indexedColumns) {
        this.indexedColumns = indexedColumns;
    }

    public FamilyAttributes getFamilyAttributes() {
        return this.familyAttributes;
    }

    public void setFamilyAttributes(FamilyAttributes familyAttributes) {
        this.familyAttributes = familyAttributes;
    }

    public TableAttributes getTableAttributes() {
        return this.tableAttributes;
    }

    public void setTableAttributes(TableAttributes tableAttributes) {
        this.tableAttributes = tableAttributes;
    }

    private void setupAttributes() throws IOException {
        IndexedColumnSchema firstIndexedColumnSchema;
        if (this.indexCondition != null) {
            this.setAttribute(INDEX_CONDITION_ATTR, SchemaUtils.conditionToBytes(this.indexCondition));
        }
        if (this.storePkNulls) {
            this.setAttribute(INDEX_STORE_PK_NULLS_ATTR, Bytes.toBytes(this.storePkNulls));
        }
        if (this.storePkTS) {
            this.setAttribute(INDEX_STORE_PK_TS_ATTR, Bytes.toBytes(this.storePkTS));
        }
        if (this.storeFamilyNameInQualifier) {
            this.setAttribute(INDEX_STORE_FAMILY_IN_QUALIFIER, Bytes.toBytes(this.storeFamilyNameInQualifier));
        }
        if ((firstIndexedColumnSchema = this.indexedColumns.get(0)).isHashed()) {
            this.setAttribute(FIRST_INDEXCOLUMN_PK_HASHED, Bytes.toBytes(firstIndexedColumnSchema.isHashed()));
        }
        HashMap<Integer, Integer> pk_options = null;
        HashMap<Integer, FunctionCall> pk_functions = null;
        boolean hasPkOption = false;
        for (int i = 0; i < this.indexedColumns.size(); ++i) {
            IndexedColumnSchema ic = this.indexedColumns.get(i);
            if (ic.getPkOption() != null) {
                hasPkOption = true;
                if (pk_options == null) {
                    pk_options = new HashMap<Integer, Integer>();
                }
                pk_options.put(i, ic.getPkOption().getId());
            }
            if (ic.getColumnFunction() == null) continue;
            if (pk_functions == null) {
                pk_functions = new HashMap<Integer, FunctionCall>();
            }
            pk_functions.put(i, ic.getColumnFunction());
        }
        if (hasPkOption) {
            this.setAttribute(INDEX_PK_OPTION, this.pkOptionAsBytesForMap(pk_options));
        } else {
            this.removeAttribute(INDEX_PK_OPTION);
        }
        if (null != pk_functions) {
            this.setAttribute(COLUMN_FUNCTIONS_ATTR, this.pkFunctionsAsBytesForMap(pk_functions));
        } else {
            this.removeAttribute(COLUMN_FUNCTIONS_ATTR);
        }
        if (null != this.indexState) {
            this.setAttribute(INDEX_STATE, Bytes.toBytes(this.indexState.ordinal()));
        }
        if (this.skipCheckMeaninglessIndex) {
            this.setAttribute(SKIP_CHECK_MEANINGLESS_INDEX, Bytes.toBytes(this.skipCheckMeaninglessIndex));
        }
    }

    private void initFromAttributes() throws IOException {
        byte[] skipCheckIndexBytes;
        byte[] indexStateBytes;
        byte[] storeFamilyInQualifierBytes;
        byte[] storePkTSBytes;
        byte[] storePkNullsBytes;
        byte[] whereBytes = this.getAttribute(INDEX_CONDITION_ATTR);
        if (whereBytes != null) {
            this.indexCondition = SchemaUtils.bytesToCondition(whereBytes);
        }
        if ((storePkNullsBytes = this.getAttribute(INDEX_STORE_PK_NULLS_ATTR)) != null) {
            this.storePkNulls = Bytes.toBoolean(storePkNullsBytes);
        }
        if ((storePkTSBytes = this.getAttribute(INDEX_STORE_PK_TS_ATTR)) != null) {
            this.storePkTS = Bytes.toBoolean(storePkTSBytes);
        }
        if ((storeFamilyInQualifierBytes = this.getAttribute(INDEX_STORE_FAMILY_IN_QUALIFIER)) != null) {
            this.storeFamilyNameInQualifier = Bytes.toBoolean(storeFamilyInQualifierBytes);
        }
        if (null != (indexStateBytes = this.getAttribute(INDEX_STATE))) {
            this.indexState = IndexState.values()[Bytes.toInt(indexStateBytes)];
        }
        if ((skipCheckIndexBytes = this.getAttribute(SKIP_CHECK_MEANINGLESS_INDEX)) != null) {
            this.skipCheckMeaninglessIndex = Bytes.toBoolean(skipCheckIndexBytes);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.indexName);
        WritableUtils.writeString(out, this.dataTableName);
        CoveredColumnType coveredColumnType = IndexUtils.resolveIndexCoveredColumnType(this.coveredColumns);
        WritableUtils.writeVInt(out, coveredColumnType.ordinal());
        if (!IndexUtils.isFullCover(coveredColumnType)) {
            WritableUtils.writeVInt(out, this.coveredColumns.size());
            for (ColumnKey columnKey : this.coveredColumns) {
                columnKey.writeTo(out);
            }
        }
        WritableUtils.writeVInt(out, this.indexedColumns.size());
        for (IndexedColumnSchema ic : this.indexedColumns) {
            ic.getColumnKey().writeTo(out);
            WritableUtils.writeVInt(out, ic.getSortOrder().ordinal());
        }
        this.familyAttributes.writeTo(out);
        this.tableAttributes.writeTo(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        byte[] columnFunctionBytes;
        ColumnKey columnKey;
        int i;
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.indexName = WritableUtils.readString(in);
        this.dataTableName = WritableUtils.readString(in);
        this.coveredColumns = CollectionUtils.newArrayList();
        CoveredColumnType coveredColumnType = CoveredColumnType.values()[WritableUtils.readVInt(in)];
        if (coveredColumnType == CoveredColumnType.DYNAMIC) {
            this.coveredColumns.add(LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS);
        } else if (coveredColumnType == CoveredColumnType.ALL) {
            this.coveredColumns.add(LindormIndexDescriptor.COVERED_ALL_COLUMNS_IN_SCHEMA);
        } else {
            int numOfCoveredColumns = WritableUtils.readVInt(in);
            for (i = 0; i < numOfCoveredColumns; ++i) {
                columnKey = new ColumnKey();
                columnKey.readFrom(in);
                this.coveredColumns.add(columnKey);
            }
        }
        int numOfIndexedColumns = WritableUtils.readVInt(in);
        this.indexedColumns = CollectionUtils.newArrayListWithCapacity(numOfIndexedColumns);
        for (i = 0; i < numOfIndexedColumns; ++i) {
            columnKey = new ColumnKey();
            columnKey.readFrom(in);
            SortOrder sortOrder = SortOrder.values()[WritableUtils.readVInt(in)];
            this.indexedColumns.add(new IndexedColumnSchema(columnKey, sortOrder));
        }
        byte[] optionBytes = this.getAttribute(INDEX_PK_OPTION);
        if (optionBytes != null) {
            this.pkOptionFromBytesForMap(this.indexedColumns, optionBytes);
        }
        if ((columnFunctionBytes = this.getAttribute(COLUMN_FUNCTIONS_ATTR)) != null) {
            this.pkFunctionsFromBytesForMap(this.indexedColumns, columnFunctionBytes);
        }
        this.familyAttributes.readFrom(in);
        this.tableAttributes.readFrom(in);
        this.initFromAttributes();
        byte[] hashedPk = this.getAttribute(FIRST_INDEXCOLUMN_PK_HASHED);
        if (hashedPk != null) {
            this.indexedColumns.get(0).setHashed(Bytes.toBoolean(hashedPk));
        }
    }

    private byte[] pkOptionAsBytesForMap(Map<Integer, Integer> pkOptions) {
        byte[] optionBytes = null;
        for (Map.Entry<Integer, Integer> col : pkOptions.entrySet()) {
            if (optionBytes == null) {
                optionBytes = new byte[]{};
            }
            optionBytes = Bytes.add(optionBytes, Bytes.toBytes(col.getKey()));
            optionBytes = Bytes.add(optionBytes, Bytes.toBytes(col.getValue()));
        }
        return optionBytes;
    }

    private void pkOptionFromBytesForMap(List<IndexedColumnSchema> cols, byte[] bytes) {
        assert (bytes != null);
        for (int offset = 0; offset < bytes.length; offset += 4) {
            int col = Bytes.toInt(bytes, offset);
            int optionId = Bytes.toInt(bytes, offset += 4);
            cols.get(col).setPkOption(PrimaryKeyOption.fromId(optionId));
        }
    }

    private byte[] pkFunctionsAsBytesForMap(Map<Integer, FunctionCall> pkFunctions) {
        byte[] funcMapBytes = null;
        for (Map.Entry<Integer, FunctionCall> col : pkFunctions.entrySet()) {
            if (funcMapBytes == null) {
                funcMapBytes = new byte[]{};
            }
            funcMapBytes = Bytes.add(funcMapBytes, Bytes.toBytes(col.getKey()));
            byte[] funcBytes = col.getValue().getBytes();
            funcMapBytes = Bytes.add(funcMapBytes, Bytes.toBytes(funcBytes.length));
            funcMapBytes = Bytes.add(funcMapBytes, funcBytes);
        }
        return funcMapBytes;
    }

    private void pkFunctionsFromBytesForMap(List<IndexedColumnSchema> cols, byte[] bytes) {
        int funcLength;
        assert (bytes != null);
        for (int offset = 0; offset < bytes.length; offset += funcLength) {
            int colPos = Bytes.toInt(bytes, offset);
            funcLength = Bytes.toInt(bytes, offset += 4);
            FunctionCall call = new FunctionCall();
            call.fromBytes(bytes, offset += 4, funcLength);
            cols.get(colPos).setColumnFunction(call);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Index [").append(this.namespace).append(".").append(this.dataTableName).append(".").append(this.indexName).append("]");
        if (!this.indexedColumns.isEmpty()) {
            stringBuilder.append(", indexed columns:");
            for (IndexedColumnSchema ics : this.indexedColumns) {
                if (ics.getPkOption() != null) {
                    stringBuilder.append(ics + " ").append(ics.getPkOption().toString()).append(",");
                    continue;
                }
                stringBuilder.append(ics).append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append(", storePkNulls:" + this.storePkNulls);
        stringBuilder.append(", storePkTS:" + this.storePkTS);
        stringBuilder.append(", storeFamilyInQualifier:" + this.storeFamilyNameInQualifier);
        stringBuilder.append(", skipCheckMeaninglessIndex:" + this.skipCheckMeaninglessIndex);
        if (null != this.indexState) {
            stringBuilder.append(", index state:" + (Object)((Object)this.indexState));
        }
        if (!this.coveredColumns.isEmpty()) {
            stringBuilder.append(", covered columns:");
            for (ColumnKey columnKey : this.coveredColumns) {
                stringBuilder.append(columnKey.toString()).append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append(", family attribute:").append(SchemaUtils.tableMetaAttributesToString(this.familyAttributes));
        stringBuilder.append(", table attribute:").append(SchemaUtils.tableMetaAttributesToString(this.tableAttributes));
        return stringBuilder.toString();
    }

    public LindormSecondaryIndexDescriptor toLindormSecondaryIndexDescriptor() {
        LindormSecondaryIndexDescriptor lsid = new LindormSecondaryIndexDescriptor(this.getIndexName(), this.getDataTableName());
        lsid.setIndexState(this.getIndexState());
        lsid.setIndexedColumns(new ArrayList<IndexedColumnSchema>(this.getIndexedColumns()));
        lsid.setCoveredColumns(new ArrayList<ColumnKey>(this.getCoveredColumns()));
        lsid.setStorePkNulls(this.storePkNulls);
        lsid.setStorePkTS(this.storePkTS);
        lsid.setStoreFamilyNameInQualifier(this.storeFamilyNameInQualifier);
        lsid.setSkipCheckMeaninglessIndex(this.skipCheckMeaninglessIndex);
        return lsid;
    }
}

