/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LBoolean;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class HBoolean
extends LDataType<Boolean> {
    public static final HBoolean INSTANCE = new HBoolean();

    private HBoolean() {
        super(DataType.HBOOLEAN, Boolean.class);
    }

    @Override
    public int getByteSize() {
        return 1;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LBoolean.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot encode value with descending order to HBoolean, value = " + value);
        }
        return (Boolean)value != false ? Bytes.toBytes(true) : Bytes.toBytes(false);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null || actualType == this || actualType == LBoolean.INSTANCE) {
            return value;
        }
        if (actualType == LVarbinary.INSTANCE) {
            return this.toObject((byte[])value);
        }
        if (actualType == LString.INSTANCE) {
            String v = (String)value;
            if (v.equalsIgnoreCase("true")) {
                return true;
            }
            if (v.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalDataException("String value '" + v + "' cannot be converted to boolean type.");
        }
        throw new IllegalDataException(actualType.clientType, value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        if (value == null || length == 0) {
            return null;
        }
        if (length > 1) {
            throw new IllegalDataException("Boolean type must contain only one byte, actual=" + Bytes.toStringBinary(value));
        }
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot encode value with descending order to HBoolean, value bytes = " + Bytes.toStringBinary(value));
        }
        return value[offset] == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public byte[] getNullValue() {
        return Bytes.toBytes(Boolean.FALSE);
    }

    @Override
    public Boolean randomData(DataGenerator dataGenerator) {
        return dataGenerator.getRandom().nextBoolean();
    }
}

