/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.HFloat;
import com.alibaba.lindorm.client.core.types.HInteger;
import com.alibaba.lindorm.client.core.types.HLong;
import com.alibaba.lindorm.client.core.types.HShort;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LDecimalV2;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;

public class HDouble
extends LRealNumberType<Double> {
    public static final HDouble INSTANCE = new HDouble();

    protected HDouble() {
        super(DataType.HDOUBLE, Double.class);
    }

    @Override
    public int getByteSize() {
        return 8;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType instanceof LRealNumberType && DataTypeUtils.equalsAny(targetType, LDouble.INSTANCE, INSTANCE);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        double v = ((Number)value).doubleValue();
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HDOUBLE, value = " + v);
        }
        return Bytes.toBytes(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        double ret;
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LDouble.INSTANCE)) {
            return value;
        }
        if (DataTypeUtils.equalsAny(actualType, HFloat.INSTANCE)) {
            ret = ((Float)value).floatValue();
            return ret;
        } else if (DataTypeUtils.equalsAny(actualType, LString.INSTANCE)) {
            try {
                ret = Double.parseDouble((String)value);
                return ret;
            }
            catch (NumberFormatException e) {
                throw new IllegalDataException("Cannot convert string value '" + value + "' to double value.", e);
            }
        } else if (actualType == LDecimal.INSTANCE || actualType == LDecimalV2.INSTANCE) {
            BigDecimal bd = (BigDecimal)value;
            if (bd.compareTo(DataTypeUtils.MAX_DOUBLE_AS_DECIMAL) > 0 || bd.compareTo(DataTypeUtils.MIN_DOUBLE_AS_DECIMAL) < 0) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = bd.doubleValue();
            return ret;
        } else if (DataTypeUtils.equalsAny(actualType, HLong.INSTANCE)) {
            ret = ((Long)value).longValue();
            return ret;
        } else if (DataTypeUtils.equalsAny(actualType, HInteger.INSTANCE)) {
            ret = ((Integer)value).intValue();
            return ret;
        } else {
            if (!DataTypeUtils.equalsAny(actualType, HShort.INSTANCE)) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = ((Short)value).shortValue();
        }
        return ret;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HDouble, value bytes = " + Bytes.toStringBinary(value));
        }
        return Bytes.toDouble(value, offset);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_DOUBLE_ARRAY;
    }

    @Override
    public Double randomData(DataGenerator dataGenerator) {
        return dataGenerator.getRandom().nextDouble();
    }
}

