/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.HDouble;
import com.alibaba.lindorm.client.core.types.HInteger;
import com.alibaba.lindorm.client.core.types.HLong;
import com.alibaba.lindorm.client.core.types.HShort;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LDecimalV2;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LFloat;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;

public class HFloat
extends LRealNumberType<Float> {
    public static final HFloat INSTANCE = new HFloat();

    protected HFloat() {
        super(DataType.HFLOAT, Float.class);
    }

    @Override
    public int getByteSize() {
        return 4;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType instanceof LRealNumberType && DataTypeUtils.equalsAny(targetType, LFloat.INSTANCE, LDouble.INSTANCE, INSTANCE, HDouble.INSTANCE);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        float v = ((Number)value).floatValue();
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HFLOAT, value = " + v);
        }
        return Bytes.toBytes(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        float ret;
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LFloat.INSTANCE)) {
            return value;
        }
        if (DataTypeUtils.equalsAny(actualType, HDouble.INSTANCE)) {
            Double v = (Double)value;
            if (!Double.isNaN(v) && v != Double.POSITIVE_INFINITY && v != Double.NEGATIVE_INFINITY && (!(v >= -3.4028234663852886E38) || !(v <= 3.4028234663852886E38))) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = v.floatValue();
            return Float.valueOf(ret);
        } else if (DataTypeUtils.equalsAny(actualType, LString.INSTANCE)) {
            try {
                ret = Float.parseFloat((String)value);
                return Float.valueOf(ret);
            }
            catch (NumberFormatException e) {
                throw new IllegalDataException("Cannot convert string value '" + value + "' to float value.", e);
            }
        } else if (actualType == LDecimal.INSTANCE || actualType == LDecimalV2.INSTANCE) {
            BigDecimal bd = (BigDecimal)value;
            if (bd.compareTo(DataTypeUtils.MAX_FLOAT_AS_DECIMAL) > 0 || bd.compareTo(DataTypeUtils.MIN_FLOAT_AS_DECIMAL) < 0) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = bd.floatValue();
            return Float.valueOf(ret);
        } else if (DataTypeUtils.equalsAny(actualType, HLong.INSTANCE)) {
            ret = ((Long)value).longValue();
            return Float.valueOf(ret);
        } else if (DataTypeUtils.equalsAny(actualType, HInteger.INSTANCE)) {
            ret = ((Integer)value).intValue();
            return Float.valueOf(ret);
        } else {
            if (!DataTypeUtils.equalsAny(actualType, HShort.INSTANCE)) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = ((Short)value).shortValue();
        }
        return Float.valueOf(ret);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HFLOAT, value bytes = " + Bytes.toStringBinary(value));
        }
        return Float.valueOf(Bytes.toFloat(value, offset));
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_FLOAT_ARRAY;
    }

    @Override
    public Float randomData(DataGenerator dataGenerator) {
        return Float.valueOf(dataGenerator.getRandom().nextFloat());
    }
}

