/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.HLong;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class HInteger
extends LWholeNumberType<Integer> {
    public static final HInteger INSTANCE = new HInteger();

    protected HInteger() {
        super(DataType.HINT, Integer.class);
    }

    @Override
    public int getByteSize() {
        return 4;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        if (targetType instanceof LWholeNumberType && DataTypeUtils.equalsAny(targetType, LInteger.INSTANCE, LLong.INSTANCE, INSTANCE, HLong.INSTANCE)) {
            return true;
        }
        return targetType instanceof LRealNumberType;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        int v = ((Number)value).intValue();
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HINT, value = " + v);
        }
        return Bytes.toBytes(v);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        long v = 0L;
        try {
            v = (Long)HLong.INSTANCE.toObject(value, actualType);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
            return (int)v;
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HINT, value bytes = " + Bytes.toStringBinary(value));
        }
        return Bytes.toInt(value, offset, length);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_INT_ARRAY;
    }

    @Override
    public Integer randomData(DataGenerator dataGenerator) {
        return LInteger.INSTANCE.randomData(dataGenerator);
    }
}

