/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.HDouble;
import com.alibaba.lindorm.client.core.types.HFloat;
import com.alibaba.lindorm.client.core.types.HInteger;
import com.alibaba.lindorm.client.core.types.HShort;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class HLong
extends LWholeNumberType<Long> {
    public static final HLong INSTANCE = new HLong();

    protected HLong() {
        super(DataType.HLONG, Long.class);
    }

    @Override
    public int getByteSize() {
        return 8;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        if (targetType instanceof LWholeNumberType && DataTypeUtils.equalsAny(targetType, LLong.INSTANCE, INSTANCE)) {
            return true;
        }
        return targetType instanceof LRealNumberType;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        long v = ((Number)value).longValue();
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HLONG, value = " + v);
        }
        return Bytes.toBytes(v);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        long ret;
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LLong.INSTANCE)) {
            return value;
        }
        if (DataTypeUtils.equalsAny(actualType, HInteger.INSTANCE, LInteger.INSTANCE)) {
            ret = ((Integer)value).intValue();
        } else if (DataTypeUtils.equalsAny(actualType, LString.INSTANCE)) {
            try {
                ret = Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalDataException("Cannot convert string value '" + value + "' to long value.", e);
            }
        } else if (DataTypeUtils.equalsAny(actualType, HShort.INSTANCE, LShort.INSTANCE)) {
            ret = ((Short)value).shortValue();
        } else if (DataTypeUtils.equalsAny(actualType, HDouble.INSTANCE)) {
            Double v = (Double)value;
            if (v < -9.223372036854776E18 || v > 9.223372036854776E18) {
                throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            }
            ret = v.longValue();
        } else if (DataTypeUtils.equalsAny(actualType, HFloat.INSTANCE)) {
            Float v = (Float)value;
            if (v.floatValue() < -9.223372E18f || v.floatValue() > 9.223372E18f) {
                throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            }
            ret = v.longValue();
        } else {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        return ret;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HLONG, value bytes = " + Bytes.toStringBinary(value));
        }
        return Bytes.toLong(value, offset, length);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_LONG_ARRAY;
    }

    @Override
    public Long randomData(DataGenerator dataGenerator) {
        return dataGenerator.getRandom().nextInt(Integer.MAX_VALUE);
    }
}

