/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.HInteger;
import com.alibaba.lindorm.client.core.types.HLong;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class HShort
extends LWholeNumberType<Short> {
    public static final HShort INSTANCE = new HShort();

    private HShort() {
        super(DataType.HSHORT, Short.class);
    }

    @Override
    public int getByteSize() {
        return 2;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        if (targetType instanceof LWholeNumberType && DataTypeUtils.equalsAny(targetType, LShort.INSTANCE, LInteger.INSTANCE, LLong.INSTANCE, INSTANCE, HInteger.INSTANCE, HLong.INSTANCE)) {
            return true;
        }
        return targetType instanceof LRealNumberType;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        short v = ((Number)value).shortValue();
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot encode value with descending order to HSHORT, value = " + v);
        }
        return Bytes.toBytes(v);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        long v;
        if (value == null) {
            return null;
        }
        try {
            v = (Long)HLong.INSTANCE.toObject(value, actualType);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        if (v >= -32768L && v <= 32767L) {
            return (short)v;
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        if (sortOrder == SortOrder.DESC) {
            throw new IllegalDataException("Cannot decode value with descending order to HSHORT, value bytes = " + Bytes.toStringBinary(value));
        }
        return Bytes.toShort(value, offset, length);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_SHORT_ARRAY;
    }

    @Override
    public Short randomData(DataGenerator dataGenerator) {
        return (short)dataGenerator.getRandom().nextInt(Integer.MAX_VALUE);
    }
}

