/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LBlob;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LBoolean
extends LDataType<Boolean> {
    public static LBoolean INSTANCE = new LBoolean();

    public LBoolean() {
        super(DataType.BOOLEAN, Boolean.class);
    }

    @Override
    public int getByteSize() {
        return 1;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        return (Boolean)value ^ sortOrder == SortOrder.ASC ? DataTypeUtils.FALSE_BYTES : DataTypeUtils.TRUE_BYTES;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null || actualType == this) {
            return value;
        }
        if (actualType == LVarbinary.INSTANCE || actualType == LBlob.INSTANCE) {
            return this.toObject((byte[])value);
        }
        if (actualType == LString.INSTANCE) {
            String v = (String)value;
            if (v.equalsIgnoreCase("true")) {
                return true;
            }
            if (v.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalDataException("String value '" + v + "' cannot be converted to boolean type.");
        }
        throw new IllegalDataException(actualType.clientType, value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        if (value == null || length == 0) {
            return null;
        }
        if (length > 1) {
            throw new IllegalDataException("Boolean type must contain only one byte, actual=" + Bytes.toStringBinary(value));
        }
        return value[offset] == 0 ^ sortOrder == SortOrder.DESC ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.FALSE_BYTES;
    }

    @Override
    public Boolean randomData(DataGenerator dataGenerator) {
        return dataGenerator.getRandom().nextBoolean();
    }
}

