/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.util.ArrayList;
import java.util.Collection;

public abstract class LCollectionType<T>
extends LDataType<T> {
    LCollectionType(DataType clientType, Class clazz) {
        super(clientType, clazz);
    }

    public abstract byte[] asBytes();

    public abstract CollectionDataType getCollectionDataType();

    protected byte[] toTransferBytes(Collection data, LDataType lDataType) throws IllegalDataException {
        byte[] typeBytes = this.asBytes();
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int length = 1 + typeBytes.length + 4 + 4 * data.size();
        for (Object k : data) {
            byte[] bytes;
            if (k == null) {
                bytes = null;
            } else {
                bytes = lDataType.toTransferBytes(k);
                length += bytes.length;
            }
            list.add(bytes);
        }
        byte[] result = new byte[length];
        int offset = 0;
        result[offset++] = (byte)typeBytes.length;
        offset = Bytes.putBytes(result, offset, typeBytes, 0, typeBytes.length);
        offset = Bytes.putInt(result, offset, data.size());
        for (byte[] item : list) {
            int byteLength = item == null ? 0 : item.length;
            offset = Bytes.putInt(result, offset, byteLength);
            if (byteLength == 0) continue;
            offset = Bytes.putBytes(result, offset, item, 0, item.length);
        }
        return result;
    }

    protected void fromTransferBytes(byte[] bytes, int offset, int length, LDataType lDataType, Collection result) throws IllegalDataException {
        byte typeBytesLength = bytes[offset++];
        LDataType typeFromBytes = LDataType.fromBytes(bytes, offset, typeBytesLength);
        assert (this.equals(typeFromBytes));
        int size = Bytes.toInt(bytes, offset += typeBytesLength, 4);
        offset += 4;
        for (int i = 0; i < size; ++i) {
            int itemLength = Bytes.toInt(bytes, offset, 4);
            offset += 4;
            if (itemLength != 0) {
                result.add(lDataType.fromTransferBytes(bytes, offset, itemLength));
            } else {
                result.add(null);
            }
            offset += itemLength;
        }
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("no impl");
    }

    @Override
    public boolean isFixedWidth() {
        throw new UnsupportedOperationException("no impl");
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        throw new UnsupportedOperationException("no impl");
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        throw new UnsupportedOperationException("no impl");
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        throw new UnsupportedOperationException("no impl");
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        throw new UnsupportedOperationException("no impl");
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        throw new UnsupportedOperationException("no impl");
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        throw new UnsupportedOperationException("no impl");
    }

    public abstract LDataType getValueType();

    public abstract LDataType getKeyType();
}

