/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LList;
import com.alibaba.lindorm.client.core.types.LMap;
import com.alibaba.lindorm.client.core.types.LSet;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.KeyHashFunction;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.exception.DataExceedsCapacityException;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.PrimaryKeyOption;
import com.alibaba.lindorm.client.schema.SortOrder;
import com.alibaba.lindorm.thirdparty.com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import java.math.BigDecimal;
import java.util.Comparator;

public abstract class LDataType<T> {
    protected final DataType clientType;
    protected final String name;
    protected final Class clazz;
    protected int ordinal;
    public static Comparator<Comparable> COMPARABLE = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };

    LDataType(DataType clientType, Class clazz) {
        this.clientType = clientType;
        this.name = clientType.toString();
        this.ordinal = clientType.ordinal();
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public DataType getClientType() {
        return this.clientType;
    }

    public Class getJavaClass() {
        return this.clazz;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public static byte[] toBytes(LColumn meta, ColumnValue data) throws IllegalDataException {
        Preconditions.checkNotNull(data);
        LDataType actualType = LDataTypeFactory.INSTANCE.getTypeInstance(data.getType());
        return LDataType.toBytes(meta, data.getValueObject(), actualType);
    }

    public static byte[] toBytes(LColumn meta, Object value, LDataType actualType) throws IllegalDataException {
        return LDataType.toBytes(meta, value, actualType, true);
    }

    public static byte[] toBytes(LColumn meta, Object value, LDataType actualType, boolean padSuffix) throws IllegalDataException {
        LDataType.columnValueValidation(meta, value);
        if (meta.isPrimaryKey()) {
            if (value == null) {
                if (SchemaUtils.storePkNulls(meta)) {
                    byte[] ret = LDataType.getDefaultNullValue(meta, actualType);
                    ret = LDataType.addHashKeyIfNecessary(meta, ret);
                    return ret;
                }
                throw new IllegalDataException("Cannot parse null value for key " + meta.toString() + ", primary key of data table or index column of index table can't be null." + " Index column value can be null by specified parameter: storePkNulls=true");
            }
            try {
                LDataType metaType = meta.getDataType();
                value = DataTypeUtils.roundForDecimalIfNecessary(value, actualType, meta);
                byte[] ret = metaType.toBytes(value, actualType, meta.getSortOrder());
                LDataType.inPlaceReverseIfNecessary(meta, ret, 0, ret.length);
                ret = LDataType.addSuffixIfNecessary(meta, ret, padSuffix);
                if (SchemaUtils.storePkNulls(meta)) {
                    ret = Bytes.add(SchemaUtils.getValuePrefixBytes(meta.getSortOrder()), ret);
                }
                ret = LDataType.addHashKeyIfNecessary(meta, ret);
                return ret;
            }
            catch (IllegalDataException e) {
                throw new IllegalDataException("Failed processing column value for " + meta.toString(), e);
            }
        }
        if (value == null) {
            return null;
        }
        try {
            LDataType metaType = meta.getDataType();
            if (metaType == actualType && metaType == LString.INSTANCE && ((String)value).isEmpty()) {
                return SchemaUtils.SEPARATOR_BYTES;
            }
            value = DataTypeUtils.roundForDecimalIfNecessary(value, actualType, meta);
            byte[] ret = metaType.toBytes(value, actualType, meta.getSortOrder());
            return LDataType.doPaddingIfNecessary(meta, ret);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException("Failed processing column value for " + meta.toString(), e);
        }
    }

    public static void inPlaceReverseIfNecessary(LColumn meta, byte[] value, int offset, int length) {
        if (meta.getPkOption() == PrimaryKeyOption.REVERSED) {
            DataTypeUtils.inPlaceByteReverse(value, offset, length);
        }
    }

    public static byte[] reverseIfNecessary(LColumn meta, byte[] value, int offset, int length) {
        byte[] copyValue = Bytes.copy(value);
        if (meta.getPkOption() == PrimaryKeyOption.REVERSED) {
            DataTypeUtils.inPlaceByteReverse(copyValue, offset, length);
        }
        return copyValue;
    }

    private static byte[] addHashKeyIfNecessary(LColumn meta, byte[] value) {
        if (meta.getPkOption() == PrimaryKeyOption.HASHED) {
            return Bytes.add(KeyHashFunction.computeHashKeyFromRow(value, 0, value.length), value);
        }
        return value;
    }

    private static byte[] addSuffixIfNecessary(LColumn meta, byte[] ret) throws IllegalDataException {
        return LDataType.addSuffixIfNecessary(meta, ret, true);
    }

    private static byte[] addSuffixIfNecessary(LColumn meta, byte[] ret, boolean padSuffix) throws IllegalDataException {
        LDataType metaType = meta.getDataType();
        ret = LDataType.doPaddingIfNecessary(meta, ret);
        if (padSuffix && SchemaUtils.hasSeparatorByte(metaType)) {
            ret = Bytes.add(ret, SchemaUtils.getSeparatorBytes(meta.getSortOrder()));
        }
        return ret;
    }

    private static byte[] doPaddingIfNecessary(LColumn meta, byte[] value) throws DataExceedsCapacityException {
        Integer maxLength = meta.getMaxLength();
        if (DataTypeUtils.needPadding(meta.getDataType().getClientType())) {
            if (maxLength < value.length) {
                throw new DataExceedsCapacityException(meta.getDataType().getClientType(), maxLength, value.length);
            }
            return meta.getDataType().pad(value, maxLength, meta.getSortOrder());
        }
        return value;
    }

    private static byte[] getDefaultNullValue(LColumn meta, LDataType actualType) throws IllegalDataException {
        byte[] defaultValue = null;
        if (actualType.getClientType() == DataType.DECIMAL && meta.getDataType().getClientType() == DataType.DECIMAL) {
            BigDecimal bd = DataTypeUtils.setDecimalWidthAndScale(LDecimal.DEFAULT_NULL_VALUE, meta.getPrecision(), meta.getScale());
            defaultValue = LDecimal.INSTANCE.toBytes(bd);
        } else {
            defaultValue = meta.getDataType().getNullValue();
        }
        defaultValue = LDataType.addSuffixIfNecessary(meta, defaultValue);
        defaultValue = Bytes.add(SchemaUtils.getNullValuePrefixBytes(meta.getSortOrder()), defaultValue);
        return defaultValue;
    }

    private static void columnValueValidation(LColumn dataColumnMeta, Object value) throws IllegalDataException {
        if (dataColumnMeta.getDataType().getClientType() == DataType.JSON && dataColumnMeta.getColumnFunction() == null && value != null) {
            try {
                String json = (String)value;
                JacksonJsonProvider jacksonJsonProvider = new JacksonJsonProvider();
                jacksonJsonProvider.getObjectMapper().readTree(json);
            }
            catch (Exception e) {
                throw new IllegalDataException("Insert value is not json value format for column [" + dataColumnMeta.getColumnKey() + "]. ", e);
            }
        }
    }

    public static Object toObject(LColumn meta, byte[] value) throws IllegalDataException {
        int length = value == null ? 0 : value.length;
        return LDataType.toObject(meta, value, 0, length);
    }

    public static Object toObject(LColumn meta, byte[] value, int offset, int length) throws IllegalDataException {
        LDataType metaType = meta.getDataType();
        if (meta.isPrimaryKey()) {
            int actualLength;
            if (meta.getPkOption() == PrimaryKeyOption.HASHED) {
                offset += 8;
                length -= 8;
            }
            if (SchemaUtils.storePkNulls(meta)) {
                byte prefix = value[offset];
                boolean isNullValue = SchemaUtils.isNullValueByte(prefix, meta.getSortOrder());
                if (isNullValue) {
                    return null;
                }
                ++offset;
                --length;
            }
            int n = actualLength = SchemaUtils.hasSeparatorByte(meta.getDataType()) ? length - 1 : length;
            if (actualLength < 0) {
                actualLength = 0;
            }
            value = LDataType.reverseIfNecessary(meta, value, offset, actualLength);
            return metaType.toObject(value, offset, actualLength, meta.getSortOrder());
        }
        if (length == 0) {
            return null;
        }
        if (metaType == LString.INSTANCE && LString.isEmptyString(value, offset, length)) {
            return "";
        }
        return metaType.toObject(value, offset, length, SortOrder.getDefault());
    }

    public abstract int getByteSize();

    public Comparator getComparator() {
        return COMPARABLE;
    }

    public void validate(Object data) throws IllegalDataException {
        if (data == null) {
            return;
        }
        if (!this.clazz.isAssignableFrom(data.getClass())) {
            throw new IllegalDataException("expect type: " + this.clazz + ", data type: " + data.getClass());
        }
    }

    public int getByteSize(Object o) {
        if (this.isFixedWidth()) {
            return this.getByteSize();
        }
        throw new UnsupportedOperationException();
    }

    public abstract boolean isFixedWidth();

    public abstract boolean isCastableTo(LDataType var1);

    public abstract byte[] toBytes(Object var1) throws IllegalDataException;

    public byte[] toTransferBytes(Object data) throws IllegalDataException {
        return this.toBytes(data);
    }

    public abstract byte[] toBytes(Object var1, SortOrder var2) throws IllegalDataException;

    public byte[] toBytes(Object value, LDataType actualType, SortOrder sortOrder) throws IllegalDataException {
        Object v = this.toObject(value, actualType);
        return this.toBytes(v, sortOrder);
    }

    public abstract Object toObject(Object var1, LDataType var2) throws IllegalDataException;

    public abstract Object toObject(byte[] var1) throws IllegalDataException;

    public Object fromTransferBytes(byte[] bytes) throws IllegalDataException {
        return this.fromTransferBytes(bytes, 0, bytes.length);
    }

    public abstract Object toObject(byte[] var1, int var2, int var3, SortOrder var4) throws IllegalDataException;

    public Object fromTransferBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        return this.toObject(bytes, offset, length, SortOrder.getDefault());
    }

    public Interval getKeyInterval(byte[] lower, boolean lowerInclusive, byte[] upper, boolean upperInclusive) {
        if (lower != Interval.UNBOUND && !lowerInclusive && this.isFixedWidth()) {
            lower = CompilerUtils.nextKey(lower);
            lowerInclusive = true;
        }
        return Interval.create(lower, lowerInclusive, upper, upperInclusive);
    }

    public byte[] pad(byte[] value, int maxLength, SortOrder sortOrder) {
        throw new UnsupportedOperationException();
    }

    public byte[] getNullValue() throws IllegalDataException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClientType().toString();
    }

    public static byte[] asBytes(LDataType lDataType) {
        byte[] bytes = lDataType.getClientType().isCollection() ? ((LCollectionType)lDataType).asBytes() : new byte[]{(byte)lDataType.ordinal};
        return bytes;
    }

    public static LDataType fromBytes(byte[] bytes) throws IllegalDataException {
        return LDataType.fromBytes(bytes, 0, bytes.length);
    }

    public static LDataType fromBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        DataType dataType = LDataTypeFactory.INSTANCE.getClientTypeByOrdinal(bytes[offset]);
        if (dataType.isCollection()) {
            return LDataType.collectionTypeFromBytes(bytes, offset, length);
        }
        return LDataTypeFactory.INSTANCE.getTypeInstance(dataType);
    }

    public static LCollectionType collectionTypeFromBytes(byte[] bytes) throws IllegalDataException {
        return LDataType.collectionTypeFromBytes(bytes, 0, bytes.length);
    }

    public static LCollectionType collectionTypeFromBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        DataType dataTypeFromBytes = LDataTypeFactory.INSTANCE.getClientTypeByOrdinal(bytes[offset]);
        assert (dataTypeFromBytes.isCollection());
        if (dataTypeFromBytes == DataType.MAP) {
            return new LMap(bytes, offset, length);
        }
        if (dataTypeFromBytes == DataType.SET) {
            return new LSet(bytes, offset, length);
        }
        if (dataTypeFromBytes == DataType.LIST) {
            return new LList(bytes, offset, length);
        }
        throw new IllegalDataException("unknown collection data type: " + (Object)((Object)dataTypeFromBytes));
    }

    public abstract T randomData(DataGenerator var1);
}

