/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.HDouble;
import com.alibaba.lindorm.client.core.types.HFloat;
import com.alibaba.lindorm.client.core.types.HInteger;
import com.alibaba.lindorm.client.core.types.HLong;
import com.alibaba.lindorm.client.core.types.HShort;
import com.alibaba.lindorm.client.core.types.HString;
import com.alibaba.lindorm.client.core.types.LAccDouble;
import com.alibaba.lindorm.client.core.types.LByte;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDate;
import com.alibaba.lindorm.client.core.types.LDecimalV2;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LFloat;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LTime;
import com.alibaba.lindorm.client.core.types.LUnsignedByte;
import com.alibaba.lindorm.client.core.types.LUnsignedDate;
import com.alibaba.lindorm.client.core.types.LUnsignedDouble;
import com.alibaba.lindorm.client.core.types.LUnsignedFloat;
import com.alibaba.lindorm.client.core.types.LUnsignedInteger;
import com.alibaba.lindorm.client.core.types.LUnsignedLong;
import com.alibaba.lindorm.client.core.types.LUnsignedShort;
import com.alibaba.lindorm.client.core.types.LUnsignedTime;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;

public class LDecimal
extends LRealNumberType<BigDecimal> {
    public static final LDecimal INSTANCE = new LDecimal();
    public static final BigDecimal DEFAULT_NULL_VALUE = new BigDecimal(0);

    private LDecimal() {
        super(DataType.DECIMAL, BigDecimal.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object o) {
        return DataTypeUtils.getDecimalByteSize((BigDecimal)o);
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType instanceof LRealNumberType && DataTypeUtils.equalsAny(targetType, INSTANCE, LDecimalV2.INSTANCE);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        BigDecimal bd = (BigDecimal)value;
        return DataTypeUtils.encodeDecimal(bd, sortOrder);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, LInteger.INSTANCE, LUnsignedInteger.INSTANCE, HInteger.INSTANCE)) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (actualType == INSTANCE || actualType == LDecimalV2.INSTANCE) {
            return value;
        }
        if (actualType == LString.INSTANCE || actualType == HString.INSTANCE) {
            return new BigDecimal((String)value);
        }
        if (DataTypeUtils.equalsAny(actualType, LByte.INSTANCE, LUnsignedByte.INSTANCE)) {
            return BigDecimal.valueOf(((Byte)value).byteValue());
        }
        if (DataTypeUtils.equalsAny(actualType, LShort.INSTANCE, LUnsignedShort.INSTANCE, HShort.INSTANCE)) {
            return BigDecimal.valueOf(((Short)value).shortValue());
        }
        if (DataTypeUtils.equalsAny(actualType, LLong.INSTANCE, LUnsignedLong.INSTANCE, LLong.INSTANCE, HLong.INSTANCE)) {
            return BigDecimal.valueOf((Long)value);
        }
        if (DataTypeUtils.equalsAny(actualType, LFloat.INSTANCE, LUnsignedFloat.INSTANCE, HFloat.INSTANCE)) {
            return BigDecimal.valueOf(((Float)value).floatValue());
        }
        if (DataTypeUtils.equalsAny(actualType, LDouble.INSTANCE, LUnsignedDouble.INSTANCE, LAccDouble.INSTANCE, HDouble.INSTANCE)) {
            return BigDecimal.valueOf((Double)value);
        }
        if (DataTypeUtils.equalsAny(actualType, LDate.INSTANCE, LUnsignedDate.INSTANCE)) {
            return BigDecimal.valueOf(((Date)value).getTime());
        }
        if (DataTypeUtils.equalsAny(actualType, LTime.INSTANCE, LUnsignedTime.INSTANCE)) {
            return BigDecimal.valueOf(((Time)value).getTime());
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        return DataTypeUtils.decodeDecimal(value, offset, length, sortOrder);
    }

    @Override
    public byte[] toTransferBytes(Object data) throws IllegalDataException {
        return Bytes.toBytes((BigDecimal)data);
    }

    @Override
    public Object fromTransferBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        return Bytes.toBigDecimal(bytes, offset, length);
    }

    @Override
    public BigDecimal randomData(DataGenerator dataGenerator) {
        return LDecimalV2.INSTANCE.randomData(dataGenerator);
    }
}

