/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LBinary;
import com.alibaba.lindorm.client.core.types.LBlob;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LEncodedVarbinary
extends LDataType<byte[]> {
    public static final LEncodedVarbinary INSTANCE = new LEncodedVarbinary();

    private LEncodedVarbinary() {
        super(DataType.ENCODED_VARBINARY, byte[].class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("LEncodedVarbinary is variable length");
    }

    @Override
    public void validate(Object data) throws IllegalDataException {
        super.validate(data);
        byte[] bytes = (byte[])data;
        if (bytes.length == 0) {
            throw new IllegalDataException("Must not use byte[0] for ENCODED_VARBINARY, please use null instead");
        }
    }

    @Override
    public int getByteSize(Object obj) {
        return obj == null ? 0 : ((byte[])obj).length;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LVarbinary.INSTANCE || targetType == LBinary.INSTANCE || targetType == LBlob.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] v = (byte[])value;
        return DataTypeUtils.encodeEVarbinary(v, 0, v.length, sortOrder);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (actualType == INSTANCE) {
            return value;
        }
        return actualType.toBytes(value);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) {
        return DataTypeUtils.decodeEVarbinary(value, offset, length, sortOrder);
    }

    @Override
    public byte[] getNullValue() throws IllegalDataException {
        byte[] ret = new byte[]{0};
        return this.toBytes(ret);
    }

    @Override
    public byte[] randomData(DataGenerator dataGenerator) {
        return LBinary.INSTANCE.randomData(dataGenerator);
    }

    @Override
    public byte[] toTransferBytes(Object data) throws IllegalDataException {
        return (byte[])data;
    }

    @Override
    public Object fromTransferBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        if (offset == 0 && length == bytes.length) {
            return bytes;
        }
        return Bytes.copy(bytes, offset, length);
    }
}

