/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LAccDouble;
import com.alibaba.lindorm.client.core.types.LAccLong;
import com.alibaba.lindorm.client.core.types.LByte;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDate;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LDecimalV2;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LTime;
import com.alibaba.lindorm.client.core.types.LUnsignedByte;
import com.alibaba.lindorm.client.core.types.LUnsignedDate;
import com.alibaba.lindorm.client.core.types.LUnsignedDouble;
import com.alibaba.lindorm.client.core.types.LUnsignedFloat;
import com.alibaba.lindorm.client.core.types.LUnsignedInteger;
import com.alibaba.lindorm.client.core.types.LUnsignedLong;
import com.alibaba.lindorm.client.core.types.LUnsignedShort;
import com.alibaba.lindorm.client.core.types.LUnsignedTime;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;

public class LFloat
extends LRealNumberType<Float> {
    public static final LFloat INSTANCE = new LFloat();

    private LFloat() {
        super(DataType.FLOAT, Float.class);
    }

    @Override
    public int getByteSize() {
        return 4;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType instanceof LRealNumberType && DataTypeUtils.equalsAny(targetType, INSTANCE, LDouble.INSTANCE, LDecimal.INSTANCE, LDecimalV2.INSTANCE);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeFloat(((Number)value).floatValue(), ret, 0, sortOrder);
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        float ret;
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LUnsignedFloat.INSTANCE)) {
            return value;
        }
        if (DataTypeUtils.equalsAny(actualType, LDouble.INSTANCE, LUnsignedDouble.INSTANCE, LAccDouble.INSTANCE)) {
            Double v = (Double)value;
            if (!Double.isNaN(v) && v != Double.POSITIVE_INFINITY && v != Double.NEGATIVE_INFINITY && (!(v >= -3.4028234663852886E38) || !(v <= 3.4028234663852886E38))) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = v.floatValue();
            return Float.valueOf(ret);
        } else if (DataTypeUtils.equalsAny(actualType, LString.INSTANCE)) {
            try {
                ret = Float.parseFloat((String)value);
                return Float.valueOf(ret);
            }
            catch (NumberFormatException e) {
                throw new IllegalDataException("Cannot convert string value '" + value + "' to float value.", e);
            }
        } else if (DataTypeUtils.equalsAny(actualType, LLong.INSTANCE, LUnsignedLong.INSTANCE, LAccLong.INSTANCE)) {
            ret = ((Long)value).longValue();
            return Float.valueOf(ret);
        } else if (DataTypeUtils.equalsAny(actualType, LInteger.INSTANCE, LUnsignedInteger.INSTANCE)) {
            ret = ((Integer)value).intValue();
            return Float.valueOf(ret);
        } else if (DataTypeUtils.equalsAny(actualType, LShort.INSTANCE, LUnsignedShort.INSTANCE)) {
            ret = ((Short)value).shortValue();
            return Float.valueOf(ret);
        } else if (DataTypeUtils.equalsAny(actualType, LByte.INSTANCE, LUnsignedByte.INSTANCE)) {
            ret = ((Byte)value).byteValue();
            return Float.valueOf(ret);
        } else if (actualType == LDecimal.INSTANCE || actualType == LDecimalV2.INSTANCE) {
            BigDecimal bd = (BigDecimal)value;
            if (bd.compareTo(DataTypeUtils.MAX_FLOAT_AS_DECIMAL) > 0 || bd.compareTo(DataTypeUtils.MIN_FLOAT_AS_DECIMAL) < 0) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = bd.floatValue();
            return Float.valueOf(ret);
        } else if (DataTypeUtils.equalsAny(actualType, LDate.INSTANCE, LUnsignedDate.INSTANCE)) {
            ret = ((Date)value).getTime();
            return Float.valueOf(ret);
        } else {
            if (!DataTypeUtils.equalsAny(actualType, LTime.INSTANCE, LUnsignedTime.INSTANCE)) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = ((Time)value).getTime();
        }
        return Float.valueOf(ret);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return Float.valueOf(DataTypeUtils.decodeFloat(value, offset, sortOrder));
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_FLOAT_ARRAY;
    }

    @Override
    public Float randomData(DataGenerator dataGenerator) {
        return Float.valueOf(dataGenerator.getRandom().nextFloat());
    }
}

