/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LLineString;
import com.alibaba.lindorm.client.core.types.LPoint;
import com.alibaba.lindorm.client.core.types.LPolygon;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;

public class LGeometry
extends LDataType<LindormGeometry> {
    public static final LGeometry INSTANCE = new LGeometry();

    private LGeometry() {
        super(DataType.GEOMETRY, LindormGeometry.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object obj) {
        return obj == null ? 0 : ((LindormGeometry)obj).serialize().length;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        LindormGeometry lindormGeometry = (LindormGeometry)value;
        return DataTypeUtils.encodeLindormGeometry(lindormGeometry, sortOrder);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LPoint.INSTANCE, LLineString.INSTANCE, LPolygon.INSTANCE)) {
            return (LindormGeometry)value;
        }
        throw new IllegalDataException("Cannot convert object " + actualType.getClientType().toString() + " into Geometry");
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[length];
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(value, offset, ret, 0, length);
        } else {
            System.arraycopy(value, offset, ret, 0, length);
        }
        return DataTypeUtils.decodeLindormGeometry(ret);
    }

    @Override
    public LindormGeometry randomData(DataGenerator dataGenerator) {
        return new LindormGeometry("POINT(" + dataGenerator.getRandom().nextDouble() + " " + dataGenerator.getRandom().nextDouble() + ")", "Point");
    }

    public static class LindormGeometry {
        private byte version;
        private byte flag;
        private Envelope bbox;
        private byte[] eWkb;
        private Geometry geometry = null;
        private int wkbType;
        private static final byte VERSION = 1;
        public static final int GM_Z_FLAG = 1;
        public static final int GM_M_FLAG = 2;
        public static final int GM_SRID_FLAG = 4;
        public static final int GM_BBOX_FLAG = 8;
        public static final int GM_GEODETIC_FLAG = 16;
        public static final int WKB_TYPECODE_POINT = 1;
        public static final int WKB_TYPECODE_LINESTRING = 2;
        public static final int WKB_TYPECODE_POLYGON = 3;
        public static final int WKB_TYPECODE_MULTIPOINT = 4;
        public static final int WKB_TYPECODE_MULTILINESTRING = 5;
        public static final int WKB_TYPECODE_MULTIPOLYGON = 6;
        public static final int WKB_TYPECODE_GEOMETRYCOLLECTION = 7;
        public static final String JTS_TYPENAME_POINT = "Point";
        public static final String JTS_TYPENAME_LINESTRING = "LineString";
        public static final String JTS_TYPENAME_POLYGON = "Polygon";
        public static final String JTS_TYPENAME_MULTIPOINT = "MultiPoint";
        public static final String JTS_TYPENAME_MULTILINESTRING = "MultiLineString";
        public static final String JTS_TYPENAME_MULTIPOLYGON = "MultiPolygon";
        public static final String JTS_TYPENAME_GEOMETRYCOLLECTION = "GeometryCollection";

        private void addFlag(int flagBit) {
            this.flag = (byte)(this.flag | flagBit);
        }

        private void deleteFlag(int flagBit) {
            this.flag = (byte)(this.flag ^ flagBit);
        }

        private boolean checkFlag(int flagBit) {
            return (this.flag & flagBit) == flagBit;
        }

        public static boolean checkFlag(int flag, int flagBit) {
            return (flag & flagBit) == flagBit;
        }

        public static boolean checkVersionValid(byte version) {
            return 1 == version;
        }

        public LindormGeometry(Geometry geometry) {
            this.createFromGeometry(geometry);
        }

        public LindormGeometry(byte flag, Envelope bbox, byte[] eWkb, int wkbTypeCode) {
            this.version = 1;
            this.flag = flag;
            this.bbox = bbox;
            this.eWkb = Arrays.copyOf(eWkb, eWkb.length);
            this.wkbType = wkbTypeCode;
        }

        public LindormGeometry(String wkt, String jtsTypeName) {
            WKTReader wktReader = new WKTReader();
            try {
                this.geometry = wktReader.read(wkt);
            }
            catch (ParseException e) {
                throw new RuntimeException("Illegal geometry WKT: " + e);
            }
            this.geometry.setSRID(4326);
            if (!jtsTypeName.equalsIgnoreCase(this.geometry.getGeometryType())) {
                throw new IllegalArgumentException("Wrong geometry type: " + this.geometry.getGeometryType() + ",expected: " + jtsTypeName);
            }
            this.createFromGeometry(this.geometry);
        }

        private void createFromGeometry(Geometry geometry) {
            this.version = 1;
            this.geometry = geometry;
            this.geometry.setSRID(4326);
            if (this.geometry instanceof Point) {
                this.bbox = null;
                this.addFlag(4);
            } else {
                this.bbox = this.geometry.getEnvelopeInternal();
                this.addFlag(12);
            }
            WKBWriter wkbWriter2D = new WKBWriter(2, true);
            this.eWkb = wkbWriter2D.write(this.geometry);
            String type = this.geometry.getGeometryType();
            if (JTS_TYPENAME_POINT.equalsIgnoreCase(type)) {
                this.wkbType = 1;
            } else if (JTS_TYPENAME_LINESTRING.equalsIgnoreCase(type)) {
                this.wkbType = 2;
            } else if (JTS_TYPENAME_POLYGON.equalsIgnoreCase(type)) {
                this.wkbType = 3;
            } else if (JTS_TYPENAME_MULTIPOINT.equalsIgnoreCase(type)) {
                this.wkbType = 4;
            } else if (JTS_TYPENAME_MULTILINESTRING.equalsIgnoreCase(type)) {
                this.wkbType = 5;
            } else if (JTS_TYPENAME_MULTIPOLYGON.equalsIgnoreCase(type)) {
                this.wkbType = 6;
            } else if (JTS_TYPENAME_GEOMETRYCOLLECTION.equalsIgnoreCase(type)) {
                this.wkbType = 7;
            } else {
                throw new IllegalArgumentException("Unsupported geometry type: " + type);
            }
        }

        public boolean hasZ() {
            return this.checkFlag(1);
        }

        public boolean hasM() {
            return this.checkFlag(2);
        }

        public boolean hasSrid() {
            return this.checkFlag(4);
        }

        public boolean hasBbox() {
            return this.checkFlag(8);
        }

        public boolean isGeodetic() {
            return this.checkFlag(16);
        }

        public Geometry getGeometry() {
            try {
                if (this.geometry == null) {
                    this.geometry = new WKBReader().read(this.eWkb);
                }
                return this.geometry;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getWkbType() {
            return this.wkbType;
        }

        public Envelope getBbox() {
            return this.bbox;
        }

        public byte[] getBoundingBoxBytes() {
            if (this.hasZ() || this.hasM() || this.isGeodetic()) {
                throw new UnsupportedOperationException("Z, M and Geodetic are not supported yet");
            }
            return this.get2dBoundingBoxBytes();
        }

        private byte[] get2dBoundingBoxBytes() {
            if (this.bbox == null) {
                return null;
            }
            byte[] coords = new byte[16];
            int offset = 0;
            offset = Bytes.putFloat(coords, offset, (float)this.bbox.getMinX());
            offset = Bytes.putFloat(coords, offset, (float)this.bbox.getMaxX());
            offset = Bytes.putFloat(coords, offset, (float)this.bbox.getMinY());
            offset = Bytes.putFloat(coords, offset, (float)this.bbox.getMaxY());
            return coords;
        }

        public byte[] serialize() {
            if (this.hasZ() || this.hasM() || this.isGeodetic()) {
                throw new UnsupportedOperationException("Z, M and Geodetic are not supported yet");
            }
            byte[] boxCoords = this.getBoundingBoxBytes();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                outputStream.write(this.version);
                outputStream.write(this.flag);
                if (boxCoords != null) {
                    outputStream.write(boxCoords);
                }
                outputStream.write(this.eWkb);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return outputStream.toByteArray();
        }

        public String toString() {
            return WKBWriter.toHex(this.eWkb);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LindormGeometry)) {
                return false;
            }
            LindormGeometry lGeometry = (LindormGeometry)obj;
            return this.getGeometry().equalsExact(lGeometry.getGeometry());
        }

        public int hashCode() {
            return this.getGeometry().getEnvelopeInternal().hashCode();
        }
    }
}

