/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LAccLong;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LJson;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LInteger
extends LWholeNumberType<Integer> {
    public static final LInteger INSTANCE = new LInteger();

    private LInteger() {
        super(DataType.INT, Integer.class);
    }

    @Override
    public int getByteSize() {
        return 4;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        if (targetType instanceof LWholeNumberType && DataTypeUtils.equalsAny(targetType, INSTANCE, LLong.INSTANCE, LAccLong.INSTANCE)) {
            return true;
        }
        if (targetType instanceof LRealNumberType) {
            return true;
        }
        return targetType == LJson.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeInt(((Number)value).intValue(), ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        long v = 0L;
        try {
            v = (Long)LLong.INSTANCE.toObject(value, actualType);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
            return (int)v;
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeInt(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_INT_ARRAY;
    }

    @Override
    public Integer randomData(DataGenerator dataGenerator) {
        int ret = dataGenerator.getRandom().nextInt(Integer.MAX_VALUE);
        if (dataGenerator.getRandom().nextBoolean()) {
            ret = -ret;
        }
        return ret;
    }
}

