/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LGeometry;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;

public class LLineString
extends LDataType<LindormLineString> {
    public static final LLineString INSTANCE = new LLineString();

    private LLineString() {
        super(DataType.LINESTRING, LindormLineString.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object obj) {
        return obj == null ? 0 : ((LindormLineString)obj).serialize().length;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LGeometry.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        LindormLineString lindormLineString = (LindormLineString)value;
        if (lindormLineString.validateType()) {
            return DataTypeUtils.encodeLindormGeometry(lindormLineString, sortOrder);
        }
        throw new IllegalDataException("Invalid LineString type: " + lindormLineString.getGeometry().getGeometryType());
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (actualType.getClientType() == DataType.LINESTRING) {
            LindormLineString lindormLineString = (LindormLineString)value;
            if (lindormLineString.validateType()) {
                return lindormLineString;
            }
            throw new IllegalDataException("Invalid LineString object: " + lindormLineString.getGeometry().getGeometryType());
        }
        throw new IllegalDataException("Cannot convert object " + actualType.getClientType().toString() + " into LineString.");
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[length];
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(value, offset, ret, 0, length);
        } else {
            System.arraycopy(value, offset, ret, 0, length);
        }
        if (2 == DataTypeUtils.getWkbTypeCode(ret)) {
            return DataTypeUtils.decodeLindormGeometry(ret);
        }
        throw new IllegalDataException("Invalid LineString byte array.");
    }

    @Override
    public LindormLineString randomData(DataGenerator dataGenerator) {
        double a = dataGenerator.getRandom().nextDouble();
        double b = dataGenerator.getRandom().nextDouble();
        double c = dataGenerator.getRandom().nextDouble();
        double d = dataGenerator.getRandom().nextDouble();
        return new LindormLineString("LINESTRING(" + a + " " + b + ", " + c + " " + d + ")");
    }

    public static class LindormLineString
    extends LGeometry.LindormGeometry {
        public LindormLineString(LineString lineString) {
            super(lineString);
        }

        public LindormLineString(byte flag, Envelope bbox, byte[] eWkb) {
            super(flag, bbox, eWkb, 2);
        }

        public LindormLineString(String wkt) {
            super(wkt, "LineString");
        }

        public boolean validateType() {
            return 2 == this.getWkbType();
        }
    }
}

