/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LGeometry;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class LPoint
extends LDataType<LindormPoint> {
    public static final LPoint INSTANCE = new LPoint();

    private LPoint() {
        super(DataType.POINT, LindormPoint.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object obj) {
        return obj == null ? 0 : ((LindormPoint)obj).serialize().length;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LGeometry.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        LindormPoint lindormPoint = (LindormPoint)value;
        if (lindormPoint.validateType()) {
            return DataTypeUtils.encodeLindormGeometry(lindormPoint, sortOrder);
        }
        throw new IllegalDataException("Invalid point type: " + lindormPoint.getGeometry().getGeometryType());
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (actualType.getClientType() == DataType.POINT) {
            LindormPoint lindormPoint = (LindormPoint)value;
            if (lindormPoint.validateType()) {
                return lindormPoint;
            }
            throw new IllegalDataException("Invalid Point object: " + lindormPoint.getGeometry().getGeometryType());
        }
        throw new IllegalDataException("Cannot convert object " + actualType.getClientType().toString() + " into Point.");
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[length];
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(value, offset, ret, 0, length);
        } else {
            System.arraycopy(value, offset, ret, 0, length);
        }
        if (1 == DataTypeUtils.getWkbTypeCode(ret)) {
            return DataTypeUtils.decodeLindormGeometry(ret);
        }
        throw new IllegalDataException("Invalid Point byte array.");
    }

    @Override
    public LindormPoint randomData(DataGenerator dataGenerator) {
        return new LindormPoint(dataGenerator.getRandom().nextDouble(), dataGenerator.getRandom().nextDouble());
    }

    public static class LindormPoint
    extends LGeometry.LindormGeometry {
        public LindormPoint(Point point) {
            super(point);
        }

        public LindormPoint(byte flag, Envelope boundingBox, byte[] eWkb) {
            super(flag, boundingBox, eWkb, 1);
        }

        public LindormPoint(double x, double y) {
            this(new GeometryFactory(new PrecisionModel(), 4326).createPoint(new Coordinate(x, y)));
        }

        public LindormPoint(double x, double y, double z) {
            this(new GeometryFactory(new PrecisionModel(), 4326).createPoint(new Coordinate(x, y, z)));
        }

        public LindormPoint(String wkt) {
            super(wkt, "Point");
        }

        public boolean validateType() {
            return 1 == this.getWkbType();
        }
    }
}

