/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LGeometry;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;

public class LPolygon
extends LDataType<LindormPolygon> {
    public static final LPolygon INSTANCE = new LPolygon();

    private LPolygon() {
        super(DataType.POLYGON, LindormPolygon.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object obj) {
        return obj == null ? 0 : ((LindormPolygon)obj).serialize().length;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LGeometry.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        LindormPolygon lindormPolygon = (LindormPolygon)value;
        if (lindormPolygon.validateType()) {
            return DataTypeUtils.encodeLindormGeometry(lindormPolygon, sortOrder);
        }
        throw new IllegalDataException("Invalid Polygon type: " + lindormPolygon.getGeometry().getGeometryType());
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (actualType.getClientType() == DataType.POLYGON) {
            LindormPolygon lindormPolygon = (LindormPolygon)value;
            if (lindormPolygon.validateType()) {
                return lindormPolygon;
            }
            throw new IllegalDataException("Invalid Polygon object: " + lindormPolygon.getGeometry().getGeometryType());
        }
        throw new IllegalDataException("Cannot convert object " + actualType.getClientType().toString() + " into Polygon.");
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[length];
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(value, offset, ret, 0, length);
        } else {
            System.arraycopy(value, offset, ret, 0, length);
        }
        if (3 == DataTypeUtils.getWkbTypeCode(ret)) {
            return DataTypeUtils.decodeLindormGeometry(ret);
        }
        throw new IllegalDataException("Invalid Polygon byte array.");
    }

    @Override
    public LindormPolygon randomData(DataGenerator dataGenerator) {
        double a = dataGenerator.getRandom().nextDouble();
        double b = dataGenerator.getRandom().nextDouble();
        return new LindormPolygon("POLYGON((0 0,0 " + a + ", " + b + " " + a + ", " + b + " 0,0 0))");
    }

    public static class LindormPolygon
    extends LGeometry.LindormGeometry {
        public LindormPolygon(Polygon polygon) {
            super(polygon);
        }

        public LindormPolygon(byte flag, Envelope bBox, byte[] eWkb) {
            super(flag, bBox, eWkb, 3);
        }

        public LindormPolygon(String wkt) {
            super(wkt, "Polygon");
        }

        public boolean validateType() {
            return 3 == this.getWkbType();
        }
    }
}

