/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SetType;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class LSet<K>
extends LCollectionType<Set<K>> {
    private static final int HEADER_SIZE = 2;
    private final LDataType<K> elementType;
    public static final LSet FAKE_INSTANCE = new LSet<String>(LString.INSTANCE);

    public LSet(LDataType<K> elementType) {
        super(DataType.SET, Set.class);
        this.elementType = elementType;
    }

    public LSet(SetType setType) {
        super(DataType.SET, Set.class);
        this.elementType = setType.getCollectionDataType() != null ? LDataTypeFactory.INSTANCE.getTypeInstance(setType.getCollectionDataType()) : LDataTypeFactory.INSTANCE.getTypeInstance(setType.getDataType());
    }

    public LSet(byte[] bytes, int offset, int length) throws IllegalDataException {
        super(DataType.SET, Set.class);
        assert (bytes[offset] == DataType.SET.ordinal());
        byte elementTypeBytesLength = bytes[offset + 1];
        assert (elementTypeBytesLength > 0);
        this.elementType = LDataType.fromBytes(bytes, offset + 2, elementTypeBytesLength);
    }

    public LDataType<K> getElementType() {
        return this.elementType;
    }

    @Override
    public byte[] asBytes() {
        byte[] elementTypeBytes = LDataType.asBytes(this.elementType);
        int length = elementTypeBytes.length + 2;
        assert (length < 127);
        byte[] result = new byte[length];
        result[0] = (byte)DataType.SET.ordinal();
        result[1] = (byte)elementTypeBytes.length;
        System.arraycopy(elementTypeBytes, 0, result, 2, elementTypeBytes.length);
        return result;
    }

    @Override
    public CollectionDataType getCollectionDataType() {
        if (this.elementType instanceof LCollectionType) {
            return DataType.set(((LCollectionType)this.elementType).getCollectionDataType());
        }
        return DataType.set(this.elementType.getClientType());
    }

    @Override
    public LDataType getValueType() {
        return this.getElementType();
    }

    @Override
    public LDataType getKeyType() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LSet lSet = (LSet)o;
        return this.elementType != null ? this.elementType.equals(lSet.elementType) : lSet.elementType == null;
    }

    public int hashCode() {
        return this.elementType != null ? this.elementType.hashCode() : 0;
    }

    @Override
    public Set<K> randomData(DataGenerator dataGen) {
        HashSet<K> result = new HashSet<K>();
        int count = Math.max(10, dataGen.getCount());
        for (int i = 0; i < count; ++i) {
            result.add(this.elementType.randomData(dataGen));
        }
        return result;
    }

    @Override
    public byte[] toTransferBytes(Object data) throws IllegalDataException {
        return this.toTransferBytes((Set)data, this.elementType);
    }

    @Override
    public Set<K> fromTransferBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        LinkedHashSet result = new LinkedHashSet();
        this.fromTransferBytes(bytes, offset, length, this.elementType, result);
        return result;
    }

    @Override
    public void validate(Object data) throws IllegalDataException {
        super.validate(data);
        for (Object item : (Set)data) {
            this.elementType.validate(item);
        }
    }

    @Override
    public int getByteSize(Object o) {
        Set set = (Set)o;
        int result = 0;
        for (Object item : set) {
            if (item == null) continue;
            result += this.elementType.getByteSize(item);
        }
        return result;
    }

    @Override
    public String toString() {
        return String.format("Set<%s>", this.elementType);
    }
}

