/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LJson;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LShort
extends LWholeNumberType<Short> {
    public static final LShort INSTANCE = new LShort();

    private LShort() {
        super(DataType.SHORT, Short.class);
    }

    @Override
    public int getByteSize() {
        return 2;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        if (targetType instanceof LWholeNumberType && DataTypeUtils.equalsAny(targetType, INSTANCE, LInteger.INSTANCE, LLong.INSTANCE)) {
            return true;
        }
        if (targetType instanceof LRealNumberType) {
            return true;
        }
        return targetType == LJson.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeShort(((Number)value).shortValue(), ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        long v;
        if (value == null) {
            return null;
        }
        try {
            v = (Long)LLong.INSTANCE.toObject(value, actualType);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        if (v >= -32768L && v <= 32767L) {
            return (short)v;
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeShort(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_SHORT_ARRAY;
    }

    @Override
    public Short randomData(DataGenerator dataGenerator) {
        return (short)dataGenerator.getRandom().nextInt(Integer.MAX_VALUE);
    }
}

