/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.HString;
import com.alibaba.lindorm.client.core.types.LBoolean;
import com.alibaba.lindorm.client.core.types.LByte;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDate;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LDecimalV2;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LFloat;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LJson;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LTime;
import com.alibaba.lindorm.client.core.types.LTimestamp;
import com.alibaba.lindorm.client.core.types.LUnsignedByte;
import com.alibaba.lindorm.client.core.types.LUnsignedDate;
import com.alibaba.lindorm.client.core.types.LUnsignedDouble;
import com.alibaba.lindorm.client.core.types.LUnsignedFloat;
import com.alibaba.lindorm.client.core.types.LUnsignedInteger;
import com.alibaba.lindorm.client.core.types.LUnsignedLong;
import com.alibaba.lindorm.client.core.types.LUnsignedShort;
import com.alibaba.lindorm.client.core.types.LUnsignedTime;
import com.alibaba.lindorm.client.core.types.LUnsignedTimestamp;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LString
extends LDataType<String> {
    public static final LString INSTANCE = new LString();

    private LString() {
        super(DataType.STRING, String.class);
    }

    protected LString(DataType hstring) {
        super(hstring, String.class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object obj) {
        String value = (String)obj;
        return value == null ? 0 : value.length();
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return DataTypeUtils.equalsAny(targetType, INSTANCE, LBoolean.INSTANCE, LByte.INSTANCE, LUnsignedByte.INSTANCE, LShort.INSTANCE, LUnsignedShort.INSTANCE, LInteger.INSTANCE, LUnsignedInteger.INSTANCE, LLong.INSTANCE, LUnsignedLong.INSTANCE, LFloat.INSTANCE, LUnsignedFloat.INSTANCE, LDouble.INSTANCE, LUnsignedDouble.INSTANCE, LDecimal.INSTANCE, LDecimalV2.INSTANCE, LDate.INSTANCE, LUnsignedDate.INSTANCE, LTime.INSTANCE, LUnsignedTime.INSTANCE, LTimestamp.INSTANCE, LUnsignedTimestamp.INSTANCE, LJson.INSTANCE);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = Bytes.toBytes((String)value);
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(ret, 0, ret, 0, ret.length);
        }
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        if (actualType == INSTANCE || actualType == LJson.INSTANCE || actualType == HString.INSTANCE) {
            return value;
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        if (sortOrder == SortOrder.DESC) {
            byte[] copy = new byte[length];
            DataTypeUtils.invert(value, offset, copy, 0, length);
            return Bytes.toString(copy);
        }
        return Bytes.toString(value, offset, length);
    }

    public static boolean isEmptyString(byte[] value, int offset, int length) {
        return length == 1 && SchemaUtils.isSeparatorByte(value[offset]);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_STRING_ARRAY;
    }

    @Override
    public String randomData(DataGenerator dataGenerator) {
        return StringUtils.random(dataGenerator.getRandom(), dataGenerator.getMaxLength());
    }
}

