/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.util.UUID;

public class LUUID
extends LDataType<UUID> {
    public static final LUUID INSTANCE = new LUUID();

    private LUUID() {
        super(DataType.UUID, UUID.class);
    }

    @Override
    public int getByteSize() {
        return 16;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        byte[] ret = new byte[16];
        UUID uuid = (UUID)value;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        long encodedMSB = LUUID.encodeMSB(msb);
        DataTypeUtils.encodeUnsignedLong(encodedMSB, ret, 0, sortOrder, false);
        DataTypeUtils.encodeUnsignedLong(lsb, ret, 8, sortOrder, false);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE)) {
            return value;
        }
        throw new IllegalDataException("Cannot convert " + actualType.getClientType().toString() + " to uuid, value = " + value);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, 16, this.clientType);
        long encodedMSB = DataTypeUtils.decodeUnsignedLong(value, offset, sortOrder);
        long msb = this.decodeMSB(encodedMSB);
        long lsb = DataTypeUtils.decodeUnsignedLong(value, offset + 8, sortOrder);
        return new UUID(msb, lsb);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_UUID_ARRAY;
    }

    @Override
    public UUID randomData(DataGenerator dataGenerator) {
        return UUID.randomUUID();
    }

    public static long encodeMSB(long msb) {
        int version = LUUID.versionFromMSB(msb);
        if (version == 1) {
            return msb << 48 & 0xFFFF000000000000L | msb << 16 & 0xFFFF00000000L | msb >>> 32;
        }
        return msb << 48 & 0xF000000000000000L | msb >>> 4 & 0xFFFFFFFFFFFF000L | msb & 0xFFFL;
    }

    private long decodeMSB(long encodedMSB) {
        int version = this.versionFromEncodedMSB(encodedMSB);
        if (version == 1) {
            return encodedMSB << 32 & 0xFFFFFFFF00000000L | encodedMSB >>> 16 & 0xFFFF0000L | encodedMSB >>> 48 & 0xFFFFL;
        }
        return encodedMSB << 4 & 0xFFFFFFFFFFFF0000L | encodedMSB >>> 48 & 0xF000L | encodedMSB & 0xFFFL;
    }

    private static int versionFromMSB(long msb) {
        return (int)(msb >>> 12 & 0xFL);
    }

    private int versionFromEncodedMSB(long encodedMSB) {
        return (int)(encodedMSB >>> 60 & 0xFL);
    }
}

