/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LTimestamp;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.sql.Timestamp;

public class LUnsignedTimestamp
extends LDataType<Timestamp> {
    public static final LUnsignedTimestamp INSTANCE = new LUnsignedTimestamp();

    private LUnsignedTimestamp() {
        super(DataType.UNSIGNED_TIMESTAMP, Timestamp.class);
    }

    @Override
    public int getByteSize() {
        return 12;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        Timestamp ts = (Timestamp)value;
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeUnsignedLong(ts.getTime(), ret, 0, sortOrder);
        DataTypeUtils.encodeUnsignedInt(ts.getNanos() % 1000000, ret, 8, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        long v;
        if (value == null) {
            return null;
        }
        if (actualType == INSTANCE) {
            return value;
        }
        if (actualType == LTimestamp.INSTANCE) {
            long v2 = ((Timestamp)value).getTime();
            if (v2 < 0L) {
                throw new IllegalDataException("Cannot set negative value to UNSIGNED_TIMESTAMP type, actual value=" + v2);
            }
            return value;
        }
        if (actualType == LString.INSTANCE) {
            Timestamp ret;
            try {
                ret = Timestamp.valueOf((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalDataException("Cannot convert string '" + value + "' into Timestamp value.", e);
            }
            if (ret.getTime() < 0L) {
                throw new IllegalDataException("Cannot set negative value to UNSIGNED_TIMESTAMP type, actual value=" + ret + ", originalValue=" + value);
            }
            return ret;
        }
        try {
            v = (Long)LLong.INSTANCE.toObject(value, actualType);
        }
        catch (IllegalDataException t) {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        if (v < 0L) {
            throw new IllegalDataException("Cannot set negative value to UNSIGNED_TIMESTAMP type, actual value=" + v);
        }
        return new Timestamp(v);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        long ms = DataTypeUtils.decodeUnsignedLong(value, offset, sortOrder);
        int nanos = DataTypeUtils.decodeUnsignedInt(value, offset + 8, sortOrder);
        if (ms < 0L) {
            throw new IllegalDataException("Cannot set negative value to UNSIGNED_TIMESTAMP type, actual value=" + ms);
        }
        Timestamp ts = new Timestamp(ms);
        if (nanos < 1000000) {
            ts.setNanos(ts.getNanos() + nanos);
        } else {
            ts.setNanos(nanos);
        }
        return ts;
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_TIMESTAMP_ARRAY;
    }

    @Override
    public Timestamp randomData(DataGenerator dataGenerator) {
        return LTimestamp.INSTANCE.randomData(dataGenerator);
    }
}

