/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.ipc.BlobClient;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.Base64;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlobClientUtil {
    public static final Log LOG = LogFactory.getLog(BlobClientUtil.class);
    public static final int MAX_LENGTH_IN_BYTE = 0x40000000;
    public static final String OBJECTKEY = "objectkey";
    public static final String SPECIAL_OBJECTVALUE = "special_objectvalue";
    public static final byte BLOB_OBJECTKEY_VERSION = 0;

    public static String formatBlobBucketKey(String namespace, String table) throws LindormException {
        if (namespace == null || table == null) {
            throw new LindormException("Blob bucket key element should not be null, but " + (namespace == null ? "namespace" : (table == null ? " table" : " all")) + " is null");
        }
        String result = namespace + "-" + table;
        return result.toLowerCase();
    }

    public static boolean isBucketExists(String bucketName, BlobClient client) throws LindormException {
        try {
            client.getClient().headBucket(new HeadBucketRequest(bucketName));
        }
        catch (AmazonServiceException ae) {
            if (ae.getErrorCode().equals("404 Not Found")) {
                return false;
            }
            if (ae.getErrorCode().equals("403 Forbidden")) {
                throw new LindormException("Do not have the access to lindorm blob's bucket " + bucketName);
            }
            throw new LindormException("Lindorm blob column head bucket have exception : " + (Object)((Object)ae));
        }
        catch (SdkClientException se) {
            throw new LindormException("Lindorm blob column head bucket have exception : " + (Object)((Object)se));
        }
        return true;
    }

    public static void createBucket(String bucketName, BlobClient client) throws LindormException {
        try {
            Bucket bucket = client.getClient().createBucket(bucketName);
            LOG.info((Object)("Lindorm blob column create bucket : " + bucketName + " succeed with bucket info  " + bucket));
        }
        catch (Throwable throwable) {
            throw new LindormException("Lindorm blob column create bucket " + bucketName + " failed with exception : " + throwable);
        }
    }

    public static void uploadBlobObject(String bucketName, String keyName, byte[] object, BlobClient client, Map<String, String> jsonMap) throws LindormException {
        if (object == null) {
            jsonMap.put(SPECIAL_OBJECTVALUE, SpecialValue.NULL.ordinal() + "");
            return;
        }
        if (object.length == 0) {
            jsonMap.put(SPECIAL_OBJECTVALUE, SpecialValue.ZEROBYTE.ordinal() + "");
            return;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(object);
        if (object.length < 0x40000000) {
            try {
                client.getClient().putObject(bucketName, keyName, (InputStream)inputStream, new ObjectMetadata());
            }
            catch (AmazonServiceException ae) {
                throw new LindormException("Lindorm blob cloumn single upload data filed for s3 side error :  " + (Object)((Object)ae));
            }
            catch (SdkClientException se) {
                throw new LindormException("Lindorm blob cloumn single upload data filed for sdk side error :  " + (Object)((Object)se));
            }
        }
        long partSize = 0x500000L;
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        try {
            InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(bucketName, keyName);
            InitiateMultipartUploadResult initResponse = client.getClient().initiateMultipartUpload(initRequest);
            long filePosition = 0L;
            int i = 1;
            while (filePosition < (long)object.length) {
                partSize = Math.min(partSize, (long)object.length - filePosition);
                UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(bucketName).withKey(keyName).withUploadId(initResponse.getUploadId()).withPartNumber(i).withInputStream((InputStream)inputStream).withFileOffset(filePosition).withPartSize(partSize);
                UploadPartResult uploadResult = client.getClient().uploadPart(uploadRequest);
                partETags.add(uploadResult.getPartETag());
                filePosition += partSize;
                ++i;
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(bucketName, keyName, initResponse.getUploadId(), partETags);
            client.getClient().completeMultipartUpload(compRequest);
        }
        catch (AmazonServiceException ae) {
            throw new LindormException("Lindorm blob cloumn multi upload data filed for s3 side error :  " + (Object)((Object)ae));
        }
        catch (SdkClientException se) {
            throw new LindormException("Lindorm blob cloumn multi upload data filed for sdk side error :  " + (Object)((Object)se));
        }
    }

    public static byte[] getBlobObject(String bucketName, String objectKey, BlobClient client) throws LindormException {
        S3Object object = client.getClient().getObject(bucketName, objectKey);
        long len = object.getObjectMetadata().getContentLength();
        try {
            if (len <= Integer.MAX_VALUE) {
                int lenInt = (int)len;
                byte[] result = new byte[lenInt];
                int readSumLen = 0;
                int readLen = -1;
                int offset = 0;
                while (offset < lenInt && (readLen = object.getObjectContent().read(result, offset, lenInt - offset)) > 0) {
                    offset += readLen;
                    readSumLen += readLen;
                }
                if (readSumLen != lenInt) {
                    throw new LindormException("Lindorm blob read data is not same with the meta specified.");
                }
                return result;
            }
            throw new LindormException("Lindorm blob 's value is too big, and it is not upload by lindorm client.");
        }
        catch (Throwable throwable) {
            throw new LindormException("Lindorm blob read data failed " + throwable);
        }
    }

    public static byte[] getTheBlobColumnRealValue(Map<String, String> properties) throws LindormException {
        if (properties.size() > 0) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String json = objectMapper.writeValueAsString(properties);
                return json.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new LindormException("Do not support utf-8 endcoding when encoding real blob value with " + e);
            }
            catch (JsonProcessingException e) {
                throw new LindormException("Lindorm process blob value property to json failed with " + (Object)((Object)e));
            }
        }
        throw new LindormException("Lindorm blob column should have more than one bucket property.");
    }

    public static Map<String, String> getTheBlobColumnMapValueFromBytes(byte[] values) throws LindormException {
        if (values == null) {
            throw new LindormException("Lindorm blob column value is null");
        }
        String json = Bytes.toString(values);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Map resuletMap = (Map)objectMapper.readValue(json, Map.class);
            return resuletMap;
        }
        catch (Exception e) {
            throw new LindormException("Lindorm blob column value parse to map failed " + e);
        }
    }

    public static String encodeBlobKeyFromRowData(Row row, TableMeta tableMeta, ColumnKey columnKey) throws LindormException {
        try {
            List<LColumn> columns = tableMeta.getPkColumns();
            ArrayList<ColumnValue> columnValues = new ArrayList<ColumnValue>();
            for (LColumn column : columns) {
                ColumnValue pkColumnValue = row.getColumnValue(column.getColumnKey());
                if (pkColumnValue != null) {
                    columnValues.add(pkColumnValue);
                    continue;
                }
                throw new LindormException("Lindorm upsert row do not conatins primary key [" + column.getColumnKey().getQualifierAsString() + "]");
            }
            Pair<byte[][], Integer> resultPair = BlobClientUtil.generateContactByteArray(columnValues, columns, columnKey);
            return Base64.encodeAsString((byte[])BlobClientUtil.contactBytes((byte[][])resultPair.first, (Integer)resultPair.second, ((byte[][])resultPair.first).length));
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    public static byte[] contactBytes(byte[][] bytes, int totalLength, int num) throws IllegalDataException {
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (int i = 0; i < num; ++i) {
            byte[] v = bytes[i];
            if (v == null) {
                throw new IllegalDataException("The contact byte array element is null for the index " + i);
            }
            System.arraycopy(v, 0, ret, offset, v.length);
            offset += v.length;
        }
        return ret;
    }

    public static Pair<byte[][], Integer> generateContactByteArray(List<ColumnValue> columnValues, List<LColumn> columns, ColumnKey columnKey) throws IOException {
        byte[][] inputByteArray = new byte[5][];
        Integer totalLength = 0;
        byte[] pkValueBytes = SchemaUtils.columnValuesToRowKey(columnValues, columns);
        inputByteArray[0] = pkValueBytes;
        totalLength = totalLength + pkValueBytes.length;
        byte[] columnBytes = columnKey.asBytes();
        inputByteArray[1] = columnBytes;
        totalLength = totalLength + columnBytes.length;
        byte[] name = Bytes.toBytes(System.nanoTime());
        byte[] uuid = Bytes.toBytes(UUID.nameUUIDFromBytes(name));
        inputByteArray[2] = uuid;
        byte[] pkLen = Bytes.toBytes(pkValueBytes.length);
        inputByteArray[3] = pkLen;
        inputByteArray[4] = new byte[]{0};
        totalLength = totalLength + 21;
        return Pair.newPair(inputByteArray, totalLength);
    }

    public static byte[][] parseAllValueBytes(byte[] values) throws IOException {
        byte[][] result = new byte[5][];
        int len = values.length;
        int metaLen = 21;
        byte[] uuid = new byte[16];
        byte[] pkLenArry = new byte[4];
        byte[] version = new byte[1];
        System.arraycopy(values, len - metaLen, uuid, 0, 16);
        System.arraycopy(values, len - metaLen + 16, pkLenArry, 0, 4);
        System.arraycopy(values, len - metaLen + 20, version, 0, 1);
        int pkLen = Bytes.toInt(pkLenArry);
        byte[] pkArray = new byte[pkLen];
        byte[] column = new byte[len - metaLen - pkLen];
        System.arraycopy(values, 0, pkArray, 0, pkLen);
        System.arraycopy(values, pkLen, column, 0, len - metaLen - pkLen);
        result[0] = pkArray;
        result[1] = column;
        result[2] = uuid;
        result[3] = pkLenArry;
        result[4] = version;
        return result;
    }

    public static enum SpecialValue {
        NULL("null"){

            @Override
            public byte[] getRealValue() {
                return null;
            }
        }
        ,
        ZEROBYTE("zerobyte"){

            @Override
            public byte[] getRealValue() {
                return new byte[0];
            }
        };

        private String value;
        private static final SpecialValue[] specialValues;

        private SpecialValue(String value) {
            this.value = value;
        }

        public static SpecialValue fromOrdinal(int ordinal) {
            return specialValues[ordinal];
        }

        public String getValue() {
            return this.value;
        }

        public abstract byte[] getRealValue();

        static {
            specialValues = SpecialValue.values();
        }
    }
}

