/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.compile.BaseExpressionVisitor;
import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.compile.ConjunctiveClause;
import com.alibaba.lindorm.client.core.compile.DNFCompiler;
import com.alibaba.lindorm.client.core.compile.DisjunctiveNormalForm;
import com.alibaba.lindorm.client.core.compile.HBaseNumericInterval;
import com.alibaba.lindorm.client.core.compile.HBaseNumericTypeColumnSlotUtil;
import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.compile.IntervalQuery;
import com.alibaba.lindorm.client.core.compile.PrefixQuery;
import com.alibaba.lindorm.client.core.compile.QueryFilterInfo;
import com.alibaba.lindorm.client.core.compile.TransformIntoDNFVisitor;
import com.alibaba.lindorm.client.core.compile.WhereCompiler;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.ComparisonExpressionV3;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.FunctionCall;
import com.alibaba.lindorm.client.core.expression.Identifier;
import com.alibaba.lindorm.client.core.function.Function;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.IndexUtils;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.dml.OrderedColumnKey;
import com.alibaba.lindorm.client.exception.ColumnNotFoundException;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.PrimaryKeyOptionException;
import com.alibaba.lindorm.client.schema.DataCodec;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.PrimaryKeyOption;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CompilerUtils {
    private static final LDataTypeFactory TYPE_FACTORY = LDataTypeFactory.INSTANCE;
    public static final Codec DEFAULT_CODEC = new DefaultCodec();
    public static final Codec PHOENIX_CODEC = new PhoenixCodec();

    public static ConditionFactory.CompareOp transformCompareOp(SortOrder sortOrder, ConditionFactory.CompareOp originOp) {
        if (sortOrder == SortOrder.ASC) {
            return originOp;
        }
        switch (originOp) {
            case LESS: {
                return ConditionFactory.CompareOp.GREATER;
            }
            case LESS_OR_EQUAL: {
                return ConditionFactory.CompareOp.GREATER_OR_EQUAL;
            }
            case EQUAL: {
                return originOp;
            }
            case NOT_EQUAL: {
                return originOp;
            }
            case GREATER_OR_EQUAL: {
                return ConditionFactory.CompareOp.LESS_OR_EQUAL;
            }
            case GREATER: {
                return ConditionFactory.CompareOp.LESS;
            }
            case IS: {
                return ConditionFactory.CompareOp.IS;
            }
            case IS_NOT: {
                return ConditionFactory.CompareOp.IS_NOT;
            }
        }
        throw new IllegalArgumentException("Unknown compare op " + (Object)((Object)originOp));
    }

    public static boolean compare(ConditionFactory.CompareOp op, int compareResult, boolean isNullValue) {
        switch (op) {
            case LESS: {
                return compareResult < 0 && !isNullValue;
            }
            case LESS_OR_EQUAL: {
                return compareResult <= 0 && !isNullValue;
            }
            case EQUAL: {
                return compareResult == 0 && !isNullValue;
            }
            case IS: {
                return compareResult == 0;
            }
            case NOT_EQUAL: {
                return compareResult != 0 && !isNullValue;
            }
            case IS_NOT: {
                return compareResult != 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult >= 0 && !isNullValue;
            }
            case GREATER: {
                return compareResult > 0 && !isNullValue;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    public static Interval getKeyInterval(LColumn column, ComparisonExpression expr) throws LindormException {
        LDataType metaType = column.getDataType();
        byte[] key = expr.evaluateRHS(column);
        ConditionFactory.CompareOp op = CompilerUtils.transformCompareOp(column.getSortOrder(), expr.getOp());
        switch (op) {
            case EQUAL: {
                return metaType.getKeyInterval(key, true, key, true);
            }
            case GREATER_OR_EQUAL: {
                return metaType.getKeyInterval(key, true, Interval.UNBOUND, false);
            }
            case GREATER: {
                return metaType.getKeyInterval(key, false, Interval.UNBOUND, false);
            }
            case LESS: {
                return metaType.getKeyInterval(Interval.UNBOUND, false, key, false);
            }
            case LESS_OR_EQUAL: {
                return metaType.getKeyInterval(Interval.UNBOUND, false, key, true);
            }
            case NOT_EQUAL: {
                throw new IllegalArgumentException("Please call getKeyIntervalForNotEqual for NOT_EQUAL operator.");
            }
        }
        throw new IllegalArgumentException("Unknown compare operator " + (Object)((Object)expr.getOp()));
    }

    public static List<Interval> getKeyIntervalForNotEqual(LColumn column, ComparisonExpression expr) throws LindormException {
        byte[] key = expr.evaluateRHS(column);
        if (expr.getOp() == ConditionFactory.CompareOp.NOT_EQUAL) {
            ArrayList<Interval> ret = CollectionUtils.newArrayListWithCapacity(2);
            ret.add(Interval.create(Interval.UNBOUND, false, key, false));
            ret.add(Interval.create(key, false, Interval.UNBOUND, false));
            return ret;
        }
        throw new IllegalArgumentException("Please call getKeyInterval for operator " + (Object)((Object)expr.getOp()));
    }

    public static byte[] getRowKeyForRouting(TableMeta table, Expression where) throws LindormException {
        assert (table != null);
        byte[] rowKey = null;
        DisjunctiveNormalForm dnf = CompilerUtils.transformIntoDNF(table, where);
        DNFCompiler dnfCompiler = new DNFCompiler(table, dnf);
        Object intervalQueries = dnfCompiler.compile();
        if (intervalQueries != null && !intervalQueries.isEmpty()) {
            rowKey = ((IntervalQuery)intervalQueries.get(0)).getInterval().getLower();
        }
        if (Bytes.equals(rowKey, Bytes.EMPTY_BYTE_ARRAY)) {
            return null;
        }
        return rowKey;
    }

    public static byte[] getMinKey(WhereCompiler.SingleIntervalKeySlot[] slots) throws LindormException {
        int length = 0;
        Interval[] ranges = new Interval[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            Interval range;
            WhereCompiler.SingleIntervalKeySlot slot = slots[i];
            ranges[i] = range = slot.interval;
            if (!range.isSingleValue() && i != slots.length - 1) {
                throw new LindormException("Only the last pk column in WHERE clause can be a range");
            }
            length += range.getLower().length;
        }
        Interval lastInterval = ranges[ranges.length - 1];
        DataType lastSlotDataType = slots[ranges.length - 1].column.getDataType().getClientType();
        if (!(lastInterval.isLowerInclusive() || DataType.VARBINARY != lastSlotDataType && DataType.BLOB != lastSlotDataType)) {
            ++length;
        }
        byte[] key = new byte[length];
        int offset = 0;
        for (Interval range : ranges) {
            if (range.isLowerUnbound()) break;
            int keyLength = range.getLower().length;
            System.arraycopy(range.getLower(), 0, key, offset, keyLength);
            if (!range.isLowerInclusive()) {
                if (DataType.VARBINARY == lastSlotDataType || DataType.BLOB == lastSlotDataType) {
                    CompilerUtils.nextVarBinaryKey(key, offset, keyLength);
                    ++keyLength;
                } else {
                    CompilerUtils.nextKey(key, offset, keyLength);
                }
            }
            offset += keyLength;
        }
        if (offset == length) {
            return key;
        }
        byte[] copy = new byte[offset];
        System.arraycopy(key, 0, copy, 0, offset);
        return copy;
    }

    public static byte[] getMaxKey(WhereCompiler.SingleIntervalKeySlot[] slots) throws LindormException {
        int length = 0;
        Interval[] ranges = new Interval[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            Interval range;
            WhereCompiler.SingleIntervalKeySlot slot = slots[i];
            ranges[i] = range = slot.interval;
            if (!range.isSingleValue() && i != slots.length - 1) {
                throw new LindormException("Only the last pk column in WHERE clause can be a range");
            }
            length += range.getUpper().length;
        }
        Interval lastInterval = ranges[ranges.length - 1];
        DataType lastSlotDataType = slots[ranges.length - 1].column.getDataType().getClientType();
        if (lastInterval.isUpperInclusive() && (DataType.VARBINARY.equals((Object)lastSlotDataType) || DataType.BLOB.equals((Object)lastSlotDataType))) {
            ++length;
        }
        byte[] key = new byte[length];
        int offset = 0;
        for (int i = 0; i < slots.length; ++i) {
            Interval range = ranges[i];
            if (range.isUpperUnbound()) {
                if (i != slots.length - 1) break;
                CompilerUtils.nextKey(key, 0, offset);
                break;
            }
            System.arraycopy(range.getUpper(), 0, key, offset, range.getUpper().length);
            int keyLength = range.getUpper().length;
            if (range.isUpperInclusive() && i == slots.length - 1) {
                if (DataType.VARBINARY.equals((Object)lastSlotDataType) || DataType.BLOB.equals((Object)lastSlotDataType)) {
                    CompilerUtils.nextVarBinaryKey(key, offset, keyLength);
                    ++keyLength;
                } else {
                    CompilerUtils.nextKey(key, offset, keyLength);
                }
            }
            offset += keyLength;
        }
        if (offset == length) {
            return key;
        }
        byte[] copy = new byte[offset];
        System.arraycopy(key, 0, copy, 0, offset);
        return copy;
    }

    public static byte[] nextKey(byte[] key) {
        byte[] ret = new byte[key.length];
        System.arraycopy(key, 0, ret, 0, key.length);
        if (!CompilerUtils.nextKey(ret, 0, ret.length)) {
            return null;
        }
        return ret;
    }

    public static boolean nextKey(byte[] key, int offset, int length) {
        if (length == 0) {
            return false;
        }
        int i = offset + length - 1;
        while (key[i] == -1) {
            key[i] = 0;
            if (--i >= offset) continue;
            do {
                key[++i] = -1;
            } while (i < offset + length - 1);
            return false;
        }
        key[i] = (byte)(key[i] + 1);
        return true;
    }

    public static boolean nextVarBinaryKey(byte[] key, int offset, int length) {
        if (length == 0) {
            return false;
        }
        key[offset + length] = 0;
        return true;
    }

    public static byte[] concatRowKey(byte[][] bytes, int totalLength) {
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (byte[] v : bytes) {
            if (v == null) break;
            System.arraycopy(v, 0, ret, offset, v.length);
            offset += v.length;
        }
        return ret;
    }

    public static byte[] concatRowKey(byte[] ... bytes) {
        int totalLength = 0;
        for (byte[] part : bytes) {
            totalLength += part.length;
        }
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (byte[] v : bytes) {
            System.arraycopy(v, 0, ret, offset, v.length);
            offset += v.length;
        }
        return ret;
    }

    public static byte[] concatRowKey(ImmutableBytesPtr[] bytes, int totalLength) {
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (ImmutableBytesPtr v : bytes) {
            if (v == null) break;
            System.arraycopy(v.get(), v.getOffset(), ret, offset, v.getLength());
            offset += v.getLength();
        }
        return ret;
    }

    public static byte[] concatRowKey(byte[][] bytes, int totalLength, List<LColumn> pkSchema) throws IllegalDataException {
        byte[] ret = new byte[totalLength];
        int offset = 0;
        for (int i = 0; i < pkSchema.size(); ++i) {
            byte[] v = bytes[i];
            if (v == null) {
                throw new IllegalDataException("Not enough PK column values in UPSERT, [" + pkSchema.get(i).toString() + "] is missing.");
            }
            System.arraycopy(v, 0, ret, offset, v.length);
            offset += v.length;
        }
        return ret;
    }

    public static DisjunctiveNormalForm transformIntoDNF(TableMeta table, Expression condition) throws LindormException {
        return CompilerUtils.transformIntoDNF(table, condition, new TransformIntoDNFVisitor(table));
    }

    public static DisjunctiveNormalForm transformIntoDNF(TableMeta table, Expression condition, BaseExpressionVisitor<DisjunctiveNormalForm> visitor) throws LindormException {
        if (condition == null) {
            return null;
        }
        return condition.accept(visitor);
    }

    public static PrefixQuery generatePrefixQuery(TableMeta table, List<ColumnSlot> columnSlots, List<ColumnSlot> consecutivePKColumns, List<Expression> expressions) {
        boolean isPointLookUp;
        Codec codec = CompilerUtils.getTableCodec(table.getTableAttributes().getDataCodec());
        int numConsecutivePKColumns = consecutivePKColumns.size();
        boolean bl = isPointLookUp = numConsecutivePKColumns == table.getPkColumns().size();
        if (numConsecutivePKColumns >= columnSlots.size()) {
            return new PrefixQuery(CompilerUtils.createRowKeyRange(codec, consecutivePKColumns, isPointLookUp), QueryFilterInfo.create(columnSlots, columnSlots.size(), expressions));
        }
        ColumnSlot lastColumnSlot = columnSlots.get(numConsecutivePKColumns);
        LColumn lastColumn = lastColumnSlot.getColumn();
        if (!lastColumn.isPrimaryKey() || lastColumn.getPosition() != numConsecutivePKColumns) {
            return new PrefixQuery(CompilerUtils.createRowKeyRange(codec, consecutivePKColumns, isPointLookUp), QueryFilterInfo.create(columnSlots, numConsecutivePKColumns, expressions));
        }
        int offset = lastColumnSlot.hasSimilarities() ? numConsecutivePKColumns : numConsecutivePKColumns + 1;
        return new PrefixQuery(CompilerUtils.createRowKeyRange(codec, consecutivePKColumns, lastColumnSlot), QueryFilterInfo.create(columnSlots, offset, expressions));
    }

    private static List<Interval> createRowKeyRange(Codec codec, List<ColumnSlot> consecutivePKColumns, boolean isPointLookUp) {
        LColumn lastPK = null;
        if (consecutivePKColumns != null && !consecutivePKColumns.isEmpty()) {
            lastPK = consecutivePKColumns.get(consecutivePKColumns.size() - 1).getColumn();
        }
        if (isPointLookUp) {
            byte[] pointLookupRowkey = CompilerUtils.createPointLookUpRowKey(consecutivePKColumns);
            byte[] actualRowkey = codec.processSingleRowkey(consecutivePKColumns, pointLookupRowkey);
            return Collections.singletonList(Interval.create(actualRowkey));
        }
        if (consecutivePKColumns.isEmpty()) {
            return Collections.singletonList(Interval.EVERYTHING_RANGE);
        }
        int numConsecutivePKColumns = consecutivePKColumns.size();
        byte[][] values = new byte[numConsecutivePKColumns][];
        for (int i = 0; i < numConsecutivePKColumns; ++i) {
            values[i] = consecutivePKColumns.get(i).getInterval().getLower();
        }
        byte[] lower = CompilerUtils.concatRowKey((byte[][])values);
        lower = codec.processLowerInclusive(lastPK, lower);
        int lastConsecutivePKColumnIndex = numConsecutivePKColumns - 1;
        byte[] lastValue = consecutivePKColumns.get(lastConsecutivePKColumnIndex).getInterval().getLower();
        values[lastConsecutivePKColumnIndex] = lastValue;
        byte[] upper = CompilerUtils.createNextRowKey(values, consecutivePKColumns);
        return Collections.singletonList(Interval.create(lower, upper));
    }

    private static byte[] createPointLookUpRowKey(List<ColumnSlot> consecutivePKColumns) {
        byte[][] values = new byte[consecutivePKColumns.size()][];
        int keyLength = 0;
        for (int i = 0; i < consecutivePKColumns.size(); ++i) {
            values[i] = consecutivePKColumns.get(i).getInterval().getLower();
            keyLength += values[i].length;
        }
        return CompilerUtils.concatRowKey((byte[][])values, keyLength);
    }

    private static byte[] createNextRowKey(byte[][] values, List<ColumnSlot> consecutivePKColumns) {
        for (int i = consecutivePKColumns.size() - 1; i >= 0; --i) {
            LColumn column = consecutivePKColumns.get(i).getColumn();
            byte[] next = CompilerUtils.getNextValue(column, values[i]);
            if (next == null) continue;
            return CompilerUtils.concatRowKey(values, 0, i - 1, next);
        }
        return Interval.UNBOUND;
    }

    public static byte[] getNextValue(LColumn column, byte[] value) {
        if (Bytes.compareTo(value, Interval.UNBOUND) == 0) {
            return null;
        }
        boolean isVarBinary = DataType.VARBINARY.equals((Object)column.getDataType().getClientType()) || DataType.BLOB.equals((Object)column.getDataType().getClientType());
        int length = isVarBinary ? value.length + 1 : value.length;
        byte[] next = new byte[length];
        System.arraycopy(value, 0, next, 0, value.length);
        if (isVarBinary) {
            return (byte[])(CompilerUtils.nextVarBinaryKey(next, 0, value.length) ? next : null);
        }
        return (byte[])(CompilerUtils.nextKey(next, 0, length) ? next : null);
    }

    private static byte[] concatRowKey(byte[][] values, int fromIndex, int toIndex, byte[] lastValue) {
        int offset = 0;
        int totalLength = 0;
        for (int i = fromIndex; i <= toIndex; ++i) {
            totalLength += values[i].length;
        }
        byte[] ret = new byte[totalLength += lastValue.length];
        for (int i = fromIndex; i <= toIndex; ++i) {
            System.arraycopy(values[i], 0, ret, offset, values[i].length);
            offset += values[i].length;
        }
        System.arraycopy(lastValue, 0, ret, offset, lastValue.length);
        return ret;
    }

    private static List<Interval> createRowKeyRange(Codec codec, List<ColumnSlot> consecutivePKColumns, ColumnSlot lastColumnSlot) {
        int numConsecutivePKColumns = consecutivePKColumns.size();
        byte[][] values = new byte[numConsecutivePKColumns + 1][];
        for (int i = 0; i < numConsecutivePKColumns; ++i) {
            values[i] = consecutivePKColumns.get(i).getInterval().getLower();
        }
        LColumn column = lastColumnSlot.getColumn();
        Interval interval = lastColumnSlot.getInterval();
        SortedSet<ColumnSlot.Point> points = lastColumnSlot.getExclusions();
        ArrayList<Interval> intervals = new ArrayList<Interval>(1 + (points == null ? 0 : points.size()));
        byte[] lower = CompilerUtils.createRowKeyForLower(codec, values, consecutivePKColumns, column, interval);
        if (!interval.isLowerUnbound() && Bytes.compareTo(lower, Interval.UNBOUND) == 0) {
            return intervals;
        }
        if (points != null) {
            for (ColumnSlot.Point point : points) {
                values[numConsecutivePKColumns] = point.getValue();
                byte[] upper = CompilerUtils.concatRowKey((byte[][])values);
                upper = codec.processUpperExclusive(column, upper);
                CompilerUtils.addToIntervals(intervals, lower, upper);
                lower = CompilerUtils.createNextRowKey(values, consecutivePKColumns, column, point.getValue());
                if (Bytes.compareTo(lower, Interval.UNBOUND) != 0) continue;
                return intervals;
            }
        }
        byte[] upper = CompilerUtils.createRowKeyForUpper(codec, values, consecutivePKColumns, column, interval);
        CompilerUtils.addToIntervals(intervals, lower, upper);
        return intervals;
    }

    private static byte[] createRowKeyForLower(Codec codec, byte[][] values, List<ColumnSlot> consecutivePKColumns, LColumn lastColumn, Interval lastInterval) {
        int lastIndex = values.length - 1;
        if (lastInterval.isLowerInclusive()) {
            values[lastIndex] = lastInterval.getLower();
            byte[] lower = CompilerUtils.concatRowKey(values);
            return codec.processLowerInclusive(lastColumn, lower);
        }
        if (lastInterval.isLowerUnbound()) {
            values[lastIndex] = SchemaUtils.storePkNulls(lastColumn) && lastColumn.getSortOrder() == SortOrder.ASC ? SchemaUtils.VALUE_PREFIX_BYTES : lastInterval.getLower();
            return CompilerUtils.concatRowKey(values);
        }
        return CompilerUtils.createNextRowKey(values, consecutivePKColumns, lastColumn, lastInterval.getLower());
    }

    private static byte[] createNextRowKey(byte[][] values, List<ColumnSlot> consecutivePKColumns, LColumn lastColumn, byte[] lastValue) {
        int lastIndex = values.length - 1;
        byte[] next = CompilerUtils.getNextValue(lastColumn, lastValue);
        if (next != null) {
            values[lastIndex] = next;
            return CompilerUtils.concatRowKey(values);
        }
        return CompilerUtils.createNextRowKey(values, consecutivePKColumns);
    }

    private static byte[] createRowKeyForUpper(Codec codec, byte[][] values, List<ColumnSlot> consecutivePKColumns, LColumn lastColumn, Interval lastInterval) {
        int lastIndex = values.length - 1;
        if (!lastInterval.isUpperInclusive() && !lastInterval.isUpperUnbound()) {
            values[lastIndex] = lastInterval.getUpper();
            byte[] upper = CompilerUtils.concatRowKey(values);
            return codec.processUpperExclusive(lastColumn, upper);
        }
        if (lastInterval.isUpperUnbound() && SchemaUtils.storePkNulls(lastColumn) && lastColumn.getSortOrder() == SortOrder.DESC) {
            values[lastIndex] = SchemaUtils.VALUE_PREFIX_BYTES;
            return CompilerUtils.concatRowKey(values);
        }
        return CompilerUtils.createNextRowKey(values, consecutivePKColumns, lastColumn, lastInterval.getUpper());
    }

    private static void addToIntervals(List<Interval> intervals, byte[] lower, byte[] upper) {
        Interval newInterval = Interval.create(lower, upper);
        if (!newInterval.equals(Interval.EMPTY_RANGE)) {
            intervals.add(newInterval);
        }
    }

    public static int compareColumnPosition(LColumn column, LColumn otherColumn) {
        int position = column.getPosition();
        int otherPosition = otherColumn.getPosition();
        if (position >= 0 && otherPosition >= 0) {
            return position == otherPosition ? 0 : (position > otherPosition ? 1 : -1);
        }
        if (position >= 0) {
            return -1;
        }
        if (otherPosition >= 0) {
            return 1;
        }
        byte[] columnFullName = column.getFullName();
        byte[] otherColumnFullName = otherColumn.getFullName();
        return Bytes.compareTo(columnFullName, otherColumnFullName);
    }

    public static DisjunctiveNormalForm rewriteDNF(TableMeta table, DisjunctiveNormalForm dnf) throws LindormException {
        if (dnf == null || dnf.isDegenerate()) {
            return dnf;
        }
        List<ConjunctiveClause> clauses = dnf.getConjunctiveClauses();
        ArrayList<ConjunctiveClause> newClauses = new ArrayList<ConjunctiveClause>(clauses.size());
        for (ConjunctiveClause clause : clauses) {
            List<ColumnSlot> columnSlots = clause.getColumnSlots();
            ArrayList<ColumnSlot> transformedColumnSlots = new ArrayList<ColumnSlot>(columnSlots.size());
            for (ColumnSlot columnSlot : columnSlots) {
                LColumn lColumn;
                ColumnKey columnKey = IndexUtils.getIndexColumnKey(columnSlot.getColumn().getColumnKey(), table);
                try {
                    lColumn = table.resolveColumn(columnKey);
                }
                catch (ColumnNotFoundException e) {
                    lColumn = columnSlot.getColumn().deepCopy(-1, false);
                }
                transformedColumnSlots.add(CompilerUtils.transformColumnSlot(columnSlot, lColumn));
            }
            List<Expression> resultExps = CompilerUtils.transformExpToFuntionColumnSlot(clause.getExpressions(), transformedColumnSlots, table);
            Collections.sort(transformedColumnSlots, new Comparator<ColumnSlot>(){

                @Override
                public int compare(ColumnSlot slot, ColumnSlot otherSlot) {
                    return CompilerUtils.compareColumnPosition(slot.getColumn(), otherSlot.getColumn());
                }
            });
            ArrayList<Expression> newExpressions = new ArrayList<Expression>(resultExps.size());
            for (Expression oldExpression : resultExps) {
                boolean allColumnsInIndex = true;
                for (LColumn column : oldExpression.usedColumns()) {
                    ColumnKey columnKey = IndexUtils.getIndexColumnKey(column.getColumnKey(), table);
                    if (IndexUtils.isColumnInIndex(table, columnKey)) continue;
                    allColumnsInIndex = false;
                    break;
                }
                if (allColumnsInIndex) {
                    newExpressions.add(CompilerUtils.transformExpressionInPlace(table, oldExpression));
                    continue;
                }
                newExpressions.add(oldExpression);
            }
            newClauses.add(new ConjunctiveClause(transformedColumnSlots, newExpressions));
        }
        return new DisjunctiveNormalForm(newClauses);
    }

    private static ColumnSlot transformColumnSlot(ColumnSlot columnSlot, LColumn newLColumn) throws LindormException {
        if (columnSlot.doesNotExist()) {
            return columnSlot;
        }
        LColumn oldLColumn = columnSlot.getColumn();
        Interval interval = null;
        SortedSet<ColumnSlot.Point> exclusions = null;
        if (CompilerUtils.needTransformValue(oldLColumn, newLColumn)) {
            Pair<Interval, SortedSet<ColumnSlot.Point>> newInfo = CompilerUtils.generateNewIntervalAndExclusions(columnSlot.getInterval(), columnSlot.getExclusions(), oldLColumn, newLColumn);
            interval = newInfo.getFirst();
            exclusions = newInfo.getSecond();
        } else {
            if (DataTypeUtils.isHBaseNumericType(oldLColumn.getDataType())) {
                throw new IllegalDataException("Not expected to reach here, hbase type must be cast to lindorm type in index, current columnSlot = " + columnSlot + ", new column = " + newLColumn);
            }
            interval = columnSlot.getInterval();
            exclusions = columnSlot.getExclusions();
        }
        return ColumnSlot.create(newLColumn, interval, exclusions, columnSlot.getSimilarities());
    }

    public static Pair<Interval, SortedSet<ColumnSlot.Point>> generateNewIntervalAndExclusions(Interval oldInterval, SortedSet<ColumnSlot.Point> oldExclusions, LColumn oldLColumn, LColumn newLColumn) throws LindormException {
        boolean sortOrderChanged;
        Interval interval = null;
        TreeSet<ColumnSlot.Point> exclusions = null;
        boolean bl = sortOrderChanged = !newLColumn.getSortOrder().equals((Object)oldLColumn.getSortOrder());
        if (oldInterval != null) {
            if (oldInterval instanceof HBaseNumericInterval) {
                return HBaseNumericTypeColumnSlotUtil.generateNewIntervalAndExclusions(oldInterval, oldExclusions, oldLColumn, newLColumn);
            }
            if (oldInterval.equals(Interval.EMPTY_RANGE)) {
                return new Pair<Interval, Object>(Interval.EMPTY_RANGE, null);
            }
            byte[] lower = oldInterval.isLowerUnbound() ? oldInterval.getLower() : CompilerUtils.transformValue(oldInterval.getLower(), oldLColumn, newLColumn);
            byte[] upper = oldInterval.isUpperUnbound() ? oldInterval.getUpper() : CompilerUtils.transformValue(oldInterval.getUpper(), oldLColumn, newLColumn);
            interval = sortOrderChanged ? Interval.create(upper, oldInterval.isUpperInclusive(), lower, oldInterval.isLowerInclusive()) : Interval.create(lower, oldInterval.isLowerInclusive(), upper, oldInterval.isUpperInclusive());
            if (oldExclusions != null) {
                exclusions = new TreeSet<ColumnSlot.Point>();
                for (ColumnSlot.Point point : oldExclusions) {
                    exclusions.add(new ColumnSlot.Point(CompilerUtils.transformValue(point.getValue(), oldLColumn, newLColumn)));
                }
            }
        } else {
            byte[] nullValueBytes = LDataType.toBytes(newLColumn, null, TYPE_FACTORY.getTypeInstance(newLColumn.getDataType().getClientType()));
            interval = Interval.create(nullValueBytes);
        }
        return new Pair<Interval, Object>(interval, exclusions);
    }

    public static boolean needTransformValue(LColumn oldLColumn, LColumn newLColumn) {
        boolean changeDataType = !newLColumn.getDataType().equals(oldLColumn.getDataType());
        boolean changeStorePkNulls = SchemaUtils.storePkNulls(oldLColumn) != SchemaUtils.storePkNulls(newLColumn);
        boolean changeToPrimaryKey = newLColumn.isPrimaryKey() && !oldLColumn.isPrimaryKey();
        boolean sortOrderChanged = !newLColumn.getSortOrder().equals((Object)oldLColumn.getSortOrder());
        boolean saltOptionChanged = !CompilerUtils.hasSamePrimaryKeyOption(oldLColumn, newLColumn);
        return changeDataType || changeToPrimaryKey || sortOrderChanged || changeStorePkNulls || saltOptionChanged;
    }

    public static boolean hasSamePrimaryKeyOption(LColumn oldLColumn, LColumn newLColumn) {
        if (newLColumn.getPkOption() == oldLColumn.getPkOption()) {
            return true;
        }
        return newLColumn.getPkOption() == null && oldLColumn.getPkOption() == PrimaryKeyOption.NONE || newLColumn.getPkOption() == PrimaryKeyOption.NONE && oldLColumn.getPkOption() == null;
    }

    private static byte[] transformValue(byte[] value, LColumn oldLColumn, LColumn newLColumn) throws IllegalDataException {
        Object object = LDataType.toObject(oldLColumn, value);
        DataType type = newLColumn.getDataType().getClientType();
        return LDataType.toBytes(newLColumn, object, LDataTypeFactory.INSTANCE.getTypeInstance(type));
    }

    public static Expression convertToExpression(DisjunctiveNormalForm dnf) throws IllegalDataException, IllegalRequestException {
        if (dnf == null || dnf.isDegenerate()) {
            return null;
        }
        ConditionList orExpression = ConditionFactory.or();
        List<ConjunctiveClause> clauses = dnf.getConjunctiveClauses();
        for (ConjunctiveClause clause : clauses) {
            List<ColumnSlot> columnSlots = clause.getColumnSlots();
            List<Expression> expressions = clause.getExpressions();
            orExpression.add(CompilerUtils.convertToAndExpression(columnSlots, expressions));
        }
        return orExpression.getConditions().size() > 1 ? orExpression : orExpression.getConditions().get(0);
    }

    public static Expression convertToAndExpression(List<ColumnSlot> columnSlots, List<Expression> expressions) throws IllegalRequestException, IllegalDataException {
        ConditionList andExpression = ConditionFactory.and();
        if (columnSlots != null) {
            if (columnSlots.size() == 1) {
                andExpression.add(columnSlots.get(0).toExpression());
            } else {
                for (ColumnSlot columnSlot : columnSlots) {
                    andExpression.add(columnSlot.toExpression());
                }
            }
        }
        if (expressions != null) {
            for (Expression exp : expressions) {
                andExpression.add(exp);
            }
        }
        if (andExpression.getConditions().size() == 0) {
            SchemaUtils.LOG.error((Object)"Illegal request to convert and expression, columnSlots and expressions all null");
            return andExpression;
        }
        return andExpression.getConditions().size() > 1 ? andExpression : andExpression.getConditions().get(0);
    }

    public static DisjunctiveNormalForm convertToDNF(List<QueryFilterInfo> filters) {
        if (filters == null || filters.isEmpty()) {
            return new DisjunctiveNormalForm();
        }
        ArrayList<ConjunctiveClause> conjunctiveClauses = new ArrayList<ConjunctiveClause>(filters.size());
        for (QueryFilterInfo filter : filters) {
            List<ColumnSlot> columnSlots = filter.getColumnSlots();
            if (columnSlots == null || columnSlots.isEmpty()) continue;
            conjunctiveClauses.add(new ConjunctiveClause(columnSlots));
        }
        return new DisjunctiveNormalForm(conjunctiveClauses);
    }

    public static QuerySortType getQuerySortType(TableMeta table, List<OrderedColumnKey> orderByColumns) throws LindormException {
        Integer lastPosition = null;
        QuerySortType sortType = null;
        for (OrderedColumnKey orderByColumn : orderByColumns) {
            try {
                ColumnKey columnKey = !table.isIndex() ? new ColumnKey(orderByColumn.getFamily(), orderByColumn.getQualifier()) : IndexUtils.getIndexColumnKey(orderByColumn.getColumnKey(), table);
                LColumn lColumn = table.resolveColumn(columnKey);
                if (SchemaUtils.isSaltPkOption(lColumn.getPkOption())) {
                    throw new PrimaryKeyOptionException("Salted column cannot use order by, column is: " + columnKey);
                }
                if (!lColumn.isPrimaryKey() || lastPosition != null && lastPosition + 1 != lColumn.getPosition()) {
                    return QuerySortType.EXTRA;
                }
                lastPosition = lColumn.getPosition();
                boolean sortOrderMatched = lColumn.getSortOrder().equals((Object)orderByColumn.getSortOrder());
                if (sortType == null) {
                    sortType = sortOrderMatched ? QuerySortType.FORWARD : QuerySortType.REVERSE;
                    continue;
                }
                if (sortType.equals((Object)(sortOrderMatched ? QuerySortType.FORWARD : QuerySortType.REVERSE))) continue;
                return QuerySortType.EXTRA;
            }
            catch (ColumnNotFoundException e) {
                sortType = QuerySortType.EXTRA;
                break;
            }
        }
        return sortType;
    }

    public static byte[] getNextValueByPaddingZeroByte(byte[] value) {
        byte[] nextValue = new byte[value.length + 1];
        System.arraycopy(value, 0, nextValue, 0, value.length);
        nextValue[nextValue.length - 1] = 0;
        return nextValue;
    }

    public static void separateFilters(List<QueryFilterInfo> filtersForIndexTable, List<QueryFilterInfo> filtersForDataTable, TableMeta indexTable, TableMeta dataTable, List<QueryFilterInfo> filters) throws LindormException {
        HashSet<QueryFilterInfo> indexFilterInfoSet = new HashSet<QueryFilterInfo>();
        HashMap<ColumnSlot, Integer> indexColumnSlotFrequency = new HashMap<ColumnSlot, Integer>();
        HashMap<Expression, Integer> indexExpressionFrequency = new HashMap<Expression, Integer>();
        HashSet<ColumnSlot> indexColumnSlotCommonPart = new HashSet<ColumnSlot>();
        HashSet<Expression> indexExpressionCommonPart = new HashSet<Expression>();
        boolean allFiltersNeedQueryBack = false;
        for (QueryFilterInfo filter : filters) {
            List<ColumnSlot> columnSlots = filter.getColumnSlots();
            ArrayList<ColumnSlot> columnSlotsForIndexTable = new ArrayList<ColumnSlot>(columnSlots.size());
            for (ColumnSlot columnSlot : columnSlots) {
                ColumnKey columnKey = IndexUtils.getIndexColumnKey(columnSlot.getColumn().getColumnKey(), indexTable);
                if (!IndexUtils.isColumnInIndex(indexTable, columnKey)) continue;
                columnSlotsForIndexTable.add(columnSlot);
                CompilerUtils.increaseQueryInfoFrequencyAndRecord(indexColumnSlotFrequency, columnSlot, filters.size(), indexColumnSlotCommonPart);
            }
            List<Expression> expressions = filter.getExpressions();
            ArrayList<Expression> expressionsForIndexTable = new ArrayList<Expression>(expressions.size());
            for (Expression exp : expressions) {
                boolean allFiltersInIndex = true;
                for (LColumn column : exp.usedColumns()) {
                    ColumnKey columnKey = IndexUtils.getIndexColumnKey(column.getColumnKey(), indexTable);
                    if (IndexUtils.isColumnInIndex(indexTable, columnKey)) continue;
                    allFiltersInIndex = false;
                }
                if (!allFiltersInIndex) continue;
                expressionsForIndexTable.add(exp);
                CompilerUtils.increaseQueryInfoFrequencyAndRecord(indexExpressionFrequency, exp, filters.size(), indexExpressionCommonPart);
            }
            if (columnSlotsForIndexTable.isEmpty() && expressionsForIndexTable.isEmpty()) {
                allFiltersNeedQueryBack = true;
                break;
            }
            indexFilterInfoSet.add(QueryFilterInfo.create(columnSlotsForIndexTable, expressionsForIndexTable));
        }
        if (!allFiltersNeedQueryBack) {
            filtersForIndexTable.addAll(indexFilterInfoSet);
        }
        for (QueryFilterInfo filter : filters) {
            QueryFilterInfo filterInfo = CompilerUtils.transformFilter(dataTable, filter, indexColumnSlotCommonPart, indexExpressionCommonPart, indexExpressionFrequency.keySet());
            if (filterInfo == null) continue;
            filtersForDataTable.add(filterInfo);
        }
    }

    public static Expression transformExpression(TableMeta table, Expression node) throws IllegalRequestException, ColumnNotFoundException {
        if (node instanceof FunctionCall) {
            FunctionCall call = (FunctionCall)node;
            FunctionCall newCall = new FunctionCall();
            newCall.setName(call.getName());
            ArrayList<Expression> newArguments = new ArrayList<Expression>(call.getArguments().size());
            for (int i = 0; i < call.getArguments().size(); ++i) {
                newArguments.add(CompilerUtils.transformExpression(table, call.getArguments().get(i)));
            }
            newCall.setArguments(newArguments);
            newCall.setCompiled(call.isCompiled());
            return newCall;
        }
        if (node instanceof Identifier) {
            LColumn column = table.resolveColumn(((Identifier)node).toColumnKey());
            Identifier newNode = new Identifier(((Identifier)node).getValue());
            newNode.castDataTypeToVarbinary(((Identifier)node).getCastToVarbinary());
            newNode.setColumn(column);
            return newNode;
        }
        if (node instanceof ComparisonExpressionV3) {
            Expression newLeft = CompilerUtils.transformExpression(table, ((ComparisonExpressionV3)node).getLeft());
            Expression newRight = CompilerUtils.transformExpression(table, ((ComparisonExpressionV3)node).getRight());
            ComparisonExpressionV3 expr = new ComparisonExpressionV3(((ComparisonExpressionV3)node).getOp(), newLeft, newRight);
            return expr;
        }
        return node;
    }

    public static Expression transformExpressionInPlace(TableMeta table, Expression node) throws IllegalRequestException, ColumnNotFoundException {
        if (node instanceof FunctionCall) {
            FunctionCall call = (FunctionCall)node;
            for (int i = 0; i < call.getArguments().size(); ++i) {
                CompilerUtils.transformExpressionInPlace(table, call.getArguments().get(i));
            }
            call.setCompiled(true);
            Function func = call.getFunction();
            if (func == null) {
                throw new IllegalRequestException("function not found: " + call.getName());
            }
            return call;
        }
        if (node instanceof Identifier) {
            LColumn column = table.resolveColumn(((Identifier)node).toColumnKey());
            ((Identifier)node).setColumn(column);
            return node;
        }
        if (node instanceof ComparisonExpressionV3) {
            ComparisonExpressionV3 expr = (ComparisonExpressionV3)node;
            CompilerUtils.transformExpressionInPlace(table, expr.getLeft());
            CompilerUtils.transformExpressionInPlace(table, expr.getRight());
            return expr;
        }
        return node;
    }

    private static void increaseQueryInfoFrequencyAndRecord(Map<ColumnSlot, Integer> columnSlotCounterMap, ColumnSlot info, int filterSize, Set<ColumnSlot> indexColumnSlotCommonPart) {
        if (columnSlotCounterMap.get(info) == null) {
            columnSlotCounterMap.put(info, 1);
        } else {
            int count = columnSlotCounterMap.get(info);
            columnSlotCounterMap.put(info, ++count);
        }
        if (columnSlotCounterMap.get(info) == filterSize) {
            indexColumnSlotCommonPart.add(info);
        }
    }

    private static void increaseQueryInfoFrequencyAndRecord(Map<Expression, Integer> expressionCounterMap, Expression info, int filterSize, Set<Expression> indexExpressionCommonPart) {
        if (expressionCounterMap.get(info) == null) {
            expressionCounterMap.put(info, 1);
        } else {
            int count = expressionCounterMap.get(info);
            expressionCounterMap.put(info, ++count);
        }
        if (expressionCounterMap.get(info) == filterSize) {
            indexExpressionCommonPart.add(info);
        }
    }

    private static QueryFilterInfo transformFilter(TableMeta dataTable, QueryFilterInfo filter, Set<ColumnSlot> excludeColumnSlot, Set<Expression> excludeExpression, Set<Expression> expressionsForIndex) throws LindormException {
        ArrayList<ColumnSlot> columnSlotsForDataTable = new ArrayList<ColumnSlot>(filter.getColumnSlots().size());
        List<ColumnSlot> columnSlots = filter.getColumnSlots();
        for (ColumnSlot columnSlot : columnSlots) {
            if (excludeColumnSlot.contains(columnSlot)) continue;
            if (columnSlot.getColumn().isPrimaryKey()) {
                LColumn newColumn = dataTable.resolveColumnNoThrow(columnSlot.getColumn().getDataColumnKey());
                columnSlotsForDataTable.add(CompilerUtils.transformColumnSlot(columnSlot, newColumn));
                continue;
            }
            columnSlotsForDataTable.add(columnSlot);
        }
        ArrayList<Expression> expressionsForDataTable = new ArrayList<Expression>(filter.getExpressions().size());
        for (Expression exp : filter.getExpressions()) {
            if (excludeExpression.contains(exp)) continue;
            if (expressionsForIndex.contains(exp)) {
                expressionsForDataTable.add(CompilerUtils.transformExpression(dataTable, exp));
                continue;
            }
            expressionsForDataTable.add(exp);
        }
        return QueryFilterInfo.create(columnSlotsForDataTable, expressionsForDataTable);
    }

    private static List<Expression> transformExpToFuntionColumnSlot(List<Expression> expressionList, List<ColumnSlot> transformedColumnSlots, TableMeta table) throws LindormException {
        ArrayList<Expression> resultExps = new ArrayList<Expression>(expressionList);
        if (!table.isIndex()) {
            return resultExps;
        }
        for (Expression expression : expressionList) {
            boolean shoudIncludeExp = true;
            for (int pos : table.getFunctionColumnsPos()) {
                LColumn lColumn;
                LColumn funcCol = table.getFunctionColumn(pos);
                Pair<Boolean, ColumnSlot> pair = funcCol.getColumnFunction().getFunction().functionColumnMatchExpression(funcCol, expression);
                if (!pair.getFirst().booleanValue()) continue;
                ColumnKey columnKey = IndexUtils.getIndexColumnKey(pair.getSecond().getColumn().getColumnKey(), table);
                try {
                    lColumn = table.resolveColumn(columnKey);
                }
                catch (ColumnNotFoundException e) {
                    lColumn = pair.getSecond().getColumn().deepCopy(-1, false);
                }
                transformedColumnSlots.add(CompilerUtils.transformColumnSlot(pair.getSecond(), lColumn));
                shoudIncludeExp = false;
                break;
            }
            if (shoudIncludeExp) continue;
            resultExps.remove(expression);
        }
        return resultExps;
    }

    public static QueryType getQueryType(List<IntervalQuery> intervalQueries) {
        if (intervalQueries == null || intervalQueries.isEmpty()) {
            return QueryType.INVALID;
        }
        boolean isPointLookUp = true;
        for (IntervalQuery intervalQuery : intervalQueries) {
            Interval interval = intervalQuery.getInterval();
            if (interval.isSingleValue()) continue;
            isPointLookUp = false;
        }
        if (isPointLookUp) {
            return QueryType.POINT_LOOK_UP;
        }
        return QueryType.SCAN;
    }

    public static Codec getTableCodec(DataCodec codecConfig) {
        switch (codecConfig) {
            case PHOENIX: {
                return PHOENIX_CODEC;
            }
        }
        return DEFAULT_CODEC;
    }

    private static boolean isNullOrEmptyValue(byte[] value, int offset, int length, LColumn meta) {
        if (value == null || value.length == 0) {
            return true;
        }
        return SchemaUtils.hasSeparatorByte(meta.getDataType()) && value.length == 1;
    }

    private static byte[] removeLastSeparatorIfNecessaryForPhx(LColumn lastPK, byte[] originalRowkey) {
        if (lastPK == null) {
            return originalRowkey;
        }
        if (SchemaUtils.hasSeparatorByte(lastPK.getDataType())) {
            return Arrays.copyOf(originalRowkey, originalRowkey.length - 1);
        }
        return originalRowkey;
    }

    private static class PtrByteArrayListImpl
    implements PKValueList {
        ImmutableBytesPtr[] values;

        PtrByteArrayListImpl(ImmutableBytesPtr[] values) {
            this.values = values;
        }

        @Override
        public boolean isNullOrEmpty(int i, LColumn meta) {
            ImmutableBytesPtr ptr = this.values[i];
            return CompilerUtils.isNullOrEmptyValue(ptr.get(), ptr.getOffset(), ptr.getLength(), meta);
        }

        @Override
        public byte[] get(int i) {
            return this.values[i].copyBytes();
        }
    }

    private static class ByteArrayListImpl
    implements PKValueList {
        byte[][] values;

        ByteArrayListImpl(byte[][] values) {
            this.values = values;
        }

        @Override
        public boolean isNullOrEmpty(int i, LColumn meta) {
            byte[] v = this.values[i];
            return CompilerUtils.isNullOrEmptyValue(v, 0, v.length, meta);
        }

        @Override
        public byte[] get(int i) {
            return this.values[i];
        }
    }

    private static interface PKValueList {
        public boolean isNullOrEmpty(int var1, LColumn var2);

        public byte[] get(int var1);
    }

    private static class PhoenixCodec
    implements Codec {
        private PhoenixCodec() {
        }

        @Override
        public byte[] processLowerInclusive(LColumn lastConsecutivePK, byte[] originalRowkey) {
            return CompilerUtils.removeLastSeparatorIfNecessaryForPhx(lastConsecutivePK, originalRowkey);
        }

        @Override
        public byte[] processUpperExclusive(LColumn lastConsecutivePK, byte[] originalRowkey) {
            return CompilerUtils.removeLastSeparatorIfNecessaryForPhx(lastConsecutivePK, originalRowkey);
        }

        @Override
        public byte[] processSingleRowkey(List<ColumnSlot> consecutivePKValues, byte[] originalRowkey) {
            byte[][] values = new byte[consecutivePKValues.size()][];
            for (int i = 0; i < consecutivePKValues.size(); ++i) {
                values[i] = consecutivePKValues.get(i).getInterval().getLower();
            }
            ByteArrayListImpl pkValues = new ByteArrayListImpl(values);
            ArrayList<LColumn> pkColumns = new ArrayList<LColumn>(consecutivePKValues.size());
            for (ColumnSlot cs : consecutivePKValues) {
                pkColumns.add(cs.getColumn());
            }
            return this.doProcessSingleRowkey(pkColumns, pkValues, originalRowkey);
        }

        @Override
        public byte[] processSingleRowkey(List<LColumn> pkColumns, byte[][] values, byte[] originalRowkey) {
            ByteArrayListImpl pkValues = new ByteArrayListImpl(values);
            return this.doProcessSingleRowkey(pkColumns, pkValues, originalRowkey);
        }

        @Override
        public byte[] processSingleRowkey(List<LColumn> pkColumns, ImmutableBytesPtr[] values, byte[] originalRowkey) {
            PtrByteArrayListImpl pkValues = new PtrByteArrayListImpl(values);
            return this.doProcessSingleRowkey(pkColumns, pkValues, originalRowkey);
        }

        private byte[] doProcessSingleRowkey(List<LColumn> pkColumns, PKValueList values, byte[] originalRowkey) {
            int lastNonNullPKIndex = -1;
            boolean removeSeparator = true;
            for (int i = pkColumns.size() - 1; i >= 0; --i) {
                LColumn columnMeta = pkColumns.get(i);
                if (values.isNullOrEmpty(i, columnMeta)) continue;
                lastNonNullPKIndex = i;
                LColumn c = pkColumns.get(lastNonNullPKIndex);
                removeSeparator = SchemaUtils.hasSeparatorByte(c.getDataType());
                break;
            }
            if (lastNonNullPKIndex < 0) {
                throw new RuntimeException("All PK columns are null or empty, there must be at least one non-null PK value.");
            }
            if (lastNonNullPKIndex < pkColumns.size() || removeSeparator) {
                byte[][] nonNullValues = new byte[lastNonNullPKIndex + 1][];
                for (int i = 0; i <= lastNonNullPKIndex; ++i) {
                    byte[] pkValue = values.get(i);
                    if (i == lastNonNullPKIndex) {
                        int copiedLength = removeSeparator ? pkValue.length - 1 : pkValue.length;
                        pkValue = Arrays.copyOf(pkValue, copiedLength);
                    }
                    nonNullValues[i] = pkValue;
                }
                byte[] newRowkey = CompilerUtils.concatRowKey((byte[][])nonNullValues);
                return newRowkey;
            }
            return originalRowkey;
        }
    }

    private static class DefaultCodec
    implements Codec {
        private DefaultCodec() {
        }

        @Override
        public byte[] processLowerInclusive(LColumn lastConsecutivePK, byte[] originalRowkey) {
            return originalRowkey;
        }

        @Override
        public byte[] processUpperExclusive(LColumn lastConsecutivePK, byte[] originalRowkey) {
            return originalRowkey;
        }

        @Override
        public byte[] processSingleRowkey(List<ColumnSlot> consecutivePKValues, byte[] originalRowkey) {
            return originalRowkey;
        }

        @Override
        public byte[] processSingleRowkey(List<LColumn> pkColumns, byte[][] values, byte[] originalRowkey) {
            return originalRowkey;
        }

        @Override
        public byte[] processSingleRowkey(List<LColumn> pkColumns, ImmutableBytesPtr[] values, byte[] originalRowkey) {
            return originalRowkey;
        }
    }

    public static interface Codec {
        public byte[] processLowerInclusive(LColumn var1, byte[] var2);

        public byte[] processUpperExclusive(LColumn var1, byte[] var2);

        public byte[] processSingleRowkey(List<ColumnSlot> var1, byte[] var2);

        public byte[] processSingleRowkey(List<LColumn> var1, byte[][] var2, byte[] var3);

        public byte[] processSingleRowkey(List<LColumn> var1, ImmutableBytesPtr[] var2, byte[] var3);
    }

    public static enum QuerySortType {
        FORWARD(0),
        REVERSE(1),
        EXTRA(2),
        SEARCH_INDEX(3),
        SEARCH_INDEX_EXTRA(4);

        private final int code;

        private QuerySortType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static QuerySortType codeToType(int code) {
            for (QuerySortType type : QuerySortType.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return null;
        }

        public static boolean needExtraSort(QuerySortType type) {
            return type == EXTRA || type == SEARCH_INDEX_EXTRA;
        }
    }

    public static enum QueryType {
        INVALID,
        POINT_LOOK_UP,
        SCAN;

    }
}

