/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.meta.Entity;
import com.alibaba.lindorm.client.core.meta.EntityMeta;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.EntityState;
import com.alibaba.lindorm.client.schema.LindormEntityDescriptor;
import java.util.ArrayList;
import java.util.List;

public class EntityUtils {
    public static final String ENTITY_NAME_SEPARATOR = "_";

    public static String getEntityPhysicalName(String tableName, long metaVersion, String entityName) {
        return tableName + ENTITY_NAME_SEPARATOR + metaVersion + ENTITY_NAME_SEPARATOR + entityName;
    }

    public static void validateEntityDescriptorForCreate(LindormEntityDescriptor desc) throws IllegalRequestException {
        SchemaUtils.validateTableName(desc.getTableName());
        String entityName = desc.getEntityName();
        if (entityName == null || entityName.isEmpty()) {
            throw new IllegalRequestException("Entity name must not be null or empty for table [" + desc.getTableName() + "]");
        }
        SchemaUtils.validateTableName(desc.getEntityName());
    }

    public static Entity createFirstEntity(Entity e) {
        Entity.EntityBuilder builder = new Entity.EntityBuilder();
        builder.setParent(e.getNamespace(), e.getTableName()).setEntityName(e.getTableName()).setEntityPhysicalName(e.getTableName()).setState(EntityState.ACTIVE).setComment("1st").setCreateTimestamp(e.getCreateTimestamp()).setMetaVersion(0L);
        return builder.build();
    }

    public static void checkDuplicateEntityName(Entity e, EntityMeta meta) throws IllegalRequestException {
        Entity duplicate = meta.getEntities().get(e.getEntityName());
        if (duplicate != null) {
            throw new IllegalRequestException("Entity name [" + e.getEntityName() + "] already exists for table [" + e.getNamespace() + "." + e.getTableName() + "]. Please choose another name.");
        }
    }

    public static void checkEntityNumber(EntityMeta oldMeta, int maxEntityAllowed) throws IllegalRequestException {
        if (oldMeta.getEntities().size() >= maxEntityAllowed) {
            throw new IllegalRequestException("Cannot create new entity for table [" + oldMeta.getFullTableName() + "] as there are too many entities, maxAllowed=" + maxEntityAllowed);
        }
    }

    public static void checkBuildingEntity(EntityMeta oldMeta) throws IllegalRequestException {
        List<Entity> buildingEntities = oldMeta.getEntitiesByState(EntityState.BUILDING);
        if (buildingEntities != null && !buildingEntities.isEmpty()) {
            throw new IllegalRequestException("Only one BUILDING entity allowed, but found " + EntityUtils.getEntityNameList(buildingEntities) + ", you can call CreateEntityOptions#setOnlyOneBuildingEntity(false) to disable this check.");
        }
    }

    public static List<String> getEntityNameList(List<Entity> entities) {
        ArrayList<String> ret = new ArrayList<String>(entities.size());
        for (Entity e : entities) {
            ret.add(e.getEntityName());
        }
        return ret;
    }

    public static void incMetaVersion(EntityMeta meta) {
        meta.setMetaVersion(meta.getMetaVersion() + 1L);
    }

    private EntityUtils() {
    }
}

