/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.expression.ComparisonExpressionV3;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.FunctionCall;
import com.alibaba.lindorm.client.core.expression.Identifier;
import com.alibaba.lindorm.client.core.expression.Literal;
import com.alibaba.lindorm.client.core.meta.CoveredColumnType;
import com.alibaba.lindorm.client.core.meta.ExternalIndexRowFormatterType;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exception.ColumnNotFoundException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.Mutability;
import com.alibaba.lindorm.client.schema.PrimaryKeyOption;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.util.HashSet;
import java.util.List;

public class IndexUtils {
    public static final String MAX_INDEX_NUM_KEY = "lindorm.max.index.number";
    public static final int DEFAULT_MAX_INDEX_NUM = 5;
    public static final String MAX_NUM_INDEXED_NON_PRIMARY_KEY_COLUMNS = "lindorm.indexed.non.primary.key.columns.max";
    public static final int DEFAULT_MAX_NUM_INDEXED_NON_PRIMARY_KEY_COLUMNS = 3;
    public static final String MAX_NUM_COVERED_COLUMNS = "lindorm.covered.columns.max";
    public static final int DEFAULT_MAX_NUM_COVERED_COLUMNS = 5;
    public static final String SINGLE_ZONE_CHECK_KEY = "lindorm.single.zone.check.index";
    public static boolean DEFAULT_SINGLE_ZONE_CHECK = true;
    public static final String INDEX_NAMES_KEY = "INDEX_NAMES";
    public static final byte[] INDEX_NAMES_KEY_BYTES = Bytes.toBytes("INDEX_NAMES");
    public static final String INDEX_META_KEY = "INDEX_META";
    public static final String INDEX_ID_KEY = "INDEX_ID";
    public static final byte[] INDEX_ID_KEY_BYTES = Bytes.toBytes("INDEX_ID");
    public static final String SILENCE_INDEXES_KEY = "SILENCE_INDEXES";
    public static final byte[] SILENCE_INDEXES_KEY_BYTES = Bytes.toBytes("SILENCE_INDEXES");
    public static final String INDEX_COVERED_COLUMN_TYPE = "INDEX_COVERED_TYPE";
    public static final String INDEX_STATE_KEY = "INDEX_STATE";
    public static final String INDEX_NAME_KEY = "INDEX_NAME";
    public static final String INDEX_CREATE_CONDITION_KEY = "INDEX_CREATE_CONDITION";
    public static final String INDEX_STORE_PK_NULLS_KEY = "INDEX_STORE_PK_NULLS";
    public static final String INDEX_STORE_FAMILY_IN_QUALIFIER = "INDEX_STORE_FAMILY_IN_QUALIFIER";
    public static final String INDEX_STORE_PK_TS_KEY = "INDEX_STORE_PK_TS";

    public static ColumnKey getDataColumnKeyForDynamicColumn(String indexQualifier) {
        int splitPoint = indexQualifier.indexOf(SchemaUtils.COLUMN_NAME_SEPARATOR);
        String family = indexQualifier.substring(0, splitPoint);
        String qualifier = indexQualifier.substring(splitPoint + 1);
        return new ColumnKey(family, qualifier);
    }

    public static byte[] getIndexColumnQualifier(ColumnKey dataColumnKey, TableMeta indexMeta) {
        return IndexUtils.doGetIndexColumnQualifier(dataColumnKey, indexMeta.isStoreFamilyInQualifier(), indexMeta.getCoveredColumnType());
    }

    public static byte[] doGetIndexColumnQualifier(ColumnKey dataColumnKey, boolean storeFamilyInQualifier, CoveredColumnType coveredType) {
        byte[] indexQualifier = storeFamilyInQualifier || coveredType == CoveredColumnType.DYNAMIC ? dataColumnKey.getFullName() : dataColumnKey.getQualifier();
        return indexQualifier;
    }

    public static boolean needQualifierConversion(CoveredColumnType ccType) {
        return ccType == CoveredColumnType.DYNAMIC;
    }

    public static boolean isFullCover(CoveredColumnType ccType) {
        return ccType == CoveredColumnType.ALL || ccType == CoveredColumnType.DYNAMIC;
    }

    public static ColumnKey getNonPKIndexColumnKey(ColumnKey dataColumnKey, TableMeta indexTableMeta) {
        ColumnKey ck = dataColumnKey;
        if (!ck.hasFamily()) {
            ck = new ColumnKey(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, dataColumnKey.getQualifier());
        }
        byte[] indexQualifier = IndexUtils.getIndexColumnQualifier(ck, indexTableMeta);
        return new ColumnKey(IndexUtils.getIndexFamily(indexTableMeta), indexQualifier);
    }

    public static byte[] getIndexFamily(TableMeta indexMeta) {
        if (indexMeta.isLocalIndex()) {
            return SchemaUtils.DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES;
        }
        return SchemaUtils.DEFAULT_FAMILY_NAME_BYTES;
    }

    public static ColumnKey getIndexColumnKey(ColumnKey dataColumnKey, TableMeta indexTableMeta) {
        LColumn idxLColumn = indexTableMeta.resolveColumnNoThrow(dataColumnKey);
        boolean isPK = idxLColumn != null ? idxLColumn.isPrimaryKey() : false;
        CoveredColumnType ccType = indexTableMeta.getCoveredColumnType();
        if (ccType == CoveredColumnType.DYNAMIC || indexTableMeta.isStoreFamilyInQualifier()) {
            return isPK ? new ColumnKey(dataColumnKey.getFullName()) : new ColumnKey(IndexUtils.getIndexFamily(indexTableMeta), dataColumnKey.getFullName());
        }
        if (indexTableMeta.isLocalIndex()) {
            return isPK ? new ColumnKey(dataColumnKey.getQualifier()) : new ColumnKey(IndexUtils.getIndexFamily(indexTableMeta), dataColumnKey.getQualifier());
        }
        return new ColumnKey(null, dataColumnKey.getQualifier());
    }

    public static boolean isColumnInIndex(TableMeta indexMeta, ColumnKey columnKey) {
        LColumn column = indexMeta.resolveColumnNoThrow(columnKey);
        if (column != null) {
            return true;
        }
        return indexMeta.getCoveredColumnType() == CoveredColumnType.DYNAMIC;
    }

    public static boolean isExpressionHitFunColumnIndex(Expression expression, TableMeta indexTable) {
        boolean result = false;
        try {
            for (int pos : indexTable.getFunctionColumnsPos()) {
                LColumn functionColumn = indexTable.getFunctionColumn(pos);
                FunctionCall funColumnFunCall = functionColumn.getColumnFunction();
                String funName = funColumnFunCall.getName();
                FunctionCall functionCall = null;
                if (expression instanceof FunctionCall) {
                    functionCall = (FunctionCall)expression;
                } else if (expression instanceof ComparisonExpressionV3) {
                    ComparisonExpressionV3 expressionV3 = (ComparisonExpressionV3)expression;
                    if (expressionV3.getLeft() instanceof FunctionCall) {
                        functionCall = (FunctionCall)expressionV3.getLeft();
                    } else if (expressionV3.getRight() instanceof FunctionCall) {
                        functionCall = (FunctionCall)expressionV3.getRight();
                    }
                }
                if (functionCall == null) continue;
                String expFunName = functionCall.getName();
                List<Expression> expFunArguments = functionCall.getArguments();
                List<Expression> funColumnArguments = funColumnFunCall.getArguments();
                if (funName == null || expFunName == null || !funName.startsWith(expFunName) || !funName.contains(expFunName) || !expFunArguments.equals(funColumnArguments)) continue;
                result = true;
                break;
            }
            return result;
        }
        catch (LindormException e) {
            throw new RuntimeException(e);
        }
    }

    public static LColumn resolveIndexColumnFromDataTable(ColumnKey dataColumnKey, TableMeta dataTableMeta) throws ColumnNotFoundException {
        LColumn colInDataTable = dataTableMeta.resolveColumnNoThrow(dataColumnKey);
        if (colInDataTable == null) {
            throw new ColumnNotFoundException("Column " + dataColumnKey.toString() + " not found in data table " + dataTableMeta.getTableName() + ", please check your DDL and retry.");
        }
        return colInDataTable;
    }

    public static CoveredColumnType resolveIndexCoveredColumnType(List<ColumnKey> coveredColumnsSchema) {
        CoveredColumnType ccType = CoveredColumnType.NONE;
        if (coveredColumnsSchema != null && coveredColumnsSchema.size() > 0) {
            ccType = coveredColumnsSchema.get(0) == LindormIndexDescriptor.COVERED_ALL_COLUMNS_IN_SCHEMA ? CoveredColumnType.ALL : (coveredColumnsSchema.get(0) == LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS ? CoveredColumnType.DYNAMIC : CoveredColumnType.SPECIFIC);
        }
        return ccType;
    }

    public static void createIndexTableSchema(LindormIndexDescriptor desc, TableMeta dataTableMeta, TableMeta indexTableMeta) throws LindormException {
        LColumn meta;
        List<LColumn> columnSchema = indexTableMeta.getAllColumns();
        List<LColumn> pksInDataTable = dataTableMeta.getPkColumns();
        List<IndexedColumnSchema> indexedColumnsSchema = desc.getIndexedColumns();
        List<ColumnKey> coveredColumnsSchema = desc.getCoveredColumns();
        TableType indexTableType = IndexUtils.resolveIndexTableType(desc, dataTableMeta);
        indexTableMeta.setType(indexTableType);
        CoveredColumnType ccType = IndexUtils.resolveIndexCoveredColumnType(desc.getCoveredColumns());
        indexTableMeta.setCoveredColumnType(ccType);
        HashSet<ColumnKey> indexPKColumnSet = CollectionUtils.newHashSetWithExpectedSize(pksInDataTable.size());
        int position = 0;
        for (IndexedColumnSchema ic : indexedColumnsSchema) {
            meta = LColumn.createIndexColumnMeta(ic, position, dataTableMeta, indexTableMeta);
            meta.setStoreNull(desc.isStorePkNulls());
            columnSchema.add(meta);
            indexPKColumnSet.add(meta.getDataColumnKey());
            ++position;
        }
        for (LColumn pk : pksInDataTable) {
            if (indexPKColumnSet.contains(pk.getColumnKey())) continue;
            meta = pk.deepCopy(position);
            if (desc.isLocalIndex()) {
                meta.setFamilyName(SchemaUtils.DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES);
            }
            meta.setDataColumnKey(pk.getColumnKey());
            meta.setDataColumnMeta(pk);
            meta.setStoreNull(desc.isStorePkNulls());
            columnSchema.add(meta);
            ++position;
        }
        columnSchema.add(SchemaUtils.getDefaultColumnMeta(indexTableMeta));
        if (ccType != CoveredColumnType.NONE && ccType == CoveredColumnType.SPECIFIC) {
            for (ColumnKey ck : coveredColumnsSchema) {
                meta = LColumn.createIndexColumnMeta(ck, dataTableMeta, indexTableMeta, position);
                ++position;
                columnSchema.add(meta);
            }
        }
    }

    public static TableType resolveIndexTableType(LindormIndexDescriptor desc, TableMeta dataTableMeta) throws LindormException {
        Mutability mutability = dataTableMeta.getTableAttributes().getMutability();
        List<IndexedColumnSchema> indexedColumnsSchema = desc.getIndexedColumns();
        if (null == indexedColumnsSchema || indexedColumnsSchema.isEmpty()) {
            throw new IllegalRequestException("There must be at least one IndexedColumnSchema, but has none.");
        }
        if (dataTableMeta.containsCollectionType() && mutability.equals((Object)Mutability.MUTABLE_ALL)) {
            throw new IllegalRequestException("Can not support create udt index when data columns have collection type ");
        }
        boolean localIndex = desc.isLocalIndex();
        if (IndexUtils.isPkReorderIndex(desc, dataTableMeta)) {
            switch (mutability) {
                case MUTABLE_ALL: {
                    return TableType.PK_REORDER_UDT_INDEX;
                }
            }
            return localIndex ? TableType.PK_REORDER_LOCAL_INDEX : TableType.PK_REORDER_INDEX;
        }
        if (IndexUtils.isSingleColumnIndex(desc, dataTableMeta)) {
            switch (mutability) {
                case MUTABLE_ALL: {
                    return TableType.SINGLE_COLUMN_UDT_INDEX;
                }
            }
            return localIndex ? TableType.SINGLE_COLUMN_LOCAL_INDEX : TableType.SINGLE_COLUMN_INDEX;
        }
        switch (mutability) {
            case MUTABLE_ALL: {
                return TableType.MULTI_COLUMN_UDT_INDEX;
            }
        }
        return localIndex ? TableType.MULTI_COLUMN_LOCAL_INDEX : TableType.MULTI_COLUMN_INDEX;
    }

    private static boolean isPkReorderIndex(LindormIndexDescriptor desc, TableMeta dataTableMeta) throws LindormException {
        List<IndexedColumnSchema> indexedColumnsSchema = desc.getIndexedColumns();
        for (IndexedColumnSchema ics : indexedColumnsSchema) {
            if (IndexUtils.isPrimaryKey(ics, dataTableMeta)) continue;
            return false;
        }
        return true;
    }

    private static int functionUsedNonPkColumns(TableMeta dataTableMeta, Expression exp) throws ColumnNotFoundException, IllegalRequestException {
        if (exp instanceof FunctionCall) {
            FunctionCall call = (FunctionCall)exp;
            int nonPkSize = 0;
            for (int i = 0; i < call.getArguments().size(); ++i) {
                nonPkSize += IndexUtils.functionUsedNonPkColumns(dataTableMeta, call.getArguments().get(i));
            }
            return nonPkSize;
        }
        if (exp instanceof Identifier) {
            LColumn column = dataTableMeta.resolveColumn(((Identifier)exp).toColumnKey());
            if (column != null && column.isPrimaryKey()) {
                return 0;
            }
            return 1;
        }
        if (exp instanceof Literal) {
            return 0;
        }
        throw new IllegalRequestException("Unsupported function index column: " + exp);
    }

    private static boolean isSingleColumnIndex(LindormIndexDescriptor desc, TableMeta dataTableMeta) throws LindormException {
        List<IndexedColumnSchema> indexedColumnsSchema = desc.getIndexedColumns();
        if (IndexUtils.isPrimaryKey(indexedColumnsSchema.get(0), dataTableMeta)) {
            return false;
        }
        for (int i = 1; i < indexedColumnsSchema.size(); ++i) {
            if (IndexUtils.isPrimaryKey(indexedColumnsSchema.get(i), dataTableMeta)) continue;
            return false;
        }
        return !indexedColumnsSchema.get(0).isFunctionColumn() || IndexUtils.functionUsedNonPkColumns(dataTableMeta, indexedColumnsSchema.get(0).getColumnFunction()) <= 1;
    }

    private static boolean isPrimaryKey(IndexedColumnSchema indexedColumnSchema, TableMeta dataTableMeta) throws LindormException {
        LColumn ret = dataTableMeta.resolveColumnNoThrow(indexedColumnSchema.getColumnKey());
        if (ret != null) {
            return ret.isPrimaryKey();
        }
        if (indexedColumnSchema.isFunctionColumn()) {
            return IndexUtils.functionUsedNonPkColumns(dataTableMeta, indexedColumnSchema.getColumnFunction()) == 0;
        }
        if (dataTableMeta.getTableAttributes().isDynamicColumnsEnabled()) {
            return false;
        }
        throw new ColumnNotFoundException(indexedColumnSchema.getColumnKey(), dataTableMeta.getNamespace(), dataTableMeta.getTableName());
    }

    public static String getIndexTableName(String dataTableName, String indexName) {
        String taskName = dataTableName + "." + indexName;
        return taskName;
    }

    public static String getIndexFullName(String namespace, String dataTable, String indexName) {
        return namespace + "." + IndexUtils.getIndexTableName(dataTable, indexName);
    }

    public static String getBuildIndexTaskName(String namespace, String dataTableName, String indexName) {
        String taskName = "building_index_" + namespace + "." + IndexUtils.getIndexTableName(dataTableName, indexName);
        return taskName;
    }

    public static String getBuildIndexJobName(String namespace, String dataTableName, String indexName) {
        String jobName = "building_index_v2." + namespace + "." + IndexUtils.getIndexTableName(dataTableName, indexName);
        return jobName;
    }

    public static String getBuildIndexSubJobName(String jobName, int index) {
        String subTaskName = jobName + "_" + index;
        return subTaskName;
    }

    public static String getBuildIndexArchiveJobName(String jobName, long jobCreateTime) {
        return jobName + '.' + jobCreateTime;
    }

    public static ExternalIndexRowFormatterType getFormatterType(TableMeta tableMeta) {
        List<LColumn> columns = tableMeta.getPkColumns();
        for (LColumn lColumn : columns) {
            if (DataType.STRING.equals((Object)lColumn.getDataType().getClientType()) && !SortOrder.DESC.equals((Object)lColumn.getSortOrder()) && !PrimaryKeyOption.HASHED.equals((Object)lColumn.getPkOption())) continue;
            return ExternalIndexRowFormatterType.HEX;
        }
        return ExternalIndexRowFormatterType.STRING;
    }
}

