/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;

public class RatedLog
implements Log {
    private static final long DEFAULT_TIME_SLICE = 3000L;
    private final Log log;
    private final long timeSlice;
    private volatile long sliceEndTime = -1L;
    private long maxMessagesPerSlice;
    private AtomicInteger messageCount = new AtomicInteger(0);

    public RatedLog(Log log, int maxRate) {
        this(log, maxRate, 3000L);
    }

    public RatedLog(Log log, int maxRate, long timeSlice) {
        this(log, maxRate, timeSlice, true);
    }

    public RatedLog(Log log, int val, long timeSlice, boolean isRate) {
        this.timeSlice = timeSlice;
        this.log = log;
        this.maxMessagesPerSlice = isRate ? (long)val * (timeSlice / 1000L) : (long)val;
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void trace(Object message) {
        if (this.isLoggable()) {
            this.log.trace(message);
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isLoggable()) {
            this.log.trace(message, t);
        }
    }

    public void debug(Object message) {
        if (this.isLoggable()) {
            this.log.debug(message);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isLoggable()) {
            this.log.debug(message, t);
        }
    }

    public void info(Object message) {
        if (this.isLoggable()) {
            this.log.info(message);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isLoggable()) {
            this.log.info(message, t);
        }
    }

    public void warn(Object message) {
        if (this.isLoggable()) {
            this.log.warn(message);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isLoggable()) {
            this.log.warn(message, t);
        }
    }

    public void error(Object message) {
        if (this.isLoggable()) {
            this.log.error(message);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isLoggable()) {
            this.log.error(message, t);
        }
    }

    public void fatal(Object message) {
        if (this.isLoggable()) {
            this.log.fatal(message);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isLoggable()) {
            this.log.fatal(message, t);
        }
    }

    public boolean isLoggable() {
        if (this.maxMessagesPerSlice <= 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now > this.sliceEndTime) {
            this.sliceEndTime = now + this.timeSlice;
            this.messageCount.set(1);
            return true;
        }
        return (long)this.messageCount.incrementAndGet() <= this.maxMessagesPerSlice;
    }
}

