/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.LikeExpression;
import com.alibaba.lindorm.client.core.expression.NotLikeExpression;
import com.alibaba.lindorm.client.core.search.SearchQuery;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ConditionParseConstants;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleConditionParser {
    public static final String COMPARE_EXPRESSION_NAME = "EXP";
    public static final String LIKE_EXPRESSION_NAME = "LIKE";
    public static final String NOT_LIKE_EXPRESSION_NAME = "NOT_LIKE";
    public static final String SEARCH_QUERY_NAME = "SEARCH";
    private static final Log LOG = LogFactory.getLog(SimpleConditionParser.class);
    private static ConditionFactory FACTORY = new ConditionFactory();
    private static HashMap<ByteBuffer, Integer> operatorPrecedenceHashMap;
    private static HashMap<String, String> conditionHashMap;

    public Condition parseConditionString(String conditionString) throws CharacterCodingException, IllegalRequestException {
        return this.parseConditionString(Bytes.toBytes(conditionString));
    }

    public SearchQuery parseSearchQueryString(String searchQueryString) {
        Map<String, String> queryMap = this.parseSearchQueryString2Map(searchQueryString);
        return new SearchQuery(queryMap);
    }

    public Condition parseConditionString(byte[] conditionStringAsByteArray) throws CharacterCodingException, IllegalRequestException {
        Stack<ByteBuffer> operatorStack = new Stack<ByteBuffer>();
        Stack<Condition> conditionStack = new Stack<Condition>();
        Condition condition = null;
        for (int i = 0; i < conditionStringAsByteArray.length; ++i) {
            if (conditionStringAsByteArray[i] == 40) {
                operatorStack.push(ConditionParseConstants.LPAREN_BUFFER);
                continue;
            }
            if (conditionStringAsByteArray[i] == 32 || conditionStringAsByteArray[i] == 9) continue;
            if (SimpleConditionParser.checkForOr(conditionStringAsByteArray, i)) {
                i += ConditionParseConstants.OR_ARRAY.length - 1;
                this.reduce(operatorStack, conditionStack, ConditionParseConstants.OR_BUFFER);
                operatorStack.push(ConditionParseConstants.OR_BUFFER);
                continue;
            }
            if (SimpleConditionParser.checkForAnd(conditionStringAsByteArray, i)) {
                i += ConditionParseConstants.AND_ARRAY.length - 1;
                this.reduce(operatorStack, conditionStack, ConditionParseConstants.AND_BUFFER);
                operatorStack.push(ConditionParseConstants.AND_BUFFER);
                continue;
            }
            if (conditionStringAsByteArray[i] == 41) {
                if (operatorStack.empty()) {
                    throw new IllegalArgumentException("Mismatched parenthesis");
                }
                ByteBuffer argumentOnTopOfStack = operatorStack.peek();
                while (!argumentOnTopOfStack.equals(ConditionParseConstants.LPAREN_BUFFER)) {
                    conditionStack.push(SimpleConditionParser.popArguments(operatorStack, conditionStack));
                    if (operatorStack.empty()) {
                        throw new IllegalArgumentException("Mismatched parenthesis");
                    }
                    argumentOnTopOfStack = operatorStack.pop();
                }
                continue;
            }
            byte[] conditionSimpleExpression = this.extractConditionSimpleExpression(conditionStringAsByteArray, i);
            i += conditionSimpleExpression.length - 1;
            condition = this.parseSimpleConditionExpression(conditionSimpleExpression);
            conditionStack.push(condition);
        }
        while (!operatorStack.empty()) {
            conditionStack.push(SimpleConditionParser.popArguments(operatorStack, conditionStack));
        }
        condition = (Condition)conditionStack.pop();
        if (!conditionStack.empty()) {
            throw new IllegalArgumentException("Incorrect Condition String");
        }
        return condition;
    }

    private Map<String, String> parseSearchQueryString2Map(String searchQueryString) {
        String realSearchQuery = this.getRealSearchQueryString(searchQueryString);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        StringBuilder str = new StringBuilder();
        String key = null;
        String value = null;
        int len = realSearchQuery.length();
        for (int i = 0; i < len; ++i) {
            char c = realSearchQuery.charAt(i);
            if (c == '=') {
                key = str.toString();
                str = new StringBuilder();
                continue;
            }
            if (c == '\'') {
                while (i++ < len && (realSearchQuery.charAt(i) != '\'' || realSearchQuery.charAt(i - 1) == '\\')) {
                    str.append(realSearchQuery.charAt(i));
                }
                value = str.toString().replace("\\", "");
                if (key != null) {
                    queryMap.put(key, value);
                }
                str = new StringBuilder();
                continue;
            }
            if (c == ' ' || c == ',') continue;
            str.append(c);
        }
        this.mapResultProcess(queryMap, realSearchQuery, value);
        return queryMap;
    }

    private String getRealSearchQueryString(String searchQueryString) {
        int i;
        int start = 0;
        int end = 0;
        int len = searchQueryString.length();
        for (i = 0; i < len; ++i) {
            if (searchQueryString.charAt(i) != '(') continue;
            start = i;
            break;
        }
        for (i = len - 1; i >= 0; --i) {
            if (searchQueryString.charAt(i) != ')') continue;
            end = i;
            break;
        }
        if (start == 0 || end == 0) {
            throw new IllegalArgumentException("Incorrect SearchQuery String");
        }
        return searchQueryString.substring(start + 1, end);
    }

    private void mapResultProcess(Map<String, String> queryMap, String realSearchQuery, String value) {
        if (!queryMap.isEmpty()) {
            return;
        }
        String mapValue = value == null ? realSearchQuery : value;
        queryMap.put("q", mapValue);
    }

    public byte[] extractConditionSimpleExpression(byte[] conditionStringAsByteArray, int conditionExpressionStartOffset) throws CharacterCodingException {
        int quoteCount = 0;
        for (int i = conditionExpressionStartOffset; i < conditionStringAsByteArray.length; ++i) {
            if (conditionStringAsByteArray[i] == 39) {
                if (SimpleConditionParser.isQuoteUnescaped(conditionStringAsByteArray, i)) {
                    ++quoteCount;
                } else {
                    ++i;
                }
            }
            if (conditionStringAsByteArray[i] != 41 || quoteCount % 2 != 0) continue;
            byte[] conditionSimpleExpression = new byte[i - conditionExpressionStartOffset + 1];
            Bytes.putBytes(conditionSimpleExpression, 0, conditionStringAsByteArray, conditionExpressionStartOffset, i - conditionExpressionStartOffset + 1);
            return conditionSimpleExpression;
        }
        throw new IllegalArgumentException("Incorrect Condition String");
    }

    public Condition parseSimpleConditionExpression(byte[] conditionStringAsByteArray) throws CharacterCodingException {
        String conditionName = Bytes.toString(SimpleConditionParser.getConditionName(conditionStringAsByteArray));
        ArrayList<byte[]> conditionArguments = SimpleConditionParser.getConditionArguments(conditionStringAsByteArray);
        if (!conditionHashMap.containsKey(conditionName)) {
            throw new IllegalArgumentException("Condition Name " + conditionName + " not supported");
        }
        try {
            conditionName = conditionHashMap.get(conditionName);
            Class<?> c = Class.forName(conditionName);
            Class[] argTypes = new Class[]{ArrayList.class};
            Method m = c.getDeclaredMethod("createConditionFromArguments", argTypes);
            return (Condition)m.invoke(null, conditionArguments);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Incorrect condition string " + new String(conditionStringAsByteArray), e);
        }
    }

    public static byte[] getConditionName(byte[] conditionStringAsByteArray) {
        int conditionNameStartIndex = 0;
        int conditionNameEndIndex = 0;
        for (int i = conditionNameStartIndex; i < conditionStringAsByteArray.length; ++i) {
            if (conditionStringAsByteArray[i] != 40 && conditionStringAsByteArray[i] != 32) continue;
            conditionNameEndIndex = i;
            break;
        }
        if (conditionNameEndIndex == 0) {
            throw new IllegalArgumentException("Incorrect Condition Name");
        }
        byte[] conditionName = new byte[conditionNameEndIndex - conditionNameStartIndex];
        Bytes.putBytes(conditionName, 0, conditionStringAsByteArray, 0, conditionNameEndIndex - conditionNameStartIndex);
        return conditionName;
    }

    public static ArrayList<byte[]> getConditionArguments(byte[] conditionStringAsByteArray) {
        int argumentListStartIndex = SimpleConditionParser.getDelimiter(conditionStringAsByteArray, 0, conditionStringAsByteArray.length, 40);
        if (argumentListStartIndex == -1) {
            throw new IllegalArgumentException("Incorrect argument list");
        }
        int argumentStartIndex = 0;
        int argumentEndIndex = 0;
        ArrayList<byte[]> conditionArguments = new ArrayList<byte[]>();
        block0: for (int i = argumentListStartIndex + 1; i < conditionStringAsByteArray.length; ++i) {
            byte[] conditionArgument;
            int j;
            if (conditionStringAsByteArray[i] == 32 || conditionStringAsByteArray[i] == 44 || conditionStringAsByteArray[i] == 41) continue;
            if (conditionStringAsByteArray[i] == 39) {
                argumentStartIndex = i;
                for (j = argumentStartIndex + 1; j < conditionStringAsByteArray.length; ++j) {
                    if (conditionStringAsByteArray[j] == 39) {
                        if (SimpleConditionParser.isQuoteUnescaped(conditionStringAsByteArray, j)) {
                            argumentEndIndex = j;
                            i = j + 1;
                            conditionArgument = SimpleConditionParser.createUnescapdArgument(conditionStringAsByteArray, argumentStartIndex, argumentEndIndex);
                            conditionArguments.add(conditionArgument);
                            continue block0;
                        }
                        ++j;
                        continue;
                    }
                    if (j != conditionStringAsByteArray.length - 1) continue;
                    throw new IllegalArgumentException("Incorrect argument list");
                }
                continue;
            }
            for (j = argumentStartIndex = i; j < conditionStringAsByteArray.length; ++j) {
                if (conditionStringAsByteArray[j] == 32 || conditionStringAsByteArray[j] == 44 || conditionStringAsByteArray[j] == 41) {
                    argumentEndIndex = j - 1;
                    i = j;
                    conditionArgument = new byte[argumentEndIndex - argumentStartIndex + 1];
                    Bytes.putBytes(conditionArgument, 0, conditionStringAsByteArray, argumentStartIndex, argumentEndIndex - argumentStartIndex + 1);
                    conditionArguments.add(conditionArgument);
                    continue block0;
                }
                if (j != conditionStringAsByteArray.length - 1) continue;
                throw new IllegalArgumentException("Incorrect argument list");
            }
        }
        return conditionArguments;
    }

    public void reduce(Stack<ByteBuffer> operatorStack, Stack<Condition> conditionStack, ByteBuffer operator) throws IllegalRequestException {
        while (!operatorStack.empty() && !ConditionParseConstants.LPAREN_BUFFER.equals(operatorStack.peek()) && this.hasHigherPriority(operatorStack.peek(), operator)) {
            conditionStack.push(SimpleConditionParser.popArguments(operatorStack, conditionStack));
        }
    }

    public static Condition popArguments(Stack<ByteBuffer> operatorStack, Stack<Condition> conditionStack) throws IllegalRequestException {
        ByteBuffer argumentOnTopOfStack = operatorStack.peek();
        if (argumentOnTopOfStack.equals(ConditionParseConstants.OR_BUFFER)) {
            try {
                Condition condition;
                ArrayList<Condition> listOfConditions = new ArrayList<Condition>();
                while (!operatorStack.empty() && operatorStack.peek().equals(ConditionParseConstants.OR_BUFFER)) {
                    condition = conditionStack.pop();
                    listOfConditions.add(0, condition);
                    operatorStack.pop();
                }
                condition = conditionStack.pop();
                listOfConditions.add(0, condition);
                ConditionList orCondition = FACTORY.or();
                for (Condition c : listOfConditions) {
                    orCondition.add(c);
                }
                return orCondition;
            }
            catch (EmptyStackException e) {
                throw new IllegalArgumentException("Incorrect input string - an OR needs two conditions");
            }
        }
        if (argumentOnTopOfStack.equals(ConditionParseConstants.AND_BUFFER)) {
            try {
                Condition condition;
                ArrayList<Condition> listOfConditions = new ArrayList<Condition>();
                while (!operatorStack.empty() && operatorStack.peek().equals(ConditionParseConstants.AND_BUFFER)) {
                    condition = conditionStack.pop();
                    listOfConditions.add(0, condition);
                    operatorStack.pop();
                }
                condition = conditionStack.pop();
                listOfConditions.add(0, condition);
                ConditionList andCondition = FACTORY.and();
                for (Condition c : listOfConditions) {
                    andCondition.add(c);
                }
                return andCondition;
            }
            catch (EmptyStackException e) {
                throw new IllegalArgumentException("Incorrect input string - an AND needs two conditions");
            }
        }
        if (argumentOnTopOfStack.equals(ConditionParseConstants.LPAREN_BUFFER)) {
            try {
                Condition condition = conditionStack.pop();
                operatorStack.pop();
                return condition;
            }
            catch (EmptyStackException e) {
                throw new IllegalArgumentException("Incorrect Condition String");
            }
        }
        throw new IllegalArgumentException("Incorrect arguments on operatorStack");
    }

    public boolean hasHigherPriority(ByteBuffer a, ByteBuffer b) {
        return operatorPrecedenceHashMap.get(a) - operatorPrecedenceHashMap.get(b) < 0;
    }

    public static byte[] createUnescapdArgument(byte[] conditionStringAsByteArray, int argumentStartIndex, int argumentEndIndex) {
        int unescapedArgumentLength = 2;
        for (int i = argumentStartIndex + 1; i <= argumentEndIndex - 1; ++i) {
            ++unescapedArgumentLength;
            if (conditionStringAsByteArray[i] != 39 || i == argumentEndIndex - 1 || conditionStringAsByteArray[i + 1] != 39) continue;
            ++i;
        }
        byte[] unescapedArgument = new byte[unescapedArgumentLength];
        int count = 1;
        unescapedArgument[0] = 39;
        for (int i = argumentStartIndex + 1; i <= argumentEndIndex - 1; ++i) {
            if (conditionStringAsByteArray[i] == 39 && i != argumentEndIndex - 1 && conditionStringAsByteArray[i + 1] == 39) {
                unescapedArgument[count++] = conditionStringAsByteArray[i + 1];
                ++i;
                continue;
            }
            unescapedArgument[count++] = conditionStringAsByteArray[i];
        }
        unescapedArgument[unescapedArgumentLength - 1] = 39;
        return unescapedArgument;
    }

    public static boolean checkForOr(byte[] conditionStringAsByteArray, int indexOfOr) throws CharacterCodingException, ArrayIndexOutOfBoundsException {
        try {
            return !(conditionStringAsByteArray[indexOfOr] != 79 || conditionStringAsByteArray[indexOfOr + 1] != 82 || conditionStringAsByteArray[indexOfOr - 1] != 32 && conditionStringAsByteArray[indexOfOr - 1] != 41 || conditionStringAsByteArray[indexOfOr + 2] != 32 && conditionStringAsByteArray[indexOfOr + 2] != 40);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean checkForAnd(byte[] conditionStringAsByteArray, int indexOfAnd) throws CharacterCodingException {
        try {
            return !(conditionStringAsByteArray[indexOfAnd] != 65 || conditionStringAsByteArray[indexOfAnd + 1] != 78 || conditionStringAsByteArray[indexOfAnd + 2] != 68 || conditionStringAsByteArray[indexOfAnd - 1] != 32 && conditionStringAsByteArray[indexOfAnd - 1] != 41 || conditionStringAsByteArray[indexOfAnd + 3] != 32 && conditionStringAsByteArray[indexOfAnd + 3] != 40);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean isQuoteUnescaped(byte[] array, int quoteIndex) {
        if (array == null) {
            throw new IllegalArgumentException("isQuoteUnescaped called with a null array");
        }
        return quoteIndex == array.length - 1 || array[quoteIndex + 1] != 39;
    }

    public static byte[] removeQuotesFromByteArray(byte[] quotedByteArray) {
        if (quotedByteArray == null || quotedByteArray.length < 2 || quotedByteArray[0] != 39 || quotedByteArray[quotedByteArray.length - 1] != 39) {
            throw new IllegalArgumentException("removeQuotesFromByteArray needs a quoted byte array");
        }
        byte[] targetString = new byte[quotedByteArray.length - 2];
        Bytes.putBytes(targetString, 0, quotedByteArray, 1, quotedByteArray.length - 2);
        return targetString;
    }

    public static boolean hasQuotesOnByteArray(byte[] quotedByteArray) {
        if (quotedByteArray == null || quotedByteArray.length < 2) {
            return false;
        }
        return quotedByteArray[0] == 39 && quotedByteArray[quotedByteArray.length - 1] == 39;
    }

    public static float convertByteArrayToFloat(byte[] numberAsByteArray) {
        if (numberAsByteArray == null) {
            throw new IllegalArgumentException("convertByteArrayToFloat called with a null array");
        }
        return Float.parseFloat(Bytes.toString(numberAsByteArray));
    }

    public static double convertByteArrayToDouble(byte[] numberAsByteArray) {
        if (numberAsByteArray == null) {
            throw new IllegalArgumentException("convertByteArrayToFloat called with a null array");
        }
        return Double.parseDouble(Bytes.toString(numberAsByteArray));
    }

    public static short convertByteArrayToShort(byte[] numberAsByteArray) {
        long tempResult = SimpleConditionParser.convertByteArrayToLong(numberAsByteArray);
        if (tempResult > 32767L) {
            throw new IllegalArgumentException("Short Argument too large");
        }
        if (tempResult < -32768L) {
            throw new IllegalArgumentException("Short Argument too small");
        }
        short result = (short)tempResult;
        return result;
    }

    public static int convertByteArrayToInt(byte[] numberAsByteArray) {
        long tempResult = SimpleConditionParser.convertByteArrayToLong(numberAsByteArray);
        if (tempResult > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer Argument too large");
        }
        if (tempResult < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Integer Argument too small");
        }
        int result = (int)tempResult;
        return result;
    }

    public static long convertByteArrayToLong(byte[] numberAsByteArray) {
        if (numberAsByteArray == null) {
            throw new IllegalArgumentException("convertByteArrayToLong called with a null array");
        }
        int i = 0;
        long result = 0L;
        boolean isNegative = false;
        if (numberAsByteArray[i] == 45) {
            ++i;
            isNegative = true;
        }
        while (i != numberAsByteArray.length) {
            if (numberAsByteArray[i] < 48 || numberAsByteArray[i] > 57) {
                throw new IllegalArgumentException("Byte Array should only contain digits");
            }
            if ((result = result * 10L + (long)(numberAsByteArray[i] - 48)) < 0L) {
                throw new IllegalArgumentException("Long Argument too large");
            }
            ++i;
        }
        if (isNegative) {
            return -result;
        }
        return result;
    }

    public static Object convertByteArrayToNumberOrString(byte[] numberAsByteArray) {
        if (numberAsByteArray == null) {
            throw new IllegalArgumentException("convertByteArrayToNumber called with a null array");
        }
        String numberStr = Bytes.toString(numberAsByteArray);
        try {
            return Long.parseLong(numberStr);
        }
        catch (Exception exception) {
            try {
                return Double.parseDouble(numberStr);
            }
            catch (Exception exception2) {
                return numberStr;
            }
        }
    }

    public static boolean convertByteArrayToBoolean(byte[] booleanAsByteArray) {
        if (booleanAsByteArray == null) {
            throw new IllegalArgumentException("convertByteArrayToBoolean called with a null array");
        }
        if (!(booleanAsByteArray.length != 4 || booleanAsByteArray[0] != 116 && booleanAsByteArray[0] != 84 || booleanAsByteArray[1] != 114 && booleanAsByteArray[1] != 82 || booleanAsByteArray[2] != 117 && booleanAsByteArray[2] != 85 || booleanAsByteArray[3] != 101 && booleanAsByteArray[3] != 69)) {
            return true;
        }
        if (!(booleanAsByteArray.length != 5 || booleanAsByteArray[0] != 102 && booleanAsByteArray[0] != 70 || booleanAsByteArray[1] != 97 && booleanAsByteArray[1] != 65 || booleanAsByteArray[2] != 108 && booleanAsByteArray[2] != 76 || booleanAsByteArray[3] != 115 && booleanAsByteArray[3] != 83 || booleanAsByteArray[4] != 101 && booleanAsByteArray[4] != 69)) {
            return false;
        }
        throw new IllegalArgumentException("Incorrect Boolean Expression");
    }

    public static boolean isBooleanByteArray(byte[] booleanAsByteArray) {
        if (booleanAsByteArray == null) {
            return false;
        }
        if (!(booleanAsByteArray.length != 4 || booleanAsByteArray[0] != 116 && booleanAsByteArray[0] != 84 || booleanAsByteArray[1] != 114 && booleanAsByteArray[1] != 82 || booleanAsByteArray[2] != 117 && booleanAsByteArray[2] != 85 || booleanAsByteArray[3] != 101 && booleanAsByteArray[3] != 69)) {
            return true;
        }
        return !(booleanAsByteArray.length != 5 || booleanAsByteArray[0] != 102 && booleanAsByteArray[0] != 70 || booleanAsByteArray[1] != 97 && booleanAsByteArray[1] != 65 || booleanAsByteArray[2] != 108 && booleanAsByteArray[2] != 76 || booleanAsByteArray[3] != 115 && booleanAsByteArray[3] != 83 || booleanAsByteArray[4] != 101 && booleanAsByteArray[4] != 69);
    }

    public static ConditionFactory.CompareOp createCompareOp(byte[] compareOpAsByteArray) {
        ByteBuffer compareOp = ByteBuffer.wrap(compareOpAsByteArray);
        if (compareOp.equals(ConditionParseConstants.LESS_THAN_BUFFER)) {
            return ConditionFactory.CompareOp.LESS;
        }
        if (compareOp.equals(ConditionParseConstants.LESS_THAN_OR_EQUAL_TO_BUFFER)) {
            return ConditionFactory.CompareOp.LESS_OR_EQUAL;
        }
        if (compareOp.equals(ConditionParseConstants.GREATER_THAN_BUFFER)) {
            return ConditionFactory.CompareOp.GREATER;
        }
        if (compareOp.equals(ConditionParseConstants.GREATER_THAN_OR_EQUAL_TO_BUFFER)) {
            return ConditionFactory.CompareOp.GREATER_OR_EQUAL;
        }
        if (compareOp.equals(ConditionParseConstants.NOT_EQUAL_TO_BUFFER)) {
            return ConditionFactory.CompareOp.NOT_EQUAL;
        }
        if (compareOp.equals(ConditionParseConstants.EQUAL_TO_BUFFER)) {
            return ConditionFactory.CompareOp.EQUAL;
        }
        if (compareOp.equals(ConditionParseConstants.IS_TO_BUFFER)) {
            return ConditionFactory.CompareOp.IS;
        }
        if (compareOp.equals(ConditionParseConstants.IS_NOT_TO_BUFFER)) {
            return ConditionFactory.CompareOp.IS_NOT;
        }
        throw new IllegalArgumentException("Invalid compare operator");
    }

    public static byte[] convertCompareOpToByteArray(ConditionFactory.CompareOp op) {
        switch (op) {
            case LESS: {
                return ConditionParseConstants.LESS_THAN_ARRAY;
            }
            case LESS_OR_EQUAL: {
                return ConditionParseConstants.LESS_THAN_OR_EQUAL_TO_ARRAY;
            }
            case GREATER: {
                return ConditionParseConstants.GREATER_THAN_ARRAY;
            }
            case GREATER_OR_EQUAL: {
                return ConditionParseConstants.GREATER_THAN_OR_EQUAL_TO_ARRAY;
            }
            case NOT_EQUAL: {
                return ConditionParseConstants.NOT_EQUAL_TO_ARRAY;
            }
            case EQUAL: {
                return ConditionParseConstants.EQUAL_TO_ARRAY;
            }
            case IS: {
                return ConditionParseConstants.IS_TO_ARRAY;
            }
            case IS_NOT: {
                return ConditionParseConstants.IS_NOT_TO_ARRAY;
            }
        }
        throw new IllegalArgumentException("Invalid compare operator");
    }

    public static byte[][] parseComparator(byte[] comparator) {
        int index = SimpleConditionParser.getDelimiter(comparator, 0, comparator.length, 58);
        if (index == -1) {
            throw new IllegalArgumentException("Incorrect comparator");
        }
        byte[][] result = new byte[2][0];
        result[0] = new byte[index];
        System.arraycopy(comparator, 0, result[0], 0, index);
        int len = comparator.length - (index + 1);
        result[1] = new byte[len];
        System.arraycopy(comparator, index + 1, result[1], 0, len);
        return result;
    }

    public Set<String> getSupportedConditions() {
        return conditionHashMap.keySet();
    }

    public static Map<String, String> getAllConditions() {
        return Collections.unmodifiableMap(conditionHashMap);
    }

    public static void registerCondition(String name, String conditionClass) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Registering new condition " + name));
        }
        conditionHashMap.put(name, conditionClass);
    }

    public static int getDelimiter(byte[] b, int offset, int length, int delimiter) {
        if (b == null) {
            throw new IllegalArgumentException("Passed buffer is null");
        }
        int result = -1;
        for (int i = offset; i < length + offset; ++i) {
            if (b[i] != delimiter) continue;
            result = i;
            break;
        }
        return result;
    }

    public static void similarityCheck(ArrayList<byte[]> conditionArguments) {
        int size = conditionArguments.size();
        Preconditions.checkArgument(size == 2 || size == 3, "Expected 2 or 3 but got: %s", size);
    }

    public static byte[] getSimilarityColumnName(ArrayList<byte[]> conditionArguments) {
        boolean columnHasQuotes = SimpleConditionParser.hasQuotesOnByteArray(conditionArguments.get(0));
        return columnHasQuotes ? SimpleConditionParser.removeQuotesFromByteArray(conditionArguments.get(0)) : conditionArguments.get(0);
    }

    public static byte[] getSimilarityPattern(ArrayList<byte[]> conditionArguments) {
        boolean patternHasQuotes = SimpleConditionParser.hasQuotesOnByteArray(conditionArguments.get(1));
        return patternHasQuotes ? SimpleConditionParser.removeQuotesFromByteArray(conditionArguments.get(1)) : conditionArguments.get(1);
    }

    public static Character getSimilarityEscapeCharacter(ArrayList<byte[]> conditionArguments) {
        Character escapeCharacter = null;
        if (conditionArguments.size() == 3) {
            byte[] escapeBytes;
            boolean escapeHasQuotes = SimpleConditionParser.hasQuotesOnByteArray(conditionArguments.get(2));
            byte[] byArray = escapeBytes = escapeHasQuotes ? SimpleConditionParser.removeQuotesFromByteArray(conditionArguments.get(2)) : conditionArguments.get(2);
            if (escapeBytes.length != 1) {
                throw new IllegalArgumentException("escape character not an expected character");
            }
            escapeCharacter = Character.valueOf(Bytes.toString(escapeBytes).charAt(0));
        }
        return escapeCharacter;
    }

    static {
        conditionHashMap = new HashMap();
        conditionHashMap.put(COMPARE_EXPRESSION_NAME, ComparisonExpression.class.getName());
        conditionHashMap.put(LIKE_EXPRESSION_NAME, LikeExpression.class.getName());
        conditionHashMap.put(NOT_LIKE_EXPRESSION_NAME, NotLikeExpression.class.getName());
        operatorPrecedenceHashMap = new HashMap();
        operatorPrecedenceHashMap.put(ConditionParseConstants.AND_BUFFER, 2);
        operatorPrecedenceHashMap.put(ConditionParseConstants.OR_BUFFER, 3);
    }
}

